﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ApiControl
{
    #region 签名传参实体
    public class DataStr
    {
        /// <summary>
        /// 签名
        /// </summary>
        public string sign { get; set; }

        /// <summary>
        /// 调用系统帐号
        /// </summary>
        public string appId { get; set; }

        /// <summary>
        /// Json数据
        /// </summary>
        public string data { get; set; }
    }
    #endregion

    #region 自定义查询实体
    public class QueryTable
    {
        /// <summary>
        /// 查询的表名
        /// </summary>
        public string table { get; set; }

        /// <summary>
        /// 查询字段列
        /// </summary>
        public string fields { get; set; }

        /// <summary>
        /// 查询键值对
        /// </summary>
        public List<ConditionDetail> key_value { get; set; }
    }
    #endregion

    #region 自定义修改实体
    public class UpdateTable
    {
        /// <summary>
        /// 更新的表名
        /// </summary>
        public string table { get; set; }

        /// <summary>
        /// 操作人
        /// </summary>
        public string user { get; set; }

        /// <summary>
        /// 更新字段列
        /// </summary>
        public List<UpdateColumn> col { get; set; }

        /// <summary>
        /// 查询键值对
        /// </summary>
        public List<ConditionDetail> key_value { get; set; }
    }

    public class UpdateColumn
    {
        /// <summary>
        /// 更新列键
        /// </summary>
        public string key { get; set; }

        /// <summary>
        /// 更新列值
        /// </summary>
        public string val { get; set; }
    }
    #endregion

    #region 执行条件公用实体
    public class ConditionDetail
    {
        /// <summary>
        /// 字段名
        /// </summary>
        public string key { get; set; }

        /// <summary>
        /// 字段值
        /// </summary>
        public string val { get; set; }

        /// <summary>
        /// 条件类型0 自定义 1 = 2 != 3 like 4 in
        /// </summary>
        public int cdn { get; set; }
    }
    #endregion
}
