﻿using API.Services.ProductManageServices;
using ApiControl;
using DbConn;
using Newtonsoft.Json;
using Petapoco.Custom.HqygDto;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using static Petapoco.Custom.HqygDto.ApiProductAdd;

namespace API.Services.HqygManageServices
{
    public class PdmDataServices
    {
        public static string code = "SYB0013";
        public static string key = "d71c26@abebad%bce64*!28bb6fea<";
        public static string hqygou = System.Configuration.ConfigurationManager.AppSettings["hqygou"];
        public static string BaiLunBi = System.AppDomain.CurrentDomain.BaseDirectory.TrimEnd('\\');   //这里路径应指向PMS系统路径

        #region 产品信息操作
        public static ApiResult BindProductAdd(yt_product_base entity)
        {
            ApiResult result = new ApiResult();

            if (entity.s_isfinish != 1 && entity.s_isfinish != 5)
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "非成品无法上传至环球";
            }

            //半成品商品不上传到环球
            if (entity.s_id > 0)
            {
                ApiProductAdd obj = new ApiProductAdd();
                obj.company = code;
                obj.method = "manage.Product.Add";
                obj.category_id = GetCategoryMapping(entity.s_category_id.Value);
                obj.declare_name_cn = entity.s_cbaoguan;
                obj.declare_name_en = entity.s_ebaoguan;
                obj.custom_sn = entity.s_hscode;
                obj.charger_spec = entity.s_charger_spec.ToString();
                obj.character_ids = entity.s_product_character;

                List<ProductSandard> specsList = new List<ProductSandard>();
                ProductSandard model = new ProductSandard();
                model.id = entity.s_id;
                model.color = entity.s_color;
                model.size = entity.s_size;
                if (!string.IsNullOrWhiteSpace(entity.s_size1))
                    model.size += "/" + entity.s_size1;
                if (!string.IsNullOrWhiteSpace(entity.s_size2))
                    model.size += "/" + entity.s_size2;
                model.product_name = entity.s_ctitle;
                model.product_name_en = entity.s_etitle;
                model.purchase_price = entity.s_price.Value;
                model.currency_code = entity.s_currency;
                model.product_weight = entity.s_weight.Value / 1000;  //转为千克
                model.actual_weight = model.product_weight + (entity.s_packing_weight ?? 0) / 1000;    //转为千克

                if (entity.s_product_size != null)
                {
                    string[] arraySize = entity.s_product_size.Split(',');
                    model.product_length = Convert.ToDecimal(arraySize[0]);
                    model.product_width = Convert.ToDecimal(arraySize[1]);
                    model.product_height = Convert.ToDecimal(arraySize[2]);
                }

                if (entity.s_packing_size != null)
                {
                    string[] arrayPacking = entity.s_packing_size.Split(',');
                    model.package_length = Convert.ToDecimal(arrayPacking[0]);
                    model.package_width = Convert.ToDecimal(arrayPacking[1]);
                    model.package_height = Convert.ToDecimal(arrayPacking[2]);
                }

                try
                {
                    if (false)
                    {
                        //获取接口图片，优先用主图
                        if (string.IsNullOrWhiteSpace(entity.s_main_image))
                        {
                            var imgUrlArr = entity.s_main_image.Split(',');
                            var url = BaiLunBi + imgUrlArr[0].Replace('/', '\\');
                            var imgUrl = HqygDataServices.UploadFileImage(url);
                            model.image_path = imgUrl;
                        }
                        else
                        {
                            if (string.IsNullOrWhiteSpace(entity.s_child_image))
                            {
                                var imgUrlArr = entity.s_child_image.Split(',');
                                var url = BaiLunBi + imgUrlArr[0].Replace('/', '\\');
                                var imgUrl = HqygDataServices.UploadFileImage(url);
                                model.image_path = imgUrl;
                            }
                        }
                    }

                }
                catch (Exception ex)
                {
                    result = ApiDataManage.CreateApiResult(500);
                    result.result_msg = ex.Message;
                }
                specsList.Add(model);

                obj.specs = specsList;
                //如果已上传则调用复制同款接口
                ResultProductInfo resultInfo = new ResultProductInfo();
                var objCopy = yt_product_base.FirstOrDefault(" select * from (select a.* from yt_product_base as a LEFT JOIN yt_product_state as b on a.s_id = b.st_sid"
                            + " where a.s_goods_code = @0 and b.st_isupapi = 1) as a", entity.s_goods_code);

                if (objCopy != null)
                {
                    obj.method = "manage.Product.Copy";
                    obj.product_sn = objCopy.s_product;
                    resultInfo = ManageProductCopy(obj);
                }
                else
                {
                    resultInfo = ManageProductAdd(obj);
                }

                if (resultInfo.response)
                {
                    var list = resultInfo.result.ToList();
                    var listBase = new List<yt_product_base>();
                    var listExploit = new List<yt_product_exploit>();
                    var listState = new List<yt_product_state>();
                    var listSupplier = new List<yt_product_supplier>();
                    var newModel = list.FirstOrDefault(m => m.id == entity.s_id);
                    var isExistModel = yt_product_base.FirstOrDefault(" where s_sku = @0", newModel.goods_sn);
                    if (isExistModel == null)
                    {
                        entity.s_product = newModel.product_sn;
                        entity.s_sku = newModel.goods_sn;
                        listBase.Add(entity);

                        //开发表信息
                        var objExploit = yt_product_exploit.FirstOrDefault(" where ex_sid = @0", entity.s_id);
                        objExploit.ex_sku = newModel.goods_sn;
                        objExploit.ex_updatename = entity.s_updatename;
                        listExploit.Add(objExploit);

                        //供应商表信息
                        var objSupplier = yt_product_supplier.FirstOrDefault(" where sp_sid = @0", entity.s_id);
                        objSupplier.sp_sku = newModel.goods_sn;
                        objSupplier.sp_updatename = entity.s_updatename;
                        listSupplier.Add(objSupplier);

                        //状态表信息
                        var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", entity.s_id);
                        objState.st_sku = newModel.goods_sn;
                        objState.st_status = 2;
                        objState.st_isupapi = 1;
                        objState.st_lastupdate_state = 1;
                        objState.st_reason = "";
                        objState.st_toold = 0;
                        objState.st_updatename = entity.s_updatename;
                        listState.Add(objState);

                        var resultBase = ProductServices.SaveProductBase(listBase, false);
                        var resultExploit = ProductServices.SaveProductExploit(listExploit, false);
                        var resultSupplier = ProductServices.SaveProductSupplier(listSupplier, false);
                        var resultState = ProductServices.SaveProductState(listState, false);
                        if (resultBase.result_code == 1 || resultExploit.result_code == 1 || resultSupplier.result_code == 1 || resultState.result_code == 1)
                        {
                            if (resultState.result_code != 1)
                            {
                                objState.st_updatetime = DateTime.Now;
                                objState.Update(new string[] { "st_sku", "st_status", "st_isupapi", "st_lastupdate_state", "st_reason", "st_toold", "st_updatename", "st_updatetime" });
                                LoggerHelper.Error(newModel.goods_sn + "更新失败！" + resultState.result_msg);
                            }
                            //全部修改完后同步到旧表
                            //DataToSameStock.InsertOrUpdateToSame();
                            return resultBase;
                        }
                        else
                        {
                            result = ApiDataManage.CreateApiResult(500);
                            result.result_msg = $"更新数据失败！{resultBase.result_msg},{resultExploit.result_msg},{resultState.result_msg},{resultSupplier.result_msg}";
                        }
                    }
                    else
                    {
                        result = ApiDataManage.CreateApiResult(600);
                        result.result_msg = $"上传至环球PDM失败，返回的产品编码{newModel.product_sn}数据库中已存在！";
                    }
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = resultInfo.error_msg;
                }
                return result;
            }
            else
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "参数id必须大于0";
                return result;
            }
        }

        public ApiResult BindProductSingleAdd(yt_product_base entity)
        {
            ApiResult result = new ApiResult();
            //半成品商品不上传到环球
            if (entity.s_id > 0 && (entity.s_isfinish == 1 || entity.s_isfinish == 5))
            {
                ApiProductAdd obj = new ApiProductAdd();
                obj.company = code;
                obj.method = "manage.Product.Add";
                obj.category_id = GetCategoryMapping(entity.s_category_id.Value);
                obj.declare_name_cn = entity.s_cbaoguan;
                obj.declare_name_en = entity.s_ebaoguan;
                obj.custom_sn = entity.s_hscode;
                obj.charger_spec = entity.s_charger_spec.ToString();
                obj.character_ids = entity.s_product_character;

                List<ProductSandard> specsList = new List<ProductSandard>();
                ProductSandard model = new ProductSandard();
                model.id = entity.s_id;
                model.color = entity.s_color;
                model.size = entity.s_size;
                if (!string.IsNullOrWhiteSpace(entity.s_size1))
                    model.size += "/" + entity.s_size1;
                if (!string.IsNullOrWhiteSpace(entity.s_size2))
                    model.size += "/" + entity.s_size2;
                model.product_name = entity.s_ctitle;
                model.product_name_en = entity.s_etitle;
                model.purchase_price = entity.s_price.Value;
                model.currency_code = entity.s_currency;
                model.product_weight = entity.s_weight.Value / 1000;  //转为千克
                model.actual_weight = model.product_weight + (entity.s_packing_weight ?? 0) / 1000;    //转为千克

                if (entity.s_product_size != null)
                {
                    string[] arraySize = entity.s_product_size.Split(',');
                    model.product_length = Convert.ToDecimal(arraySize[0]);
                    model.product_width = Convert.ToDecimal(arraySize[1]);
                    model.product_height = Convert.ToDecimal(arraySize[2]);
                }

                if (entity.s_packing_size != null)
                {
                    string[] arrayPacking = entity.s_packing_size.Split(',');
                    model.package_length = Convert.ToDecimal(arrayPacking[0]);
                    model.package_width = Convert.ToDecimal(arrayPacking[1]);
                    model.package_height = Convert.ToDecimal(arrayPacking[2]);
                }

                if (false)
                {
                    //获取接口图片，优先用主图
                    if (string.IsNullOrWhiteSpace(entity.s_main_image))
                    {
                        var imgUrlArr = entity.s_main_image.Split(',');
                        var url = BaiLunBi + imgUrlArr[0].Replace('/', '\\');
                        var imgUrl = HqygDataServices.UploadFileImage(url);
                        model.image_path = imgUrl;
                    }
                    else
                    {
                        if (string.IsNullOrWhiteSpace(entity.s_child_image))
                        {
                            var imgUrlArr = entity.s_child_image.Split(',');
                            var url = BaiLunBi + imgUrlArr[0].Replace('/', '\\');
                            var imgUrl = HqygDataServices.UploadFileImage(url);
                            model.image_path = imgUrl;
                        }
                    }
                }

                specsList.Add(model);

                obj.specs = specsList;
                var resultInfo = ManageProductAdd(obj);
                if (resultInfo.response)
                {
                    var list = resultInfo.result.ToList();
                    var listBase = new List<yt_product_base>();
                    var listExploit = new List<yt_product_exploit>();
                    var listState = new List<yt_product_state>();
                    var listSupplier = new List<yt_product_supplier>();
                    var newModel = list.FirstOrDefault(m => m.id == entity.s_id);
                    var isExistModel = yt_product_base.FirstOrDefault(" where s_sku = @0", newModel.goods_sn);
                    if (isExistModel == null)
                    {
                        entity.s_product = newModel.product_sn;
                        entity.s_sku = newModel.goods_sn;
                        listBase.Add(entity);

                        //开发表信息
                        var objExploit = yt_product_exploit.FirstOrDefault(" where ex_sid = @0", entity.s_id);
                        objExploit.ex_sku = newModel.goods_sn;
                        objExploit.ex_updatename = entity.s_updatename;
                        listExploit.Add(objExploit);

                        //状态表信息
                        var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", entity.s_id);
                        objState.st_sku = newModel.goods_sn;
                        objState.st_isupapi = 1;
                        objState.st_lastupdate_state = 1;
                        objState.st_toold = 0;
                        objState.st_updatename = entity.s_updatename;
                        listState.Add(objState);

                        //供应商表信息
                        var objSupplier = yt_product_supplier.FirstOrDefault(" where sp_sid = @0", entity.s_id);
                        objSupplier.sp_sku = newModel.goods_sn;
                        objSupplier.sp_updatename = entity.s_updatename;
                        listSupplier.Add(objSupplier);

                        var resultBase = ProductServices.SaveProductBase(listBase, false);
                        var resultExploit = ProductServices.SaveProductExploit(listExploit, false);
                        var resultSupplier = ProductServices.SaveProductSupplier(listSupplier, false);
                        var resultState = ProductServices.SaveProductState(listState, false);

                        if (resultBase.result_code == 1 && resultExploit.result_code == 1 && resultState.result_code == 1 && resultSupplier.result_code == 1)
                        {
                            //全部修改完后同步到旧表
                            //DataToSameStock.InsertOrUpdateToSame();
                            return resultBase;
                        }
                        else
                        {
                            result = ApiDataManage.CreateApiResult(500);
                            result.result_msg = $"更新数据失败！{resultBase.result_msg},{resultExploit.result_msg},{resultState.result_msg},{resultSupplier.result_msg}";
                        }
                    }
                    else
                    {
                        result = ApiDataManage.CreateApiResult(600);
                        result.result_msg = "上传至环球PDM失败，返回的产品编码{newModel.product_sn}数据库中已存在！";
                    }
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = resultInfo.error_msg;
                }
                return result;
            }
            else
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "参数id必须大于0";
                return result;
            }
        }

        /// <summary>
        /// 添加产品分类
        /// </summary>
        /// <returns></returns>
        public static ResultProductInfo ManageProductAdd(ApiProductAdd obj)
        {
            //ApiProductAdd obj = new ApiProductAdd();
            //obj.company = code;
            //obj.method = "manage.Product.Add";
            //obj.category_id = 7161;
            //obj.product_name = "小鱼产品1号";
            //obj.product_name_en = "I am a fish product.";
            //obj.charger_spec = "1";
            //obj.product_weight = Convert.ToDecimal(0.089);
            //obj.actual_weight = 1;
            //obj.product_length = 15;
            //obj.product_width = 5;
            //obj.product_height = 3;
            //obj.package_length = 20;
            //obj.package_width = 10;
            //obj.package_height = 5;
            //obj.image_path = "/uploads/pdm-product-pic/Other/2017/01/04/thumb-img/1483492568181479175.jpg";
            //obj.declare_name_cn = "咸鱼";
            //obj.declare_name_en = "Are you xianyu?";
            //obj.custom_sn = "6204591010";
            //obj.character_ids = "1,48";
            //obj.purchase_price = 1;
            //obj.currency_code = "CNY";

            //List<ProductSandard> specsList = new List<ProductSandard>();
            //ProductSandard model = new ProductSandard();
            //model.color = "Red";
            //model.size = "S";
            //ProductSandard model1 = new ProductSandard();
            //model1.color = "red";
            //model1.size = "M";
            //specsList.Add(model);
            //specsList.Add(model1);
            //obj.specs = specsList;

            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            var json = JsonConvert.SerializeObject(obj, Formatting.None, jSetting);
            var strJson = HqygDataServices.GetDataCommon(json);
            var resultInfo = JsonConvert.DeserializeObject<ResultProductInfo>(strJson);
            return resultInfo;
        }

        public static ApiResult BindProductEdit(yt_product_base entity)
        {
            ApiResult result = new ApiResult();
            if (entity.s_id > 0)
            {
                ApiProductAdd obj = new ApiProductAdd();
                obj.company = code;
                obj.method = "manage.Product.Edit";
                obj.goods_sn = entity.s_sku;
                obj.category_id = GetCategoryMapping(entity.s_category_id.Value);
                obj.declare_name_cn = entity.s_cbaoguan;
                obj.declare_name_en = entity.s_ebaoguan;
                obj.custom_sn = entity.s_hscode;
                obj.charger_spec = entity.s_charger_spec.ToString();
                obj.character_ids = entity.s_product_character;

                List<ProductSandard> specsList = new List<ProductSandard>();
                ProductSandard model = new ProductSandard();
                model.id = entity.s_id;
                model.color = entity.s_color;
                model.size = entity.s_size;
                if (!string.IsNullOrWhiteSpace(entity.s_size1))
                    model.size += "/" + entity.s_size1;
                if (!string.IsNullOrWhiteSpace(entity.s_size2))
                    model.size += "/" + entity.s_size2;
                model.product_name = entity.s_ctitle;
                model.product_name_en = entity.s_etitle;
                model.purchase_price = entity.s_price.Value;
                model.currency_code = entity.s_currency;
                model.product_weight = entity.s_weight.Value / 1000;  //转为千克
                model.actual_weight = model.product_weight + (entity.s_packing_weight ?? 0) / 1000;    //转为千克

                if (entity.s_product_size != null)
                {
                    string[] arraySize = entity.s_product_size.Split(',');
                    model.product_length = Convert.ToDecimal(arraySize[0]);
                    model.product_width = Convert.ToDecimal(arraySize[1]);
                    model.product_height = Convert.ToDecimal(arraySize[2]);
                }

                if (entity.s_packing_size != null)
                {
                    string[] arrayPacking = entity.s_packing_size.Split(',');
                    model.package_length = Convert.ToDecimal(arrayPacking[0]);
                    model.package_width = Convert.ToDecimal(arrayPacking[1]);
                    model.package_height = Convert.ToDecimal(arrayPacking[2]);
                }

                //if (false)
                //{
                //    if (entity.IsUpNewImg == "1")
                //    {
                //        //获取接口图片，优先用子图
                //        if (entity.ImgUrlList != null)
                //        {
                //            if (entity.ImgUrlList.Count > 0)
                //            {
                //                var imgUrlList = entity.ImgUrlList[0].Split(',');
                //                var url = BaiLunBi + imgUrlList[0].Replace('/', '\\');
                //                var imgUrl = UploadFileImage(url);
                //                model.image_path = imgUrl;
                //            }
                //        }
                //        else
                //        {
                //            if (entity.MainImgUrlList?.Count > 0)
                //            {
                //                var imgUrlList = entity.MainImgUrlList[0].Split(',');
                //                var url = BaiLunBi + imgUrlList[0].Replace('/', '\\');
                //                var imgUrl = UploadFileImage(url);
                //                model.image_path = imgUrl;
                //            }
                //        }
                //    }
                //}

                specsList.Add(model);
                obj.specs = specsList;
                var resultInfo = ManageProductEdit(obj);
                if (resultInfo.response)
                {
                    var listState = new List<yt_product_state>();
                    var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", entity.s_id);
                    objState.st_isupapi = 1;
                    objState.st_lastupdate_state = 1;
                    objState.st_reason = "";
                    listState.Add(objState);
                    var resultState = ProductServices.SaveProductState(listState, false);
                    if (resultState.result_code == 1)
                    {
                        return resultState;
                    }
                    else
                    {
                        result = ApiDataManage.CreateApiResult(500);
                        result.result_msg = "更新数据失败！" + resultState.result_msg;
                    }
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = resultInfo.error_msg;
                }
                return result;
            }
            else
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "参数id必须大于0";
                return result;
            }
        }

        /// <summary>
        /// 修改产品分类
        /// </summary>
        /// <returns></returns>
        public static ResultProductInfo ManageProductEdit(ApiProductAdd obj)
        {
            //ApiProductAdd obj = new ApiProductAdd();
            //obj.company = code;
            //obj.method = "manage.Product.Edit";
            //obj.goods_sn = "199372201";
            //obj.category_id = 7161;
            //obj.product_name = "小鱼饼干1号";
            //obj.product_name_en = "I am a fish product.";
            //obj.charger_spec = "1";
            //obj.product_weight = Convert.ToDecimal(0.089);
            //obj.actual_weight = 1;
            //obj.product_length = 15;
            //obj.product_width = 5;
            //obj.product_height = 3;
            //obj.package_length = 20;
            //obj.package_width = 10;
            //obj.package_height = 5;
            //obj.image_path = "/uploads/pdm-product-pic/Other/2017/01/04/thumb-img/1483492568181479175.jpg";
            //obj.declare_name_cn = "咸鱼";
            //obj.declare_name_en = "Are you xianyu?";
            //obj.custom_sn = "6204591010";
            //obj.character_ids = "1,48";
            //obj.purchase_price = 1;
            //obj.currency_code = "CNY";

            //List<ProductSandard> specsList = new List<ProductSandard>();
            //ProductSandard model = new ProductSandard();
            //model.color = "Blue";
            //model.size = "S";
            //specsList.Add(model);
            //obj.specs = specsList;

            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            var json = JsonConvert.SerializeObject(obj, Formatting.None, jSetting);
            var strJson = HqygDataServices.GetDataCommon(json);
            var resultInfo = JsonConvert.DeserializeObject<ResultProductInfo>(strJson);
            return resultInfo;
        }

        public static ApiResult BindProductCopy(yt_product_base entity)
        {
            ApiResult result = new ApiResult();
            //半成品商品不上传到环球
            if (entity.s_id > 0 && entity.s_isfinish != 1 && entity.s_isfinish != 5)
            {
                ApiProductAdd obj = new ApiProductAdd();
                obj.company = code;
                obj.method = "manage.Product.Copy";
                obj.product_sn = entity.s_sku;
                obj.category_id = GetCategoryMapping(entity.s_category_id.Value);
                obj.declare_name_cn = entity.s_cbaoguan;
                obj.declare_name_en = entity.s_ebaoguan;
                obj.custom_sn = entity.s_hscode;
                obj.charger_spec = entity.s_charger_spec.ToString();
                obj.character_ids = entity.s_product_character;

                List<ProductSandard> specsList = new List<ProductSandard>();
                ProductSandard model = new ProductSandard();
                model.id = entity.s_id;
                model.color = entity.s_color;
                model.size = entity.s_size;
                if (!string.IsNullOrWhiteSpace(entity.s_size1))
                    model.size += "/" + entity.s_size1;
                if (!string.IsNullOrWhiteSpace(entity.s_size2))
                    model.size += "/" + entity.s_size2;
                model.product_name = entity.s_ctitle;
                model.product_name_en = entity.s_etitle;
                model.purchase_price = entity.s_price.Value;
                model.currency_code = entity.s_currency;
                model.product_weight = entity.s_weight.Value / 1000;  //转为千克
                model.actual_weight = model.product_weight + (entity.s_packing_weight ?? 0) / 1000;    //转为千克

                if (entity.s_product_size != null)
                {
                    string[] arraySize = entity.s_product_size.Split(',');
                    model.product_length = Convert.ToDecimal(arraySize[0]);
                    model.product_width = Convert.ToDecimal(arraySize[1]);
                    model.product_height = Convert.ToDecimal(arraySize[2]);
                }

                if (entity.s_packing_size != null)
                {
                    string[] arrayPacking = entity.s_packing_size.Split(',');
                    model.package_length = Convert.ToDecimal(arrayPacking[0]);
                    model.package_width = Convert.ToDecimal(arrayPacking[1]);
                    model.package_height = Convert.ToDecimal(arrayPacking[2]);
                }

                if (false)
                {
                    //获取接口图片，优先用主图
                    if (string.IsNullOrWhiteSpace(entity.s_main_image))
                    {
                        var imgUrlArr = entity.s_main_image.Split(',');
                        var url = BaiLunBi + imgUrlArr[0].Replace('/', '\\');
                        var imgUrl = HqygDataServices.UploadFileImage(url);
                        model.image_path = imgUrl;
                    }
                    else
                    {
                        if (string.IsNullOrWhiteSpace(entity.s_child_image))
                        {
                            var imgUrlArr = entity.s_child_image.Split(',');
                            var url = BaiLunBi + imgUrlArr[0].Replace('/', '\\');
                            var imgUrl = HqygDataServices.UploadFileImage(url);
                            model.image_path = imgUrl;
                        }
                    }
                }

                specsList.Add(model);
                obj.specs = specsList;
                var resultInfo = ManageProductCopy(obj);
                if (resultInfo.response)
                {
                    var list = resultInfo.result.ToList();
                    var listBase = new List<yt_product_base>();
                    var listExploit = new List<yt_product_exploit>();
                    var listState = new List<yt_product_state>();
                    var listSupplier = new List<yt_product_supplier>();
                    var newModel = list.FirstOrDefault(m => m.id == entity.s_id);
                    var isExistModel = yt_product_base.FirstOrDefault(" where s_sku = @0", newModel.goods_sn);
                    if (isExistModel == null)
                    {
                        entity.s_product = newModel.product_sn;
                        entity.s_sku = newModel.goods_sn;
                        listBase.Add(entity);

                        //开发表信息
                        var objExploit = yt_product_exploit.FirstOrDefault(" where ex_sid = @0", entity.s_id);
                        objExploit.ex_sku = newModel.goods_sn;
                        objExploit.ex_updatename = entity.s_updatename;
                        listExploit.Add(objExploit);

                        //状态表信息
                        var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", entity.s_id);
                        objState.st_sku = newModel.goods_sn;
                        objState.st_isupapi = 1;
                        objState.st_lastupdate_state = 1;
                        objState.st_toold = 0;
                        objState.st_updatename = entity.s_updatename;
                        listState.Add(objState);

                        //供应商表信息
                        var objSupplier = yt_product_supplier.FirstOrDefault(" where sp_sid = @0", entity.s_id);
                        objSupplier.sp_sku = newModel.goods_sn;
                        objSupplier.sp_updatename = entity.s_updatename;
                        listSupplier.Add(objSupplier);

                        var resultBase = ProductServices.SaveProductBase(listBase, false);
                        var resultExploit = ProductServices.SaveProductExploit(listExploit, false);
                        var resultState = ProductServices.SaveProductState(listState, false);
                        var resultSupplier = ProductServices.SaveProductSupplier(listSupplier, false);
                        if (resultBase.result_code == 1 && resultExploit.result_code == 1 && resultState.result_code == 1 && resultSupplier.result_code == 1)
                        {
                            //全部修改完后同步到旧表
                            //DataToSameStock.InsertOrUpdateToSame();
                            return resultBase;
                        }
                        else
                        {
                            result = ApiDataManage.CreateApiResult(500);
                            result.result_msg = $"更新数据失败！{resultBase.result_msg},{resultExploit.result_msg},{resultState.result_msg},{resultSupplier.result_msg}";
                        }
                    }
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = resultInfo.error_msg;
                }
                return result;
            }
            else
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "参数id必须大于0";
                return result;
            }
        }

        /// <summary>
        /// 复制同款产品
        /// </summary>
        /// <returns></returns>
        public static ResultProductInfo ManageProductCopy(ApiProductAdd obj)
        {
            //ApiProductAdd obj = new ApiProductAdd();
            //obj.company = code;
            //obj.method = "manage.Product.Copy";
            //obj.product_sn = "1993722";
            //obj.category_id = 7161;
            //obj.product_name = "小鱼饼干1号";
            //obj.product_name_en = "I am a fish product.";
            //obj.charger_spec = "1";
            //obj.product_weight = Convert.ToDecimal(0.089);
            //obj.actual_weight = 1;
            //obj.product_length = 15;
            //obj.product_width = 5;
            //obj.product_height = 3;
            //obj.package_length = 20;
            //obj.package_width = 10;
            //obj.package_height = 5;
            //obj.image_path = "/uploads/pdm-product-pic/Other/2017/01/04/thumb-img/1483492568181479175.jpg";
            //obj.declare_name_cn = "咸鱼";
            //obj.declare_name_en = "Are you xianyu?";
            //obj.custom_sn = "6204591010";
            //obj.character_ids = "1,48";
            //obj.purchase_price = 1;
            //obj.currency_code = "CNY";

            //List<ProductSandard> specsList = new List<ProductSandard>();
            //ProductSandard model = new ProductSandard();
            //model.color = "Green";
            //model.size = "S";
            //ProductSandard model1 = new ProductSandard();
            //model1.color = "Green";
            //model1.size = "XL";
            //specsList.Add(model);
            //obj.specs = specsList;

            var jSetting = new JsonSerializerSettings { NullValueHandling = NullValueHandling.Ignore };
            var json = JsonConvert.SerializeObject(obj, Formatting.None, jSetting);
            var strJson = HqygDataServices.GetDataCommon(json);
            var resultInfo = JsonConvert.DeserializeObject<ResultProductInfo>(strJson);
            return resultInfo;
        }

        /// <summary>
        /// 获取分类映射ID
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static int GetCategoryMapping(int categoryId)
        {
            int id = 0;
            var obj = yt_category_new.FirstOrDefault(" where c_id = @0", categoryId);
            if (obj != null)
            {
                if (obj.C_MAPPING > 0)
                    id = Convert.ToInt32(obj.C_MAPPING);
                else
                    id = 0;   //此处应执行
            }
            return id;
        }
        #endregion


        #region 自动同步到环球
        public static bool SyncObjPdm = true;

        /// <summary>
        /// 新表数据操作同步到旧表
        /// </summary>
        public static void InsertOrUpdateToSame()
        {
            if(SyncObjPdm)
            {
                SyncObjPdm = false;
                Task.Factory.StartNew(() =>
                {
                    //Thread.Sleep(10000);
                    RecursionUpLoadToPdm();
                    //RecursionMigrationToPdm();
                    SyncObjPdm = true;
                });
            }
        }

        /// <summary>
        /// 递归执行更新
        /// </summary>
        public static void RecursionMigrationToPdm()
        {
            var stateList = yt_product_state.Fetch(" where st_isupapi = 1 and st_lastupdate_state = 0 and st_reason = '' limit 5000").ToList();
            if (stateList.Count > 0)
            {
                DataMigrationPdmStart(stateList);
                //Thread.Sleep(3000);
            }
        }

        /// <summary>
        /// 启动数据同步到PDM任务
        /// </summary>
        private static void DataMigrationPdmStart(List<yt_product_state> stateList)
        {
            foreach (var objState in stateList)
            {
                try
                {
                    var objBase = yt_product_base.FirstOrDefault(" where s_id = @0", objState.st_sid);
                    if (objBase != null)
                    {
                        if(objBase.s_sku == objState.st_sku)
                        {
                            var result = BindProductEdit(objBase);
                            if (result.result_code == 1)
                            {
                                objState.st_lastupdate_state = 1;
                                objState.st_reason = "";
                            }
                            else
                            {
                                objState.st_lastupdate_state = -1;
                                objState.st_reason = "更新失败：" + result.result_msg;
                            }
                        }
                    }
                    else
                    {
                        objState.st_lastupdate_state = -1;
                        objState.st_reason = "找不到该SKU基础信息。";
                    }
                    objState.Update(new string[] { "st_lastupdate_state", "st_reason" });
                }
                catch (Exception ex)
                {
                    if (!ex.Message.Contains("Unable to connect to the remote server") && !ex.Message.Contains("基础连接已经关闭") && !ex.Message.Contains("无法连接到远程服务器，请求路径"))
                    {
                        if (ex.Message.Contains("You have no permission to edit this product."))
                        {
                            objState.st_reason = "没有权限修改此产品。";
                        }
                        else
                        {
                            objState.st_reason = ex.Message;
                        }
                        objState.st_lastupdate_state = -1;
                        objState.Update(new string[] { "st_lastupdate_state", "st_reason" });
                    }
                }
            }
            RecursionMigrationToPdm();
        }

        /// <summary>
        /// 递归执行上传
        /// </summary>
        public static void RecursionUpLoadToPdm()
        {
            var stateList = yt_product_state.Fetch(" select a.* from yt_product_state as a LEFT JOIN yt_product_base as b on a.st_sid = b.s_id "
                 + "where st_isupapi = 0 and (st_status = 2 or (st_status = 1 and st_isbuy = 1)) and s_isfinish = 1 and b.s_operatetype != 'Delete' limit 5000").ToList();
            if (stateList.Count > 0)
            {
                DataUpLoadPdmStart(stateList);
                //Thread.Sleep(3000);
                //RecursionUpLoadToPdm();
            }
        }

        /// <summary>
        /// 启动数据上传到PDM任务
        /// </summary>
        private static void DataUpLoadPdmStart(List<yt_product_state> stateList)
        {
            foreach (var objState in stateList)
            {
                try
                {
                    var objBase = yt_product_base.FirstOrDefault(" where s_id = @0", objState.st_sid);
                    var upState = yt_product_state.FirstOrDefault(" where st_sid = @0", objState.st_sid);
                    if (upState.st_isupapi == 1)
                        continue;

                    var result = BindProductAdd(objBase);
                    if (result.result_code != 1 && result.result_msg != "This product is not exist in system.")
                    {
                        Thread.Sleep(1000);  //延迟1秒再去查库，避免同一时间操作
                        var tempState = yt_product_state.FirstOrDefault(" where st_sid = @0", objState.st_sid);
                        if(tempState.st_isupapi != 1)
                        {
                            tempState.st_status = 1;
                            tempState.st_isupapi = 0;
                            tempState.st_reason = result.result_msg;
                            tempState.Update(new string[] { "st_status", "st_isupapi", "st_reason" });
                        }
                    }
                }
                catch (Exception ex)
                {
                    if (!ex.Message.Contains("Unable to connect to the remote server") && !ex.Message.Contains("基础连接已经关闭") && !ex.Message.Contains("无法连接到远程服务器，请求路径"))
                    {
                        var tempState = yt_product_state.FirstOrDefault(" where st_sid = @0", objState.st_sid);
                        tempState.st_status = 1;
                        tempState.st_reason = ex.Message;
                        tempState.Update(new string[] { "st_status", "st_reason" });
                    }
                }
            }
            //RecursionUpLoadToPdm();
        }
        #endregion

    }
}
