﻿using DbConn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace API.Services.ProductManageServices
{
    public class ProductDataServices
    {
        public static readonly object generatelock = new object();
        private static readonly Lazy<ProductDataServices> lazy = new Lazy<ProductDataServices>(() => new ProductDataServices());

        public static ProductDataServices Instance { get { return lazy.Value; } }

        /// <summary>
        /// 生成商品编码
        /// </summary>
        /// <returns></returns>
        public static string GenerateCode()
        {
            lock (generatelock)
            {
                int count = productcode.Fetch("").Count();
                if (count <= 0)
                {
                    var objProCode = productcode.Insert(new productcode() { Code = 8000000 });
                    if (objProCode == null)
                    {
                        throw new Exception("生成商品编码失败！没有提交到数据库！");
                    }
                    return "8000000";
                }
                else
                {
                    long newcode = productcode.PocoDb.ExecuteScalar<long>(" select max(Code) from ProductCode ");
                    var objProCode = productcode.Insert(new productcode() { Code = newcode + 1 });
                    productcode.PocoDb.Execute(" delete from ProductCode where id < @0", objProCode.ID); 
                    if (objProCode == null)
                    {
                        throw new Exception("生成商品编码失败！没有提交到数据库！");
                    }
                    return (newcode + 1).ToString();
                }
            }
        }

        /// <summary>
        /// 生成产品编码sku
        /// </summary>
        /// <param name="goodsCode">商品编码</param>
        /// <param name="index"></param>
        /// <returns></returns>
        public static string CreateProductCode(string goodsCode, int index)
        {
            if (string.IsNullOrWhiteSpace(goodsCode))
            {
                throw new Exception("生成产品编码时，商品编码为空！");
            }
            index = index == 0 ? 1 : index;
            string indexStr = index.ToString().PadLeft(2, '0');
            return goodsCode + indexStr;
        }
    }
}
