﻿using API.Services.PmsApiServices;
using ApiControl;
using DbConn;
using PetaPoco;
using PetaPoco.Custom.ProductData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static API.Services.ProductManageServices.ProductServices;

namespace API.Services.ProductManageServices
{
    public class DockingSystemServices
    {
        /// <summary>
        /// 保存产品状态信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveMainProductBase(GoodsMainInfo mainInfo)
        {
            ApiResult result = new ApiResult();
            List<yt_product_log> logList = new List<yt_product_log>();
            using (var dbContext = DbConnDB.GetInstance())
            {
                using (var tx = dbContext.GetTransaction())
                {
                    try
                    {
                        #region 商品信息
                        var mainImage = "";
                        var uploadImage = "";
                        var mainArr = !string.IsNullOrWhiteSpace(mainInfo.Images) ? mainInfo.Images.Split(',') : new string[] { };
                        foreach (var mainUrl in mainArr)
                        {
                            uploadImage = ImageUploadServices.UploadImageToQinNiu(mainInfo.Code, mainUrl);
                            mainImage += uploadImage;
                        }
                        var objMain = new dv_product_mian_deve();
                        objMain.pd_sku = mainInfo.Code;
                        objMain.pd_chinaname = mainInfo.CName;
                        objMain.pd_name = mainInfo.EName;
                        objMain.pd_mainimgurl = mainImage.Replace("%3F","?");
                        objMain.pd_colorname = mainInfo.ColorName;
                        objMain.pd_sizename = mainInfo.SizeName;
                        objMain.pd_sizename1 = mainInfo.SizeName1;
                        objMain.pd_sizename2 = mainInfo.SizeName2;
                        objMain.pd_country = mainInfo.Site;
                        objMain.pd_coin = mainInfo.Cury;
                        objMain.pd_brand = mainInfo.Brand;
                        objMain.pd_keyword = mainInfo.KeyWord;
                        objMain.pd_product = mainInfo.DescriptionJson;
                        objMain.pd_remark = mainInfo.RemarkJson;
                        objMain.pd_source = mainInfo.Source;
                        objMain.company_id = mainInfo.CompanyId;
                        objMain.pd_skunum = mainInfo.ProductList.Count;
                        objMain.pd_args = "{}";
                        objMain.pd_price = 0;
                        objMain.pd_cate_id = "";
                        objMain.pd_type = 0;
                        objMain.pd_category_bailun_id = 0;
                        objMain.ProductStatus = 0;
                        objMain.pd_pushtime = Convert.ToDateTime("1999-01-01");
                        objMain.pd_createdate = DateTime.Now;
                        objMain.pd_creater = "wanyitongApi";
                        objMain.pd_operationrtype = "ADD";
                        objMain.pd_createtime = DateTime.Now;
                        objMain.pd_Operatingtime = DateTime.Now;
                        objMain.pd_updatedate = DateTime.Now;
                        objMain.pd_updater = "wanyitongApi";
                        objMain.pd_documentime = Convert.ToDateTime("1999-01-01");
                        
                        objMain.Insert();
                        #endregion

                        #region SKU信息
                        int cateId = 0;
                        string cateName = "";
                        var bailunCateList = yt_category_bailun.Fetch(" where c_parentid = 1897");
                        var objCate = bailunCateList.FirstOrDefault(m => m.c_ename == mainInfo.Site);
                        if(objCate != null)
                        {
                            cateId = objCate.c_id;
                            cateName = objCate.c_cname;
                        }
                        List<AllProductInfo> productList = new List<AllProductInfo>();
                        foreach(var objSku in mainInfo.ProductList)
                        {
                            var objPro = new AllProductInfo();
                            objPro.s_main_id = objMain.pd_mian_id;
                            objPro.s_goods_code = objMain.pd_sku;
                            objPro.s_product_code = objSku.Sku;
                            objPro.s_product = objMain.pd_sku;
                            objPro.s_sku = objSku.Sku;
                            objPro.s_ctitle = mainInfo.CName;
                            objPro.s_etitle = mainInfo.EName;
                            objPro.s_ctitle_alias = mainInfo.CName;
                            objPro.s_category_bailun_id = cateId;
                            objPro.s_category_bailun_name = cateName;
                            objPro.s_category_id = 0;
                            objPro.s_category_name = "";
                            objPro.s_skutype = 0;
                            objPro.s_isfinish = 1;
                            objPro.s_weight = objSku.Weight;
                            objPro.s_unit = "";
                            objPro.s_price = objSku.Price;
                            objPro.s_currency = "";
                            objPro.s_main_image = objSku.MainImage.Replace("%3F","?");
                            objPro.s_child_image = objSku.ChildImage.Replace("%3F", "?");
                            objPro.s_color = objSku.Color;
                            objPro.s_size = objSku.Size;
                            objPro.s_size1 = objSku.Size1;
                            objPro.s_size2 = objSku.Size2;
                            objPro.s_product_size = objSku.PackingSize.Replace("*",",");
                            objPro.s_packing_size = objSku.PackingSize.Replace("*", ",");
                            objPro.s_packing_name = "";
                            objPro.s_packing_price = 0;
                            objPro.s_packing_weight = 0;
                            objPro.s_packing_req = "";
                            objPro.s_packing_skuid = 0;
                            objPro.s_charger_spec = 1;
                            objPro.s_product_character = "1";
                            objPro.s_bailun_character = "";
                            objPro.s_cpeihuo = "";
                            objPro.s_epeihuo = "";
                            objPro.s_cbaoguan = "";
                            objPro.s_ebaoguan = "";
                            objPro.s_hscode = "";
                            objPro.s_content = "";
                            objPro.s_remarks = "";
                            objPro.s_developtime = DateTime.Now;
                            objPro.s_createname = "wytApi";
                            objPro.s_createtime = DateTime.Now;
                            objPro.s_updatename = "wytApi";
                            objPro.s_updatetime = DateTime.Now;
                            objPro.s_operatetype = "Add";

                            objPro.ex_main_id = objMain.pd_mian_id;
                            objPro.ex_sid = 0;
                            objPro.ex_sku = "";
                            objPro.ex_examid = 0;
                            objPro.ex_shopname = mainInfo.Site;
                            objPro.ex_bussiness_id = 0;
                            objPro.ex_bussiness_name = "";
                            objPro.ex_buyer = 0;
                            objPro.ex_buyer_name = "";
                            objPro.ex_supplier_id = 0;
                            objPro.ex_sales_price = objSku.SellPrice;
                            objPro.ex_maxlirun = 0;
                            objPro.ex_maxlirunlv = 0;
                            objPro.ex_default_warecode = "";
                            objPro.ex_label_req = "";
                            objPro.ex_zhijian_type = 0;
                            objPro.ex_testhour = 0;
                            objPro.ex_zhijian_req = "";
                            objPro.ex_zhijian_desc = "";
                            objPro.ex_source = objSku.Source;
                            objPro.ex_procestatus = -2;
                            objPro.ex_is_hesuan = 0;
                            objPro.ex_enable = 1;
                            objPro.ex_zlyfinish = 0;
                            objPro.ex_updatename = "wytApi";
                            objPro.ex_updatetime = DateTime.Now;

                            objPro.st_main_id = objMain.pd_mian_id;
                            objPro.st_sid = 0;
                            objPro.st_sku = "";
                            objPro.st_status = 1;
                            objPro.st_isbuy = 1;
                            objPro.st_distribute = 0;
                            objPro.st_isupapi = 1;
                            objPro.st_lastupdate_state = 2;
                            objPro.st_reason = "";
                            objPro.st_toold = 0;
                            objPro.st_updatename = "wytApi";
                            objPro.st_updatetime = DateTime.Now;

                            SupplierInfo objSup = new SupplierInfo();
                            objSup.sp_sp_id = 0;
                            objSup.sp_default = 1;
                            objSup.sp_main_id = objMain.pd_mian_id;
                            objSup.sp_sid = 0;
                            objSup.sp_sku = "";

                            objSup.sp_enquiry_id = 0;
                            objSup.sp_enquiry_name = "";
                            objSup.sp_deliver_id = 0;
                            objSup.sp_deliver_name = mainInfo.SupplierName;
                            objSup.sp_link = "";
                            objSup.sp_delivery = 0;
                            objSup.sp_moq = 0;
                            objSup.sp_internal_moq = 0;
                            objSup.sp_have_stall = 0;
                            objSup.sp_take_address = "";
                            objSup.sp_istake_goods = 0;
                            objSup.sp_remark = "";
                            objSup.sp_updatename = "wytApi";
                            objSup.sp_updatetime = DateTime.Now;
                            objPro.spList = new List<SupplierInfo>();
                            objPro.spList.Add(objSup);

                            productList.Add(objPro);
                        }
                        #endregion
                        result = ProductServices.SaveAllProduct(productList);
                        if (result.result_code == 1)
                        {
                            var objAllPro = CommonBaseLib.DecodeAndObject<List<yt_product_base>>(result.data).ToList();
                            //根据增加的SKU绑定组合SKU的关联信息
                            foreach (var entity in objAllPro)
                            {
                                var objExInfo = new dv_exploit_info();
                                objExInfo.ei_main_id = entity.s_main_id;
                                objExInfo.ei_sid = entity.s_id;
                                objExInfo.ei_sku = entity.s_sku;
                                objExInfo.ei_shopname = "wanyitong"; 
                                objExInfo.ei_supplier_id = 0;
                                objExInfo.ei_sales_price = 0;  //销售价
                                objExInfo.ei_sales_volume = 0;
                                objExInfo.ei_average_sales = 0;
                                objExInfo.ei_maxlirun = 0;
                                objExInfo.ei_maxlirunlv = 0;
                                objExInfo.ei_refer_price_zero = 0;
                                objExInfo.ei_refer_price_set = 0;
                                objExInfo.ei_refer_lirunlv = 0;
                                objExInfo.ei_shipping_fee = 0;
                                objExInfo.ei_enable = 1;
                                objExInfo.ei_ishesuan = 1;
                                objExInfo.ei_sample_state = 0;
                                objExInfo.ei_zlyfinish = 0;
                                objExInfo.ei_completetime = entity.s_createtime;
                                objExInfo.ei_updatename = entity.s_createname;
                                objExInfo.ei_updatetime = entity.s_createtime;
                                objExInfo.Insert();
                                //var objMission = new dv_mission_list
                                //{
                                //    ml_main_sku = entity.s_goods_code,
                                //    ml_profit_allplat = 10,
                                //    ml_profit_msg = "",
                                //    ml_code_info = 1,
                                //    ml_push_product = 0
                                //};
                                //objMission.Insert();
                            }
                            tx.Complete();
                        }
                    }
                    catch (Exception ex)
                    {
                        tx.Dispose();
                        var objError = new yt_system_error()
                        {
                            se_system_name = "DockingSystemServices",
                            se_module_name = "SaveMainProductBase",
                            se_error_name = "生成万邑通接口信息",
                            se_error_msg = ex.Message,
                            se_code_line = ex.StackTrace,
                            se_para_info = "",
                            se_createtime = DateTime.Now
                        }.Insert();
                        tx.Complete();
                        result.result_code = 500;
                        result.result_msg = "操作出错！原因：" + ex.Message;
                    }
                }
            }
            return result;
        }
    }
}
