﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PetaPoco.Custom.ProductData
{
    public class GoodsMainInfo
    {
        /// <summary>
        /// 商品编码
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 商品中文名称
        /// </summary>
        public string CName { get; set; }

        /// <summary>
        /// 商品英文名称
        /// </summary>
        public string EName { get; set; }

        /// <summary>
        /// 商品主图
        /// </summary>
        public string Images { get; set; }

        /// <summary>
        /// 颜色名称
        /// </summary>
        public string ColorName { get; set; }

        /// <summary>
        /// 规格名称
        /// </summary>
        public string SizeName { get; set; }

        /// <summary>
        /// 规格名称1
        /// </summary>
        public string SizeName1 { get; set; }

        /// <summary>
        /// 规格名称2
        /// </summary>
        public string SizeName2 { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string Site { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string Cury { get; set; }

        /// <summary>
        /// 品牌
        /// </summary>
        public string Brand { get; set; }

        /// <summary>
        /// 关键字
        /// </summary>
        public string KeyWord { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// 区域ID
        /// </summary>
        public int AreaId { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WareCode { get; set; }

        /// <summary>
        /// 规格图片信息JSON
        /// </summary>
        public string ArgsJson { get; set; }

        /// <summary>
        /// 描述Json
        /// </summary>
        public string DescriptionJson { get; set; }

        /// <summary>
        /// 备注Json
        /// </summary>
        public string RemarkJson { get; set; }

        /// <summary>
        /// 产品来源
        /// </summary>
        public string Source { get; set; }

        /// <summary>
        /// 公司Id
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// 产品列表
        /// </summary>
        public List<ProductSkuInfo> ProductList { get; set; }
    }

    public class ProductSkuInfo
    {
        /// <summary>
        /// sku
        /// </summary>
        public string Sku { get; set; }

        /// <summary>
        /// 主图
        /// </summary>
        public string MainImage { get; set; }

        /// <summary>
        /// 子图
        /// </summary>
        public string ChildImage { get; set; }

        /// <summary>
        /// 颜色
        /// </summary>
        public string Color { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        public string Size { get; set; }

        /// <summary>
        /// 规格1
        /// </summary>
        public string Size1 { get; set; }

        /// <summary>
        /// 规格2
        /// </summary>
        public string Size2 { get; set; }

        /// <summary>
        /// 采购价(CNY)
        /// </summary>
        public decimal Price { get; set; }

        /// <summary>
        /// 重量(g)
        /// </summary>
        public decimal Weight { get; set; }

        /// <summary>
        /// 包装规格
        /// </summary>
        public string PackingSize { get; set; }

        /// <summary>
        /// 最低销售价
        /// </summary>
        public decimal SellPrice { get; set; }

        /// <summary>
        /// 最低销售价
        /// </summary>
        public string WareCode { get; set; }

        /// <summary>
        /// 来源 9为万邑通
        /// </summary>
        public int Source { get; set; }
    }
}
