﻿using API.Services.ProductManageServices;
using ApiControl;
using DbConn;
using PetaPoco.Custom.ProductData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http;

namespace WebApi.Areas.ProductManage.Controllers
{
    /// <summary>
    /// Sku资料修改
    /// </summary>
    [RoutePrefix("api/ProductManage")]
    public class ProductController : ApiController
    {
        /// <summary>
        /// 保存产品所有信息
        /// </summary>
        /// <returns></returns>
        [Route("SaveAllProduct")]
        public ApiResult SaveAllProduct(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<AllProductInfo>>(pare.data.data);
                    result = ProductServices.SaveAllProductInfo(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新产品基本信息
        /// </summary>
        /// <returns></returns>
        [Route("SetProductBase")]
        public ApiResult SetProductBase(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<yt_product_base>>(pare.data.data);
                    result = ProductServices.SaveProductBase(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新产品开发信息
        /// </summary>
        /// <returns></returns>
        [Route("SetProductExploit")]
        public ApiResult SetProductExploit(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<yt_product_exploit>>(pare.data.data);
                    result = ProductServices.SaveProductExploit(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新产品供应商信息
        /// </summary>
        /// <returns></returns>
        [Route("SetProductSupplier")]
        public ApiResult SetProductSupplier(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<yt_product_supplier>>(pare.data.data);
                    result = ProductServices.SaveProductSupplier(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新发货仓库信息
        /// </summary>
        /// <returns></returns>
        [Route("SetProductWare")]
        public ApiResult SetProductWare(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<yt_product_ware>>(pare.data.data);
                    result = ProductServices.SaveProductWare(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 更新产品状态信息
        /// </summary>
        /// <returns></returns>
        [Route("SetProductState")]
        public ApiResult SetProductState(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<yt_product_state>>(pare.data.data);
                    result = ProductServices.SaveProductState(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch(Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 批量修改信息
        /// </summary>
        /// <returns></returns>
        [Route("SetBatchProductInfo")]
        public ApiResult SetBatchProductInfo(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var model = CommonBaseLib.GetJsonToObject<BatchProductInfo>(pare.data.data);
                    model.pd_category_bailun_id = model.s_category_bailun_id > 0 ? model.s_category_bailun_id : model.pd_category_bailun_id;
                    result = ProductServices.BatchProductInfo(model);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 删除产品基本信息
        /// </summary>
        /// <returns></returns>
        [Route("DestroyProductBase")]
        public ApiResult DestroyProductBase(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<List<yt_product_base>>(pare.data.data);
                    result = ProductServices.DeleteProductBase(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 添加万邑通SKU全部信息
        /// </summary>
        /// <returns></returns>
        [Route("SaveWYTProductBase")]
        public ApiResult SaveWYTProductBase(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                if (ds.appId == "SystemCrawler")
                {
                    var mainInfo = CommonBaseLib.DecodeAndObject<GoodsMainInfo>(ds.data);
                    var tempSku = mainInfo.ProductList.FirstOrDefault();
                    mainInfo.Code = $"[WYT-{tempSku.WareCode}]{mainInfo.Code}";
                    mainInfo.Source = "wanyitong";
                    mainInfo.CompanyId = 1;
                    var isExist = dv_product_mian_deve.FirstOrDefault(" where pd_sku = @0 and pd_country = @1", mainInfo.Code, mainInfo.Site);
                    if (isExist == null)
                    {
                        foreach (var objSku in mainInfo.ProductList)
                        {
                            objSku.Sku = $"[{objSku.WareCode}]{objSku.Sku}";
                            objSku.Source = 9;
                        }
                        result = DockingSystemServices.SaveMainProductBase(mainInfo);
                    }
                    else
                    {
                        result.result_code = 1;
                        result.result_msg = "该商品已存在";
                    }
                }
                else
                {
                    result.result_code = 404;
                    result.result_msg = "appId验证错误";
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 添加组合SKU产品所有信息
        /// </summary>
        /// <returns></returns>
        [Route("AddProductGroup")]
        public ApiResult AddProductGroup(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.DecodeAndObject<List<yt_product_base>>(pare.data.data);
                    result = ProductGroupServices.AddProductGroup(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        #region 内部商品编码/产品编码生成接口
        /// <summary>
        /// 生成内部商品编码
        /// </summary>
        /// <returns></returns>
        [Route("GenerateCode")]
        public ApiResult GenerateCode(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    result.data = ProductDataServices.GenerateCode();
                    result.result_code = 1;
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 生成内部商品编码
        /// </summary>
        /// <returns></returns>
        [Route("GetGenerateCode")]
        public ApiResult GenerateCode()
        {
            ApiResult result = new ApiResult();
            try
            {
                result.data = ProductDataServices.GenerateCode();
                result.result_code = 1;
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 生成内部产品编码
        /// </summary>
        /// <returns></returns>
        [Route("CreateProductCode")]
        public ApiResult CreateProductCode(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var paraArr = CommonBaseLib.UrlToDecode(pare.data.data).Split(',');
                    if(paraArr.Length > 1)
                    {
                        string goodsCode = paraArr[0];
                        int index = Convert.ToInt32(paraArr[1]);
                        result.data = ProductDataServices.CreateProductCode(goodsCode, index);
                        result.result_code = 1;
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "传入的参数格式错误！";
                    }
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }
        #endregion
    }
}