﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Petapoco.Custom.HqygDto
{
    public class ProductBaseDto
    {
        /// <summary>
        /// 返回信息
        /// </summary>
        public bool response { get; set; }
        public int error_code { get; set; }
        public string error_msg { get; set; }

        public ProductInfo result { get; set; }
    }

    public class ProductInfo
    {
        /// <summary>
        /// 获得总行数
        /// </summary>
        public string totalCount { get; set; }

        public List<ProductBaseList> lists { get; set; }

        /// <summary>
        /// 图片文件路径
        /// </summary>
        public string file_path { get; set; }
    }

    public class ProductBaseList
    {
        #region 产品分类
        /// <summary>
        /// 分类ID    
        /// </summary>
        public string category_id { get; set; }

        /// <summary>
        /// 分类英文名称
        /// </summary>
        public string category_name_en { get; set; }

        /// <summary>
        /// 分类中文名称
        /// </summary>
        public string category_name { get; set; }

        /// <summary>
        /// 父级ID
        /// </summary>
        public string parent_id { get; set; }

        /// <summary>
        /// 层级
        /// </summary>
        public string level { get; set; }

        /// <summary>
        /// 上级路径
        /// </summary>
        public string path { get; set; }

        /// <summary>
        /// 1为可用，0为不可用（删除）
        /// </summary>
        public int is_enable { get; set; }
        /// <summary>
        /// 操作时间
        /// </summary>
        public DateTime update_time { get; set; }

        #endregion

        #region 系统币种
        /// <summary>
        /// 币种代码    
        /// </summary>
        public string currency_code { get; set; }

        /// <summary>
        /// 币种名称
        /// </summary>
        public string currency_name { get; set; }
        #endregion

        #region 产品性质
        /// <summary>
        /// 产品性质id    
        /// </summary>
        public string character_id { get; set; }

        /// <summary>
        /// 产品性质名称
        /// </summary>
        public string character_name { get; set; }

        /// <summary>
        /// 产品性质描述
        /// </summary>
        public string character_detail { get; set; }
        #endregion
    }
}
