﻿using DbConn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace API.Services.ProductManageServices
{
    public class DataToSameStock
    {
        private static readonly object SyncObj = new object();

        /// <summary>
        /// 新表数据操作同步到旧表
        /// </summary>
        public static void InsertOrUpdateToSame()
        {
            Task.Factory.StartNew(() =>
            {
                lock (SyncObj)
                {
                    RecursionMigration();
                }
            });
        }

        /// <summary>
        /// 递归执行新增或更新
        /// </summary>
        public static void RecursionMigration()
        {
            var stateList = yt_product_state.Fetch(" where st_toold = 0 limit 500").ToList();
            if (stateList.Count > 0)
            {
                DataMigrationStart(stateList);
                Thread.Sleep(1000);
            }
        }

        /// <summary>
        /// 启动数据同步到旧表任务
        /// </summary>
        private static void DataMigrationStart(List<yt_product_state> stateList)
        {
            foreach (var objState in stateList)
            {
                using (var dbContext = DbConnDB.GetInstance())
                {
                    using (var tx = dbContext.GetTransaction())
                    {
                        try
                        {
                            var objStock = yt_stock.Func_GetById(objState.st_sid);
                            objStock = objStock ?? new yt_stock();
                            var objBase = yt_product_base.Func_GetById(objState.st_sid);
                            var objExp = yt_product_exploit.FirstOrDefault(" where ex_sid = @0", objBase.s_id);
                            var objRelate = yt_product_supplier_relate.FirstOrDefault(" where sp_sku_id = @0 and sp_default = 1", objBase.s_id);
                            var objSup = yt_product_supplier.FirstOrDefault(" where sp_relation_id = @0", objRelate.sp_id);

                            //更新和新增公用修改字段
                            objStock.S_SPU = objBase.s_product;
                            objStock.S_SETNO = objBase.s_sku;
                            objStock.S_TITLE_CHINESE = objBase.s_ctitle.Replace(Environment.NewLine, "");
                            objStock.S_TITLE = objBase.s_etitle.Replace(Environment.NewLine, "");
                            objStock.S_Cname = objBase.s_ctitle_alias != null ? objBase.s_ctitle_alias.Replace(Environment.NewLine, "") : "";
                            objStock.S_CATEGORY_NEW = objBase.s_category_id ?? 0;
                            objStock.S_CATEGORYNAME_NEW = objBase.s_category_name ?? "";
                            objStock.S_SKUTYPE = objBase.s_skutype ?? 0;
                            objStock.IsFinishProduct = objBase.s_isfinish ?? 0;
                            objStock.S_WEIGHT = objBase.s_weight ?? 0;
                            objStock.S_Unit = objBase.s_unit ?? "";
                            objStock.S_PRICE = objBase.s_price ?? 0;
                            objStock.S_CURRENCY = objBase.s_currency ?? "";
                            objStock.S_IMAGE_MAIN = objBase.s_main_image ?? "";
                            objStock.S_IMAGE = objBase.s_child_image ?? "";
                            objStock.S_COLOR = objBase.s_color ?? "";
                            objStock.S_SIZE = objBase.s_size ?? "";
                            objStock.S_SIZE1 = objBase.s_size1 ?? "";
                            objStock.S_SIZE2 = objBase.s_size2 ?? "";
                            objStock.S_PRODUCT_SIZE = objBase.s_product_size ?? "0,0,0";
                            objStock.S_PACKING_SIZE = objBase.s_packing_size ?? "0,0,0";
                            objStock.S_PACKING_NAME = objBase.s_packing_name ?? "";
                            objStock.S_PACKING_PRICE = objBase.s_packing_price ?? 0;
                            objStock.S_PACKING_WEIGHT = objBase.s_packing_weight ?? 0;
                            objStock.S_PACKINHG_REQ = objBase.s_packing_req ?? "";
                            objStock.S_PackBSku = objBase.s_packing_skuid ?? 0;
                            objStock.G_CHARGER_SPEC = objBase.s_charger_spec ?? 0;
                            objStock.G_PRODUCT_CHARACTER = objBase.s_product_character ?? "";
                            objStock.S_BAILUN_CHARACTER = objBase.s_bailun_character ?? "";
                            objStock.S_PEIHUO1 = objBase.s_cpeihuo ?? "";
                            objStock.S_PEIHUO2 = objBase.s_epeihuo ?? "";
                            objStock.S_BAOGUAN1 = objBase.s_cbaoguan ?? "";
                            objStock.S_BAOGUAN2 = objBase.s_ebaoguan ?? "";
                            objStock.S_HSCODE = objBase.s_hscode ?? "";
                            objStock.S_CONTENT = objBase.s_content ?? "";
                            objStock.S_UPDATENAME = objBase.s_updatename ?? "";
                            objStock.S_UPDATETIME = objBase.s_updatetime ?? DateTime.Now;
                            objStock.S_OPERATIONRTYPE = objBase.s_operatetype;

                            objStock.S_SHOPNAME = objExp.ex_shopname ?? "";
                            objStock.S_BUSSINESS = objExp.ex_bussiness_id ?? 0;
                            objStock.S_BUSSINESS_NAME = objExp.ex_bussiness_name ?? "";
                            objStock.S_BUYER = objExp.ex_buyer;
                            objStock.S_BUYER_NAME = objExp.ex_buyer_name ?? "";
                            objStock.S_Supplier_id = objExp.ex_supplier_id ?? 0;
                            objStock.S_Sales_Price = objExp.ex_sales_price ?? 0;
                            objStock.S_MAXLIRUN = objExp.ex_maxlirun ?? 0;
                            objStock.S_MAXLIRUNLV = objExp.ex_maxlirunlv ?? 0;
                            objStock.S_SHIPPING_FEE = objExp.ex_shipping_fee ?? 0;
                            objStock.s_default_warecode = objExp.ex_default_warecode;
                            objStock.S_Label_Req = objExp.ex_label_req ?? "";
                            objStock.TestHour = objExp.ex_testhour ?? 0;
                            objStock.QualityRequirements = objExp.ex_zhijian_req ?? "";
                            objStock.S_PROCESTATUS = objExp.ex_procestatus ?? 0;
                            objStock.S_ENABLE = objExp.ex_enable ?? 0;
                            objStock.S_IS_HESUAN = objExp.ex_is_hesuan ?? 0;
                            objStock.S_ZLYFINISH = objExp.ex_zlyfinish ?? 0;
                            objStock.S_DATA_STATE = objExp.ex_procestatus == 911 ? 1 : 0;

                            objStock.S_STATUS = objState.st_status ?? 0;
                            objStock.S_ISBUY = objState.st_isbuy ?? 2;
                            objStock.IsUpApi = objState.st_isupapi ?? 0;
                            objStock.LastUpdateIsSynchro = objState.st_lastupdate_state == 1 ? true : false;
                            objStock.S_CATEGORYNAME = objState.st_reason ?? "";
                            objStock.S_DELIVERID = objRelate.sp_sp_id;

                            objStock.S_ENQUIRY = objSup.sp_enquiry_id;
                            objStock.S_ENQUIRY_NAME = objSup.sp_enquiry_name ?? "";
                            objStock.S_DELIVERID = objSup.sp_deliver_id;
                            objStock.S_DELIVER_NAME = objSup.sp_deliver_name ?? "";
                            objStock.SupplierLink = objSup.sp_link ?? "";
                            objStock.S_Delivery = objSup.sp_delivery;
                            objStock.S_Moq = objSup.sp_moq ?? 0;
                            objStock.S_Internal_Moq = objSup.sp_internal_moq ?? 0;
                            objStock.Remarks = objSup.sp_remark ?? "";
                            if (objStock.S_ID > 0)
                            {
                                objStock.Update();
                            }
                            else
                            {
                                objStock.S_MIAN_ID = objBase.s_main_id;
                                objStock.SysProductCode = objBase.s_goods_code ?? "";
                                objStock.SysGoodsCode = objBase.s_product_code ?? "";
                                objStock.S_ExamId = objExp.ex_examid ?? 0;
                                objStock.DevelopmentTime = objBase.s_developtime ?? DateTime.Now;
                                objStock.S_CREATEUSERNAME = objBase.s_createname ?? "";
                                objStock.S_CREATETIME = objBase.s_createtime ?? DateTime.Now;
                                objStock.Insert();
                                dbContext.Execute("update yt_stock set s_id = @0 where s_id = @1", objBase.s_id, objStock.S_ID);
                            }

                            //更新状态表
                            objState.st_toold = 1;
                            objState.Update(new string[] { "st_toold" });
                            tx.Complete();
                        }
                        catch (Exception ex)
                        {
                            tx.Dispose();
                            objState.st_toold = 2;
                            objState.st_reason = ex.Message;
                            objState.Update(new string[] { "st_toold", "st_reason" });
                            tx.Complete();
                        }
                    }
                }
            }
            RecursionMigration();
        }
    }
}
