﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Petapoco.Custom.SkuMap
{
    public class PlatAndSiteInfo
    {
        /// <summary>
        /// 类型 1平台，2站点
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// 主键
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 对应父级
        /// </summary>
        public int parentId { get; set; }

        /// <summary>
        /// 英文名称
        /// </summary>
        public string englishName { get; set; }

        /// <summary>
        /// 中文名称
        /// </summary>
        public string chinaName { get; set; }
    }

    public class PlatAccountInfo
    {
        /// <summary>
        /// 返回结果
        /// </summary>
        public bool Success { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// 帐号数据
        /// </summary>
        public List<sellerAccount> Data { get; set; }
    }

    public class sellerAccount
    {
        /// <summary>
        /// 帐号Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 平台Id
        /// </summary>
        public int PlatformId { get; set; }

        /// <summary>
        /// 平台中文名称
        /// </summary>
        public string Platform { get; set; }

        /// <summary>
        /// 平台英文名称
        /// </summary>
        public string PlatformEn { get; set; }

        /// <summary>
        /// 平台Id
        /// </summary>
        public int SiteId { get; set; }

        /// <summary>
        /// 站点中文名
        /// </summary>
        public string Site { get; set; }

        /// <summary>
        /// 站点英文名
        /// </summary>
        public string SiteEn { get; set; }

        /// <summary>
        /// 登录帐号
        /// </summary>
        public string Account { get; set; }

        /// <summary>
        /// email帐号
        /// </summary>
        public string EmailAccount { get; set; }

        /// <summary>
        /// oms帐号
        /// </summary>
        public string OmsAccount { get; set; }
    }
}
