﻿
using ApiControl;
using PetaPoco.Custom.ProductData;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;

namespace API.Services.ProductManageServices
{
    public class WareDataServices
    {
        public static string SystemWMS = ConfigurationManager.AppSettings["SystemWMS"];
        /// <summary>
        /// 获取默认采购仓库
        /// </summary>
        /// <returns></returns>
        public static List<WareInfo> GetDefaultWareList(int wareType = 0, int areaId = 0)
        {
            var wareList = new List<WareInfo>();
            try
            {
                var paraStr = "";
                if (areaId > 0)
                    paraStr = "\"areaId\":" + areaId;
                else if (wareType > 0)
                    paraStr = "\"functionIds\":[" + wareType + "]";

                var resultJson = HttpGetOrPost.HttpPostJson(SystemWMS + "/api/services/app/WarehouseService/SearchWarehouse", "{\"Data\":{" + paraStr + "}}");
                var wareResult = CommonBaseLib.GetJsonToObject<ResultWareInfo>(resultJson);
                if (wareResult.isSuccess)
                    wareList = wareResult.data.Where(m => !string.IsNullOrWhiteSpace(m.code)).ToList();
            }
            catch
            {

            }
            return wareList;
        }

        /// <summary>
        /// 获取所有区域信息
        /// </summary>
        /// <returns></returns>
        public static List<AreaList> GetAllAreaInfoList()
        {
            var areaList = new List<AreaList>();
            try
            {
                var areaInfo = CommonBaseLib.GetJsonToObject<AreaWareInfo>(HttpGetOrPost.httpGet(SystemWMS + "/api/services/app/WarehouseService/DropDownWarehouseArea"));
                areaList = areaInfo.data;
            }
            catch
            {

            }
            return areaList;
        }

        /// <summary>
        /// 获取区域下仓库信息
        /// </summary>
        /// <returns></returns>
        public static List<WareInfo> GetWareInfoFromArea(int areaId)
        {
            var wareList = GetDefaultWareList(0, areaId);
            return wareList;
        }
    }
}
