﻿
using API.Services.ProductManageServices;
using ApiControl;
using DbConn;
using Petapoco.ShowProduct.Custom;
using PetaPoco;
using PetaPoco.Custom.ProductData;
using PetaPoco.Custom.SkuMap;
using System;
using System.Collections.Generic;
using System.Linq;

namespace API.Services.PmsApiServices
{
    public class GetDataServices
    {
        #region sku资料相关
        /// <summary>
        /// 获取产品数据
        /// </summary>
        /// <param name="dataJson"></param>
        /// <returns></returns>
        public static ApiResult GetGoodsListInfo(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                var objCon = CommonBaseLib.GetJsonToObject<ConditionShowProduct>(dataJson);
                var goodsList = dv_product_mian_deve.QueryIndexPage(objCon.page, objCon.pageSize);
                if (goodsList != null)
                {
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(goodsList);
                }
            }
            catch
            {
                result = ApiDataManage.CreateApiResult(504);
            }
            return result;
        }

        /// <summary>
        /// 获取产品数据
        /// </summary>
        /// <param name="dataJson"></param>
        /// <returns></returns>
        public static ApiResult GetProductInfos(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                ConditionInterface objCon = CommonBaseLib.DecodeAndObject<ConditionInterface>(dataJson);
                var wareList = new List<WareInfo>();
                if(objCon.resultType >= 99)
                    wareList = WareDataServices.GetDefaultWareList(0, 18);
                var resultJson = yt_product_base.GetAllProductEntrance(objCon, wareList);

                if (!string.IsNullOrWhiteSpace(resultJson))
                {
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = resultJson;
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(404);
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg += ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 获取产品基本信息
        /// </summary>
        /// <param name="api"></param>
        /// <returns></returns>
        public static ApiResult GetProductBase(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                string skuStr = CommonBaseLib.UrlToDecode(dataJson);
                string[] skuArr = skuStr.Split(',');
                if(skuArr.Length > 1000)
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = "查询数量不能大于1000行";
                    return result;
                }

                var productList = yt_product_base.Fetch(" where s_sku in (@skus) and s_operatetype != 'Delete'", new { skus = skuArr }).ToList();
                if (productList.Count > 0)
                {
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(productList);
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.data = "找不到相关信息！";
                }
            }
            catch(Exception ex)
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "系统异常，请联系管理员。";
            }
            return result;
        }

        /// <summary>
        /// 获取开发基本信息
        /// </summary>
        /// <param name="api"></param>
        /// <returns></returns>
        public static ApiResult GetProductExploit(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                string skuStr = CommonBaseLib.UrlToDecode(dataJson);
                string[] skuArr = skuStr.Split(',');
                if (skuArr.Length > 1000)
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = "查询数量不能大于1000行";
                    return result;
                }

                var exploitList = yt_product_exploit.Fetch(" where ex_sku in (@skus)", new { skus = skuArr }).ToList();
                if (exploitList.Count > 0)
                {
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(exploitList);
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.data = "找不到相关信息！";
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "系统异常，请联系管理员。";
            }
            return result;
        }

        /// <summary>
        /// 获取供应商基本信息
        /// </summary>
        /// <param name="api"></param>
        /// <returns></returns>
        public static ApiResult GetProductSupplier(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                string skuStr = CommonBaseLib.UrlToDecode(dataJson);
                string[] skuArr = skuStr.Split(',');
                if (skuArr.Length > 1000)
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.result_msg = "查询数量不能大于1000行";
                    return result;
                }

                var supplierList = yt_product_supplier.Fetch(" where sp_sku in (@skus)", new { skus = skuArr }).ToList();
                if (supplierList.Count > 0)
                {
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(supplierList);
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(600);
                    result.data = "找不到相关信息！";
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg = "系统异常，请联系管理员。";
            }
            return result;
        }

        #endregion

        #region sku映射相关
        /// <summary>
        /// 获取sku映射数据
        /// </summary>
        /// <param name="dataJson"></param>
        /// <returns></returns>
        public static ApiResult GetSkuMapInfo(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                ResultSkuMapInfo objMap = CommonBaseLib.DecodeAndObject<ResultSkuMapInfo>(dataJson);
                var resultJson = yt_sku_mapping.GetAllSkuMapEntrance(objMap);

                if (resultJson != "")
                {
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = resultJson;
                }
                else
                {
                    result = ApiDataManage.CreateApiResult(404);
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(504);
                result.result_msg += ex.Message;
            }
            return result;
        }
        #endregion
    }
}
