﻿using ApiControl;
using DbConn;
using PetaPoco;
using PetaPoco.Custom.PlatData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace API.Services.PlatDataManageServices
{
    public class PlatFeeServices
    {
        public static ApiResult GetPlatFeeList(string plat, string site)
        {
            ApiResult result = new ApiResult();
            result.result_code = 500;
            var resultList = new List<PlatFee>();
            if(plat == "Ebay")
            {
                resultList = GetEbayPlatFeeList(site);
                result.result_code = 1;
            }
            else
            {
                result.result_code = 404;
                result.result_msg = "没有找到符合的平台";
            }
            result.data = CommonBaseLib.GetJsonToString(resultList);
            return result;
        }

        /// <summary>
        /// 获取Ebay平台费用
        /// </summary>
        /// <param name="site"></param>
        private static List<PlatFee> GetEbayPlatFeeList(string site)
        {
            Sql sql = Sql.Builder;
            sql.Append(" select 'Ebay' Plat,yt_site Site,yt_c_id Id,yt_c_parentid ParentId,yt_c_name Name,yt_c_level Level,yt_ebayfee Fee from yt_ebay_category ");
            sql.Append(" where yt_ebayfee > 0");
            if (!string.IsNullOrWhiteSpace(site))
                sql.Append(" and yt_site = @0", site);
            var dataList = DbConnDB.Record<PlatFee>.Fetch(sql);
            return dataList;
        }

        #region 根据分类获取平台费用
        /// <summary>
        /// 根据分类获取平台费用
        /// </summary>
        /// <returns></returns>
        public static ApiResult GetCategoryPlatFeeList(List<PrimaryPlatFee> list)
        {
            Sql sql = Sql.Builder;
            sql.Append(" select 'Ebay' Plat,yt_site Site,yt_c_id Id,yt_c_parentid ParentId,yt_c_name Name,yt_c_level Level,yt_ebayfee Fee from yt_ebay_category ");
            var dataList = DbConnDB.Record<PlatFee>.Fetch(sql);
            var resultList = new List<PrimaryPlatFee>();
            list = list.Distinct().ToList();       //去重处理，避免不必要的循环
            foreach (var item in list)
            {
                var plat = item.Plat;
                var site = item.Site;
                var cateId = item.PrimaryId;
                if (item.Plat == "Ebay")
                {
                    var objPlatFee = dataList.FirstOrDefault(m => m.Site == item.Site && m.Id == item.PrimaryId);
                    if (objPlatFee != null)
                    {
                        var objPriFee = new PrimaryPlatFee();
                        objPriFee.Plat = plat;
                        objPriFee.Site = site;
                        objPriFee.PrimaryId = cateId;
                        if (objPlatFee.Fee > 0)
                        {
                            objPriFee.Fee = objPlatFee.Fee;
                        }
                        else
                        {
                            objPriFee.Fee = GetEbayFee(dataList, site, cateId);
                        }
                        resultList.Add(objPriFee);
                    }
                }
            }

            ApiResult result = new ApiResult();
            result.result_code = 1;
            if (resultList.Count > 0)
                result.data = CommonBaseLib.GetJsonToString(resultList);
            else
                result.data = "[]";
            return result;
        }

        private static decimal GetEbayFee(List<PlatFee> dataList, string site, int cateId)
        {
            var objPlatFee = dataList.FirstOrDefault(m => m.Site == site && m.Id == cateId);
            if (objPlatFee == null || objPlatFee.Id == 0)
            {
                return 10;
            }
            else
            {
                //第一级
                if (objPlatFee.Id == objPlatFee.ParentId)
                {
                    return objPlatFee.Fee > 0 ? objPlatFee.Fee : 10;
                }
                else if (!(objPlatFee.Fee > 0))
                {
                    return GetEbayFee(dataList, site, objPlatFee.ParentId);
                }
                else
                {
                    return objPlatFee.Fee;
                }
            }
        }
        #endregion
    }
}
