﻿using ApiControl;
using CommonControl;
using DbConn;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace API.Services.DataMigrationServices
{
    public class OldImageUrlToNew
    {
        #region 旧图片地址迁移到新地址
        public static void OldImageUrlToNewStart()
        {
            runOldImageUrlToNew();
        }

        private static void runOldImageUrlToNew()
        {
            var list = yt_product_base.Fetch(" where s_main_image like 'http://pdsimg.blsct.com%' or s_child_image like 'http://pdsimg.blsct.com%' limit 5000");
            if (list.Count > 0)
            {
                //Thread.Sleep(10000);
                OldImageUrlToNewSync(list);
                //Thread.Sleep(3000);
                runOldImageUrlToNew();
            }
        }

        private static void OldImageUrlToNewSync(List<yt_product_base> list)
        {
            foreach (var objBase in list)
            {
                //先进行主图替换
                //objBase.s_main_image = objBase.s_main_image.Replace("http://p6jo4u8x0.bkt.clouddn.com", "http://pdsimg.blsct.com");
                //objBase.s_child_image = objBase.s_child_image.Replace("http://p6jo4u8x0.bkt.clouddn.com", "http://pdsimg.blsct.com");
                var mainArr = objBase.s_main_image.Split(',');
                foreach(var imgUrl in mainArr)
                {
                    if(!string.IsNullOrWhiteSpace(imgUrl))
                    {
                        string fileName = Path.GetFileName(objBase.s_main_image);
                        fileName = CommonBaseLib.UrlToDecode(fileName);
                        var result = QiNiuCloudHelper.FetchFile(imgUrl, ref fileName);
                        objBase.s_main_image = objBase.s_main_image.Replace(imgUrl, fileName);
                        objBase.s_child_image = objBase.s_child_image.Replace(imgUrl, fileName);
                    }
                }

                //子图替换
                var childArr = objBase.s_child_image.Split(',');
                foreach (var imgUrl in childArr)
                {
                    if (imgUrl.Contains("http://pdsimg.blsct.com") && !string.IsNullOrWhiteSpace(imgUrl))
                    {
                        string fileName = Path.GetFileName(objBase.s_child_image);
                        fileName = CommonBaseLib.UrlToDecode(fileName);
                        var result = QiNiuCloudHelper.FetchFile(imgUrl, ref fileName);
                        objBase.s_child_image = objBase.s_child_image.Replace(imgUrl, fileName);
                    }
                }
                objBase.Update(new string[] { "s_main_image", "s_child_image" });
            }
        }
        #endregion
    }
}
