﻿using API.Services.SkuMapManageServices;
using ApiControl;
using PetaPoco.Custom;
using System;
using System.Collections.Generic;
using System.Web.Http;

namespace WebApi.Areas.SkuMapManage.Controllers
{
    /// <summary>
    /// sku映射资料管理
    /// </summary>
    [RoutePrefix("api/SkuMapManage")]
    public class SkuMapController : ApiController
    {
        /// <summary>
        /// 保存产品所有信息
        /// </summary>
        /// <returns></returns>
        [Route("AddSkuMapInfo")]
        public ApiResult AddSkuMapInfo(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = CommonBaseLib.GetJsonToObject<BltAddSkuMap>(pare.data.data);
                    result = SkuMapServices.AddSkuMapInfo(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }


    }
}