﻿using API.Services.ProductManageServices;
using ApiControl;
using PetaPoco.Custom.ProductData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;

namespace WebApi.Areas.ProductManage.Controllers
{
    /// <summary>
    /// Api入口控制中心
    /// </summary>
    [RoutePrefix("api/Distribute")]
    public class DistributeController : ApiController
    {
        // GET: ProductManage/Distribute
        /// <summary>
        /// 更新分销产品库存信息
        /// </summary>
        /// <returns></returns>
        [Route("UpdateDistributeProductState")]
        public ApiResult UpdateDistributeProductState(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var model = CommonBaseLib.DecodeAndObject<List<DistributeProduct>>(pare.data.data);
                    result = ProductServices.UpdateProductStockState(model);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }
    }
}