﻿using ApiControl;
using CommonControl;
using PetaPoco;
using PetaPoco.Custom.SkuMap;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DbConn
{
    public partial class yt_sku_mapping : DbConnDB.Record<yt_sku_mapping>
    {
        public static string GetAllSkuMapEntrance(ResultSkuMapInfo objMap)
        {
            string resultJson = "";
            string strSql = "";
            Sql sql = Sql.Builder;
            strSql = " select yt_id as id,yt_platformid as platId,yt_platform as plat,yt_siteid as siteId,yt_site as site,yt_accountid as accountId,yt_loginAccount as loginAccount"
                       + ",yt_account as account,yt_sellername as sellerName,yt_new_productCode as platProduct,yt_itemid as itemId,yt_new_sku as platSku,yt_setno as sku"
                       + ",yt_title as title,yt_count as count,yt_fullname_category as fullName,yt_old_productCode as goodsCode,yt_old_sku as productCode"
                       + ",yt_productid as mainId,yt_s_id as sId,yt_spu as product,yt_attribute_type as attrType,yt_isgroup as isGroup,yt_isany as isAny,yt_ismap as isMap"
                       + ",yt_isupapi as isUpApi,yt_errormsg as errorMsg,yt_createuser as createUser,yt_createtime as createTime from yt_sku_mapping where yt_operatetype != 'Delete' and yt_site != ''";
            sql.Append(strSql);

            #region 组装查询条件
            if (!string.IsNullOrWhiteSpace(objMap.plat))
                sql.Append(" and yt_platform = @0", objMap.plat);
            if (!string.IsNullOrWhiteSpace(objMap.site))
                sql.Append(" and yt_site = @0", objMap.site);
            if (!string.IsNullOrWhiteSpace(objMap.account))
                sql.Append(" and yt_account = @0", objMap.account);
            if (!string.IsNullOrWhiteSpace(objMap.sellerName))
                sql.Append(" and yt_sellername = @0", objMap.sellerName);
            if (!string.IsNullOrWhiteSpace(objMap.platProduct))
                sql.Append(" and yt_new_productCode = @0", objMap.platProduct);
            if (!string.IsNullOrWhiteSpace(objMap.itemId))
                sql.Append(" and yt_itemid = @0", objMap.itemId);
            if (!string.IsNullOrWhiteSpace(objMap.loginAccount))
                sql.Append(" and yt_loginAccount = @0", objMap.loginAccount);
            if (objMap.platId > 0)
                sql.Append(" and yt_platformid = @0", objMap.platId);
            if (objMap.siteId > 0)
                sql.Append(" and yt_siteid = @0", objMap.siteId);
            if (objMap.accountId > 0)
                sql.Append(" and yt_accountid = @0", objMap.accountId);

            if (!string.IsNullOrWhiteSpace(objMap.platSku))
            {
                var platSkuArr = objMap.platSku.Split(',');
                sql.Append(" and yt_new_sku in (@platSkus)", new { platSkus = platSkuArr });
            }
            if (!string.IsNullOrWhiteSpace(objMap.sku))
            {
                var skuArr = objMap.sku.Split(',');
                sql.Append(" and yt_setno in (@skus)", new { skus = skuArr });
            }
            
            if(!string.IsNullOrWhiteSpace(objMap.search))
            {
                if (objMap.type == 1)
                {
                    if (objMap.searchType == 1)
                        sql.Append(" and yt_new_sku like @0",$"{objMap.search}%");
                    else if (objMap.searchType == 2)
                        sql.Append(" and yt_setno like @0", $"{objMap.search}%");
                    else if (objMap.searchType == 3)
                        sql.Append(" and yt_title like @0", $"{objMap.search}%");
                }
                else
                {
                    if (objMap.searchType == 1)
                        sql.Append(" and yt_new_sku = @0", objMap.search);
                    else if (objMap.searchType == 2)
                        sql.Append(" and yt_setno = @0", objMap.search);
                    else if (objMap.searchType == 3)
                        sql.Append(" and yt_title = @0", objMap.search);
                }
            }
            
            if (objMap.firCate > 0)
                sql.Append(" and yt_fir_category = @0", objMap.firCate);
            if (objMap.secCate > 0)
                sql.Append(" and yt_sec_categoryy = @0", objMap.secCate);
            if (!string.IsNullOrWhiteSpace(objMap.attrType))
                sql.Append(" and yt_attribute_type = @0", objMap.attrType);
            if (!string.IsNullOrWhiteSpace(objMap.isGroup))
                sql.Append(" and yt_isgroup = @0", objMap.isGroup);
            if (!string.IsNullOrWhiteSpace(objMap.isAny))
                sql.Append(" and yt_isany = @0", objMap.isAny);
            if (!string.IsNullOrWhiteSpace(objMap.isMap))
            {
                if(objMap.isMap == "0")
                    sql.Append(" and yt_ismap = 0");
                else if(objMap.isMap == "2")
                    sql.Append(" and yt_ismap = 0 and yt_sellername = '' and yt_setno != ''");
                else if(objMap.isMap == "3")
                    sql.Append(" and yt_ismap = 0 and yt_setno = ''");
                else if (objMap.isMap == "4")
                    sql.Append(" and yt_setno != ''");
                else
                    sql.Append(" and (yt_ismap = @0 or yt_s_id > 0)", objMap.isMap);
            }
                
            if (!string.IsNullOrWhiteSpace(objMap.isUpApi))
                sql.Append(" and yt_isupapi = @0", objMap.isUpApi);
            if (!string.IsNullOrWhiteSpace(objMap.source))
                sql.Append(" and yt_source = @0", objMap.source);

            #endregion

            //最后排序
            if (!string.IsNullOrWhiteSpace(objMap.sortField))
            {
                sql.Append(string.Format(" order by {0} {1}", objMap.sortField, objMap.sort));
            }

            if (objMap.resultType == 1)
                resultJson = QueryEntityCommon(sql);
            else if (objMap.resultType == 2)
                resultJson = QueryPageCommon(sql, objMap.page, objMap.pageSize);
            else if (objMap.resultType == 3)
                resultJson = QueryListCommon(sql);
            else if (objMap.resultType == 99)
            {
                resultJson = ExportSkuMapEntrance(sql);
            }
            return resultJson;
        }

        /// <summary>
        /// 返回实体列表查询
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static string QueryEntityCommon(Sql sql)
        {
            sql.Append(" group by yt_platform,yt_site,yt_account,yt_new_sku limit 1000");
            var resultList = repo.Fetch<ResultSkuMapInfo>(sql).ToList();
            var strJson = CommonBaseLib.EncodeAndJson(resultList);
            return strJson;
        }

        /// <summary>
        /// 返回集合列表查询
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static string QueryListCommon(Sql sql)
        {
            sql.Append(" order by yt_createtime desc");
            var resultList = repo.Fetch<ResultSkuMapInfo>(sql).ToList();
            foreach(var item in resultList)
            {
                item.platSku = item.platSku.ToUpper();
            }
            //返回最新时间的帐号对应关系
            var platSkuList = resultList.GroupBy(m => new { m.platSku }).ToList();
            var accountList = resultList.GroupBy(m => new { m.accountId, m.itemId, m.platSku }).ToList();
            var collList = new List<ResultSkuMapInfo>();
            foreach(var objPlatSku in platSkuList)
            {
                var objAccountId = accountList.FirstOrDefault(m => m.Key.platSku == objPlatSku.Key.platSku);
                var myPlatSkuList = resultList.Where(m => m.platSku == objPlatSku.Key.platSku && m.accountId == objAccountId.Key.accountId && m.itemId == objAccountId.Key.itemId).ToList();
                foreach (var item in myPlatSkuList)
                {
                    if (item.isGroup == "0")
                    {
                        var isExist = collList.FirstOrDefault(m => m.accountId == item.accountId && m.itemId == item.itemId && m.platSku == item.platSku);
                        if(isExist == null)
                            collList.Add(item);
                    }
                    else if (item.isGroup == "1")
                    {
                        var isExist = collList.FirstOrDefault(m => m.accountId == item.accountId && m.itemId == item.itemId && m.platSku == item.platSku && m.sku == item.sku);
                        if(isExist == null)
                        {
                            var groupList = yt_product_group.Fetch(" where stock_sku = @0", item.sku);
                            foreach (var groupItem in groupList)
                            {
                                string tempJson = CommonBaseLib.GetJsonToString(item);
                                var tempModel = CommonBaseLib.GetJsonToObject<ResultSkuMapInfo>(tempJson);
                                tempModel.sId = groupItem.sku_id;
                                tempModel.sku = groupItem.sku.ToUpper();
                                tempModel.count = groupItem.count;
                                collList.Add(tempModel);
                            }
                        }
                    }
                }
            }
            
            var strJson = CommonBaseLib.EncodeAndJson(collList);
            return strJson;
        }

        /// <summary>
        /// 列表按分页查询
        /// </summary>
        /// <param name="SearchType"></param>
        /// <param name="Search"></param>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        public static string QueryPageCommon(Sql sql, int page = 1, int pageSize = 25)
        {
            //限制分页数最大1000
            if (pageSize > 1000)
                pageSize = 1000;

            Page<ResultSkuMapInfo> pageData = repo.Page<ResultSkuMapInfo>(page, pageSize, sql);
            var dataList = GetGroupMapingRelate(pageData.Items, "<br />");
            pageData.Items = dataList;
            var strJson = CommonBaseLib.EncodeAndJson(pageData);
            return strJson;
        }

        /// <summary>
        /// 拼装组合关系
        /// </summary>
        /// <param name="pageData"></param>
        /// <returns></returns>
        public static List<ResultSkuMapInfo> GetGroupMapingRelate(List<ResultSkuMapInfo> dataList, string ruleStr)
        {
            foreach (var item in dataList)
            {
                //拼装组合关系
                if (item.isGroup == "1")
                {
                    var groupList = yt_product_group.Fetch(" where stock_sku = @0", item.sku);
                    if (groupList.Count > 0)
                        item.groupRelete = string.Join(ruleStr, groupList.Select(s => s.sku + "×" + s.count));
                    else
                        item.groupRelete = "数据异常";
                }
                else if(!string.IsNullOrWhiteSpace(item.sku))
                    item.groupRelete = item.sku + "×" + item.count;

                //组装对应站点的指定的链接
                if (!string.IsNullOrWhiteSpace(item.itemId))
                {
                    #region 平台对应产品地址
                    if (item.plat == "Ebay")
                    {
                        if (item.site == "UK")
                            item.ItemUrl = "https://www.ebay.co.uk/itm/" + item.itemId;
                        else if (item.site == "US")
                            item.ItemUrl = "http://www.ebay.com/itm/" + item.itemId;
                        else if(item.site == "Canada")
                            item.ItemUrl = "http://www.ebay.ca/itm/" + item.itemId;
                        else if (item.site == "Australia")
                            item.ItemUrl = "http://www.ebay.com.au/itm/" + item.itemId;
                        else if (item.site == "Austria")
                            item.ItemUrl = "http://www.ebay.at/itm/" + item.itemId;
                        else if (item.site == "France")
                            item.ItemUrl = "http://www.ebay.fr/itm/" + item.itemId;
                        else if (item.site == "Germany")
                            item.ItemUrl = "http://www.ebay.de/itm/" + item.itemId;
                        else if (item.site == "Italy")
                            item.ItemUrl = "http://www.ebay.it/itm/" + item.itemId;
                        else if (item.site == "Spain")
                            item.ItemUrl = "http://compraventa.ebay.es/itm/" + item.itemId;
                        else if (item.site == "Malaysia")
                            item.ItemUrl = "http://www.ebay.com.my/itm/" + item.itemId;
                        else if (item.site == "Japan")
                            item.ItemUrl = "https://www.ebay.co.jp/itm/" + item.itemId;
                        else
                            item.ItemUrl = "http://www.ebay.com/itm/" + item.itemId;
                    }
                    else if (item.plat == "Amazon")
                    {
                        if (item.site == "UK")
                            item.ItemUrl = "https://www.amazon.co.uk/gp/product/" + item.itemId;
                        else if (item.site == "US")
                            item.ItemUrl = "https://www.amazon.com/gp/product/" + item.itemId;
                        else if (item.site == "DE")
                            item.ItemUrl = "https://www.amazon.de/gp/product/" + item.itemId;
                        else if (item.site == "FR")
                            item.ItemUrl = "https://www.amazon.fr/gp/product/" + item.itemId;
                        else if (item.site == "IT")
                            item.ItemUrl = "https://www.amazon.it/gp/product/" + item.itemId;
                        else if (item.site == "ES")
                            item.ItemUrl = "https://www.amazon.es/gp/product/" + item.itemId;
                        else if (item.site == "JP")
                            item.ItemUrl = "https://www.amazon.co.jp/gp/product/" + item.itemId;
                        else
                            item.ItemUrl = "https://www.amazon.com/gp/product/" + item.itemId;
                    }
                    else if (item.plat == "Aliexpress")
                    {
                        item.ItemUrl = "https://www.aliexpress.com/wholesale?SearchText=" + item.itemId;
                    }
                    else if (item.plat == "Cdiscount")
                    {
                        item.ItemUrl = "https://www.wish.com/#cid=" + item.itemId;
                    }
                    else if (item.plat == "Cdiscount")
                    {
                        item.ItemUrl = "https://www.cdiscount.com/" + item.itemId + ".html";
                    }
                    else if (item.plat == "PriceMinister")
                    {
                        item.ItemUrl = "http://www.priceminister.com/offer/buy/" + item.itemId;
                    }
                    #endregion
                }
            }
            return dataList;
        }

        #region sku映射导出模块
        /// <summary>
        /// 按条件筛选导出入口
        /// </summary>
        public static string ExportSkuMapEntrance(Sql sql)
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("平台名称");
            dt.Columns.Add("销售站点");
            dt.Columns.Add("平台帐号");
            dt.Columns.Add("平台SKU");
            dt.Columns.Add("产品库SKU");
            dt.Columns.Add("销售员");
            dt.Columns.Add("数量");
            dt.Columns.Add("平台编码").DataType.ToString();
            dt.Columns.Add("刊登编码");
            dt.Columns.Add("平台分类");
            dt.Columns.Add("中文名称");
            dt.Columns.Add("属性类型");
            dt.Columns.Add("是否组合");
            dt.Columns.Add("组合关系");
            dt.Columns.Add("任意色");
            dt.Columns.Add("是否上传");
            dt.Columns.Add("创建人");
            dt.Columns.Add("创建时间");

            string virtualPath = $"/ExprotFile/ExprotSkuMap/导出SKU映射数据.csv";
            string fullFileName = System.Web.HttpContext.Current.Server.MapPath("~" + virtualPath);
            //创建文件夹，保存文件
            string path = Path.GetDirectoryName(fullFileName);
            if (path != null) Directory.CreateDirectory(path);
            ExcelUtil.SaveCSV(dt, fullFileName);

            return ExportSkuMapCenter(sql, dt, fullFileName);
        }

        /// <summary>
        /// 导出产品数据处理中心
        /// </summary>
        private static string ExportSkuMapCenter(Sql sql, DataTable dt, string fullFileName, int page = 1, int pageSize = 20000)
        {
            Page<ResultSkuMapInfo> pageData = repo.Page<ResultSkuMapInfo>(page, pageSize, sql);
            var dataList = GetGroupMapingRelate(pageData.Items, ";");
            if (dataList.Count > 0)
            {
                page++;
                dt = ExportSkuMapExecute(dt, dataList);
                ExcelUtil.AppendCSV(dt, fullFileName);
                dt.Clear();
                return ExportSkuMapCenter(sql, dt, fullFileName, page);
            }
            return fullFileName;
        }

        /// <summary>
        /// 导出执行具体方法
        /// </summary>
        private static DataTable ExportSkuMapExecute(DataTable dt, List<ResultSkuMapInfo> dataList)
        {
            foreach (var item in dataList)
            {
                //获取分类一、二级路径
                string fullName = item.fullName ?? "";
                item.fullName = item.fullName ?? "";
                int index = item.fullName.IndexOf(" -> ");
                if (index > 0)
                {
                    index = item.fullName.IndexOf(" -> ", index + 1);
                    if (index > 0)
                        fullName = item.fullName.Substring(0, index);
                }

                //创建一个DataRow实例  
                DataRow row = dt.NewRow();
                row["平台名称"] = item.plat;
                row["销售站点"] = item.site;
                row["平台帐号"] = item.account;
                row["平台SKU"] = item.platSku;
                row["产品库SKU"] = "'" + item.sku.ToUpper();
                row["销售员"] = item.sellerName;
                row["数量"] = item.count;
                row["平台编码"] = "'" + item.itemId;
                row["平台分类"] = fullName;
                row["中文名称"] = item.title;
                row["刊登编码"] = item.platProduct;
                row["属性类型"] = item.attrType == "1" ? "单属性" : item.attrType == "2" ? "多属性" : "未确认";
                row["是否组合"] = item.isGroup == "1" ? "是" : "否";
                row["组合关系"] = item.groupRelete;
                row["任意色"] = item.isAny == "1" ? "是" : "否";
                row["是否上传"] = item.isUpApi == "1" ? "已上传" : "未上传";
                row["创建时间"] = item.createUser;
                row["创建时间"] = item.createTime;
                //加入到DataTable  
                dt.Rows.Add(row);
            }
            return dt;
        }
        #endregion
    }
}
