﻿using ApiControl;
using CommonControl;
using PetaPoco;
using PetaPoco.Custom.ProductData;
using System;
using System.Web;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using Spire.Xls;
using System.Threading.Tasks;

namespace DbConn
{
    public partial class yt_product_base : DbConnDB.Record<yt_product_base>
    {
        private static bool ExportObj = true;
        private static bool ExportAllObj = true;

        public static string GetAllProductEntrance(ConditionInterface objCon, List<WareInfo> wareList)
        {
            string resultJson = "";
            var sql = GetSearchSqlStr(objCon);
            var cdnSql = GetSearchCdnSqlStr(objCon);

            if (objCon.resultType == 1)
                resultJson = QueryEntityCommon(sql, objCon);
            else if (objCon.resultType == 2)
                resultJson = QueryPageCommon(sql, cdnSql, objCon);
            else if (objCon.resultType == 99)
            {
                if (ExportObj)
                {
                    ExportObj = false;
                    try
                    {
                        if (objCon.isResultSup == 1)
                            resultJson = ExportSupplierEntrance(objCon);
                        else
                            resultJson = ExportProductEntrance(objCon, wareList);
                    }
                    catch
                    {
                        ExportObj = true;
                    }
                    ExportObj = true;
                }
            }
            else if (objCon.resultType == 100)
            {
                if (ExportAllObj)
                {
                    ExportAllObj = false;
                    Task.Factory.StartNew(() =>
                    {
                        try
                        {
                            ExportProductEntrance(objCon, wareList, 1);
                            ExportAllObj = true;
                        }
                        catch (Exception ex)
                        {
                            ExportAllObj = true;
                        }
                    });
                }
                resultJson = "100";
            } 
            else if (objCon.resultType == 117)
            {
                if (ExportObj)
                {
                    ExportObj = false;
                    try
                    {
                            resultJson = SelectExportProductEntrance(objCon, wareList);
                    }
                    catch
                    {
                        ExportObj = true;
                    }
                    ExportObj = true;
                }
            }

            return resultJson;
        }

        /// <summary>
        /// 生成查询语句
        /// </summary>
        /// <param name="objCon"></param>
        /// <param name="wareList"></param>
        /// <returns></returns>
        private static Sql GetSearchSqlStr(ConditionInterface objCon)
        {
            string strSql = "";
            var content = new string[1];
            var isContent = true;
            if (!string.IsNullOrWhiteSpace(objCon.resultContent))
            {
                content = objCon.resultContent.Split(',');
                isContent = false;
            }
            Sql sql = Sql.Builder;
            strSql = "select b.s_id as id,h.s_main_id as mainId,s_goods_code as goodsCode,s_product_code as productCode,s_product as product,s_sku as sku";

            //主要基础信息
            if (isContent || Array.IndexOf(content, "1") != -1 || Array.IndexOf(content, "1-1") != -1)
            {
                strSql += ",s_ctitle as cTitle,s_etitle as eTitle,s_category_bailun_id cateBailunId,s_category_bailun_name cateBailunName,s_category_id as categoryId,s_category_name as categoryName,s_series series,s_main_image as mainImage,s_child_image as childImage";
            }
            //规格信息
            if (isContent || Array.IndexOf(content, "1") != -1 || Array.IndexOf(content, "1-2") != -1)
            {
                strSql += ",s_color as color,s_size as size,s_size1 as size1,s_size2 as size2,s_price as price,s_currency as currency"
                       + ",s_weight as weight,s_unit as unit,s_packing_weight as packingWeight,s_product_size as productSize,s_packing_size as packingSize,s_packing_name as packingName,s_packing_req packingReq,s_packing_skuid packingSkuid"
                       + ",s_packing_price as packingPrice,s_charger_spec as chargerSpec,s_product_character as productCharacter,s_cpeihuo as cPeiHuo,s_epeihuo as ePeiHuo,s_cbaoguan as cBaoGuan,s_ebaoguan as eBaoGuan,s_hscode as hsCode,s_package_nature packageNature";
            }
            //基础其他信息
            if (isContent || Array.IndexOf(content, "1") != -1 || Array.IndexOf(content, "1-3") != -1)
            {
                strSql += ",s_isfinish as isFinish,s_createname as createName,s_createtime as createTime,s_updatename as updateName,s_updatetime as updateTime";
            }
            //开发信息
            if (isContent || Array.IndexOf(content, "2") != -1)
            {
                strSql += ",ex_bussiness_id as bussinessId,ex_bussiness_name as bussinessName,ex_buyer as buyer,ex_buyer_name as buyerName,ex_default_warecode as wareCode,ex_label_req as labelReq,ex_testhour as testHour"
                       + ",ex_shopname as exploitSite,ex_sales_price as salesPrice,ex_zhijian_type as zhijianType,ex_zhijian_req as zhijianReq,ex_enable enable,ex_is_hesuan isHesuan,ex_source source";
            }
            //状态信息
            if (isContent || Array.IndexOf(content, "3") != -1)
            {
                strSql += ",st_status as status,st_isupapi as isUpApi,st_lastupdate_state as lastUpdateState,st_reason as reason";
            }
            //供应商信息
            if (isContent || Array.IndexOf(content, "4") != -1)
            {
                strSql += ",sp_enquiry_id enquiryId,sp_enquiry_name enquiryName,sp_deliver_id as deliverId,sp_deliver_name as deliverName,sp_link as link"
                        + ",s_price as virPrice,sp_moq as moq,sp_internal_moq as internalMoq,sp_delivery as delivery,sp_allot_delivery allotDelivery,sp_have_stall haveStall"
                        + ",sp_take_address takeAddress,sp_istake_goods istakeGoods,sp_remark as remark";
            }
            //商品信息
            if (isContent || Array.IndexOf(content, "5") != -1)
            {
                strSql += ",pd_colorname as colorName,pd_sizename as sizeName,pd_sizename1 as sizeName1,pd_sizename2 as sizeName2,pd_uid bargainer,pd_brand brand,pd_features codeImage,productStatus,pd_createtime developTime";
            }
            //自编SKU信息
            if (isContent || Array.IndexOf(content, "6") != -1)
            {
                strSql += ",is_custom_product";
            }
            strSql += " from (";
            sql.Append(strSql);

            var cdnSql = GetSearchCdnSqlStr(objCon);
            sql.Append(cdnSql.SQL, cdnSql.Arguments);
            //条件不排序时加入限制数据行
            if (string.IsNullOrWhiteSpace(objCon.sortField))
            {
                if (!(objCon.pageSize > 0 && objCon.pageSize <= 1000) && objCon.resultType < 90)
                {
                    objCon.page = 1;
                    objCon.pageSize = 1000;
                }
                sql.Append($" limit {(objCon.page - 1) * objCon.pageSize},{objCon.pageSize}");
            }
            sql.Append(") as b");
            sql.Append(" left join yt_product_base as h on b.s_id = h.s_id");
            sql.Append(" left join yt_product_exploit as a on b.s_id = a.ex_sid");
            sql.Append(" left join yt_product_state as c on b.s_id = c.st_sid");
            if (isContent || Array.IndexOf(content, "4") != -1)
            {
                sql.Append(" left join yt_product_supplier_relate as d on b.s_id = d.sp_sku_id and sp_default = 1");
                sql.Append(" left join yt_product_supplier as e on d.sp_id = e.sp_relation_id");
            }
            if (isContent || Array.IndexOf(content, "5") != -1)
                sql.Append(" left join dv_product_mian_deve as f on f.pd_mian_id = h.s_main_id");
            if (isContent || Array.IndexOf(content, "6") != -1)
                sql.Append(" left join dv_import_sku as g on g.is_sid = b.s_id");
            //最后排序
            if (!string.IsNullOrWhiteSpace(objCon.sortField))
            {
                sql.Append(string.Format(" order by {0} {1}", objCon.sortField, objCon.sort));
            }

            return sql;
        }

        private static Sql GetSearchCdnSqlStr(ConditionInterface objCon)
        {
            #region 组装查询条件
            Sql cdnSql = Sql.Builder;
            DateTime dtDefault = Convert.ToDateTime("1999-01-01");
            string hostSql = "";
            //判断主从表关系
            if (!string.IsNullOrWhiteSpace(objCon.skus) || !string.IsNullOrWhiteSpace(objCon.search) || objCon.cateId > 0 || !string.IsNullOrWhiteSpace(objCon.series)
            || objCon.beginCT > dtDefault || objCon.endCT > dtDefault || !string.IsNullOrWhiteSpace(objCon.updateDate))
            {
                hostSql = " select b.s_id from (select s_id from yt_product_base where s_operatetype != 'Delete'";
                cdnSql.Append(hostSql);

                if (!string.IsNullOrWhiteSpace(objCon.skus))
                {
                    string[] skuArr = objCon.skus.Split(',');
                    cdnSql.Append(" and s_sku in (@skus)", new { skus = skuArr });
                }
                else if (!string.IsNullOrWhiteSpace(objCon.search))
                {
                    if (objCon.type == 1)
                    {
                        if (objCon.searchType == 1)
                            cdnSql.Append(" and locate(@0,s_sku)", objCon.search);
                        else if (objCon.searchType == 2)
                            cdnSql.Append(" and locate(@0,s_product)", objCon.search);
                        else if (objCon.searchType == 3)
                            cdnSql.Append(" and locate(@0,s_ctitle)", objCon.search);
                        else if (objCon.searchType == 4)
                            cdnSql.Append(" and locate(@0,s_goods_code)", objCon.search);
                        else if (objCon.searchType == 5)
                            cdnSql.Append(" and locate(@0,s_product_code)", objCon.search);
                        else if (objCon.searchType == 6)
                            cdnSql.Append(" and s_id in (select sp_sid from yt_product_supplier where locate(@0,sp_deliver_name))", objCon.search);
                        else if (objCon.searchType == 601)
                            cdnSql.Append(" and s_id in (select is_sid from dv_import_sku where locate(@0,is_custom_product))", objCon.search);
                    }
                    else if (objCon.type == 2)
                    {
                        if (objCon.searchType == 1)
                            cdnSql.Append(" and s_sku like @0", $"{objCon.search}%");
                        else if (objCon.searchType == 2)
                            cdnSql.Append(" and s_product like @0", $"{objCon.search}%");
                        else if (objCon.searchType == 3)
                            cdnSql.Append(" and s_ctitle like @0", $"{objCon.search}%");
                        else if (objCon.searchType == 4)
                            cdnSql.Append(" and s_goods_code like @0", $"{objCon.search}%");
                        else if (objCon.searchType == 5)
                            cdnSql.Append(" and s_product_code like @0", $"{objCon.search}%");
                        else if (objCon.searchType == 6)
                            cdnSql.Append(" and s_id in (select sp_sid from yt_product_supplier where sp_deliver_name like @0)", $"{objCon.search}%");
                        else if (objCon.searchType == 601)
                            cdnSql.Append(" and s_id in (select is_sid from dv_import_sku where is_custom_product like @0)", $"{objCon.search}%");
                    }
                    else
                    {
                        string[] searchs = objCon.search.Split(',');
                        if (objCon.searchType == 1)
                            cdnSql.Append(" and s_sku in (@search)", new { search = searchs });
                        else if (objCon.searchType == 2)
                            cdnSql.Append(" and s_product in (@search)", new { search = searchs });
                        else if (objCon.searchType == 3)
                            cdnSql.Append(" and s_ctitle in (@search)", new { search = searchs });
                        else if (objCon.searchType == 4)
                            cdnSql.Append(" and s_goods_code in (@search)", new { search = searchs });
                        else if (objCon.searchType == 5)
                            cdnSql.Append(" and s_product_code in (@search)", new { search = searchs });
                        else if (objCon.searchType == 6)
                            cdnSql.Append(" and s_id in (select sp_sid from yt_product_supplier where sp_deliver_name in (@search))", new { search = searchs });
                        else if (objCon.searchType == 601)
                            cdnSql.Append(" and s_id in (select is_sid from dv_import_sku where is_custom_product in (@search))", new { search = searchs });
                    }
                }
                if (objCon.cateId > 0)
                {
                    if(objCon.cateType == 1)
                    {
                        cdnSql.Append(" and s_category_bailun_id = @0", objCon.cateId);
                    }
                    else
                    {
                        var cateIds = "";
                        var cateList = yt_category_bailun.GetCategoriesAllChildList(objCon.cateId);
                        foreach (var objCate in cateList)
                        {
                            cateIds += objCate.c_id + ",";
                        }
                        cateIds = cateIds.TrimEnd(',');
                        var cateArr = cateIds.Split(',');
                        cdnSql.Append(" and s_category_bailun_id in (@cateId)", new { cateId = cateArr });
                    }
                }

                if (!string.IsNullOrWhiteSpace(objCon.series))
                    cdnSql.Append(" and s_series = @0", objCon.series);

                if (objCon.isFinish != -1)
                {
                    if (objCon.isFinish > 0)
                        cdnSql.Append(" and s_isfinish = @0", objCon.isFinish);
                    else
                        cdnSql.Append(" and s_isfinish = @0", 1);
                }

                if (objCon.beginCT > dtDefault)
                {
                    cdnSql.Append(" and s_createtime >= @0", objCon.beginCT);
                }
                if (objCon.endCT > dtDefault)
                {
                    cdnSql.Append(" and s_createtime <= @0", objCon.endCT);
                }
                //日志修改日期
                if (!string.IsNullOrWhiteSpace(objCon.updateDate))
                {
                    var updateArr = objCon.updateDate.Split(',');
                    cdnSql.Append(" and s_sku in (select sku from (select ProductCode as sku from yt_product_log where updatedate in (@updateDate) and LogType = 2 group by ProductCode ", new { updateDate = updateArr });
                    cdnSql.Append(" union select st_sku as sku from yt_product_state where st_createtime in (@updateDate) and st_isupapi = 1) as a)", new { updateDate = updateArr });
                }
            }
            else if (objCon.buyerId > 0 || objCon.sellerId > 0 || !string.IsNullOrWhiteSpace(objCon.state) || !string.IsNullOrWhiteSpace(objCon.source))
            {
                hostSql = " select b.s_id from (select ex_sid s_id from yt_product_exploit where 1=1";
                cdnSql.Append(hostSql);
                if (objCon.buyerId > 0)
                {
                    cdnSql.Append(" and ex_buyer = @0", objCon.buyerId);
                }

                if (objCon.sellerId > 0)
                {
                    cdnSql.Append(" and ex_bussiness_id = @0", objCon.sellerId);
                }

                if (!string.IsNullOrWhiteSpace(objCon.state))
                {
                    cdnSql.Append(" and (ex_procestatus = 911 or a.ex_procestatus = @0)", objCon.state);
                }

                if (!string.IsNullOrWhiteSpace(objCon.source))
                {
                    cdnSql.Append(" and ex_source = @0", objCon.source);
                }
            }
            else
            {
                hostSql = " select b.s_id from (select st_sid s_id from yt_product_state where 1=1";
                cdnSql.Append(hostSql);
                if (objCon.status > 0)
                {
                    cdnSql.Append(" and st_status = @0", objCon.status);
                }
                if (objCon.IsUpApi == null)
                {
                    cdnSql.Append(" and st_isupapi = 1");
                }
                else if (objCon.IsUpApi != "")
                {
                    cdnSql.Append(" and st_isupapi = @0", objCon.IsUpApi);
                }
                if (!string.IsNullOrWhiteSpace(objCon.lastUpdateState))
                {
                    cdnSql.Append(" and st_lastupdate_state = @0", objCon.lastUpdateState);
                }

                if (!string.IsNullOrWhiteSpace(objCon.reason))
                {
                    cdnSql.Append(" and locate(@0,st_reason)", objCon.reason);
                }
            }

            cdnSql.Append(" ) as b");

            cdnSql.Append(" left join yt_product_base as h on b.s_id = h.s_id");
            if (!string.IsNullOrWhiteSpace(objCon.state) || objCon.sellerId > 0 || objCon.buyerId > 0 || !string.IsNullOrWhiteSpace(objCon.source) || !string.IsNullOrWhiteSpace(objCon.reason))
            {
                cdnSql.Append(" left join yt_product_exploit as a on b.s_id = a.ex_sid");
            }
            if (objCon.status > 0 || objCon.IsUpApi == null || objCon.IsUpApi != "" || !string.IsNullOrWhiteSpace(objCon.lastUpdateState))
            {
                cdnSql.Append(" left join yt_product_state as c on b.s_id = c.st_sid");
            }
            if (objCon.searchType == 6 || objCon.deliverId > 0)
            {
                cdnSql.Append(" left join yt_product_supplier_relate as d on b.s_id = d.sp_sku_id and sp_default = 1");
                cdnSql.Append(" left join yt_product_supplier as e on d.sp_id = e.sp_relation_id");
            }
            if (!string.IsNullOrWhiteSpace(objCon.brand))
                cdnSql.Append(" left join dv_product_mian_deve as f on f.pd_mian_id = h.s_main_id");

            cdnSql.Append(" where s_operatetype != 'Delete'");

            if (objCon.isFinish != -1)
            {
                if (objCon.isFinish > 0)
                    cdnSql.Append(" and s_isfinish = @0", objCon.isFinish);
                else
                    cdnSql.Append(" and s_isfinish = @0", 1);
            }

            #region 开发信息表
            if (!string.IsNullOrWhiteSpace(objCon.state))
            {
                cdnSql.Append(" and (ex_procestatus = 911 or a.ex_procestatus = @0)", objCon.state);
            }

            if (objCon.sellerId > 0)
            {
                cdnSql.Append(" and ex_bussiness_id = @0", objCon.sellerId);
            }

            if (objCon.buyerId > 0)
            {
                cdnSql.Append(" and ex_buyer = @0", objCon.buyerId);
            }

            if (!string.IsNullOrWhiteSpace(objCon.source))
            {
                cdnSql.Append(" and ex_source = @0", objCon.source);
            }
            #endregion

            #region 状态表
            if (objCon.status > 0)
            {
                cdnSql.Append(" and st_status = @0", objCon.status);
            }

            if (objCon.IsUpApi == null)
            {
                cdnSql.Append(" and st_isupapi = 1");
            }
            else if (objCon.IsUpApi != "")
            {
                cdnSql.Append(" and st_isupapi = @0", objCon.IsUpApi);
            }

            if (!string.IsNullOrWhiteSpace(objCon.lastUpdateState))
            {
                cdnSql.Append(" and st_lastupdate_state = @0", objCon.lastUpdateState);
            }

            if (!string.IsNullOrWhiteSpace(objCon.reason))
            {
                cdnSql.Append(" and locate(@0,st_reason)", objCon.reason);
            }
            #endregion
            #region 供应商表
            if (objCon.deliverId > 0)
            {
                cdnSql.Append(" and sp_deliver_id = @0", objCon.deliverId);
            }
            #endregion
            #region 商品主表
            if (!string.IsNullOrWhiteSpace(objCon.brand))
            {
                cdnSql.Append(" and pd_brand like @0", $"{objCon.brand}%");
            }
            #endregion

            #endregion
            return cdnSql;
        }

        /// <summary>
        /// 返回实体列表查询
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static string QueryEntityCommon(Sql sql, ConditionInterface objCon)
        {
            var resultList = repo.Fetch<ResultAllProductInfo>(sql).ToList();
            if (objCon.isResultSup == 1)
            {
                foreach (var item in resultList)
                {
                    var supList = GetSkuForSupplier(item);
                    item.spList.AddRange(supList);
                }
            }
            if(objCon.isResultWare == 1)
            {
                var skuIds = "";
                foreach (var item in resultList)
                {
                    skuIds += item.id + ",";
                }
                skuIds = skuIds.TrimEnd(',');
                var wareList = GetSkuForWare(skuIds);
                foreach (var item in resultList)
                {
                    var tempList = wareList.Where(m => m.sId == item.id).ToList();
                    if (tempList.Count > 0)
                        item.wareList = tempList;
                }
            }
            var strJson = CommonBaseLib.EncodeAndJson(resultList);
            return strJson;
        }

        /// <summary>
        /// 列表按分页查询
        /// </summary>
        /// <param name="SearchType"></param>
        /// <param name="Search"></param>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        public static string QueryPageCommon(Sql sql, Sql cdnSql, ConditionInterface objCon)
        {
            var page = objCon.page;
            var pageSize = objCon.pageSize;
            //限制分页数最大1000
            if (objCon.pageSize > 1000)
                objCon.pageSize = 1000;

            var pageData = new Page<ResultAllProductInfo>();
            var cdnData = repo.Page<int>(page, pageSize, cdnSql);
            var dataList = repo.Fetch<ResultAllProductInfo>(sql);
            pageData.Items = dataList;
            pageData.ItemsPerPage = cdnData.ItemsPerPage;
            pageData.CurrentPage = cdnData.CurrentPage;
            pageData.TotalItems = cdnData.TotalItems;
            pageData.TotalPages = cdnData.TotalPages;
            if (objCon.isResultSup == 1)
            {
                foreach (var item in pageData.Items)
                {
                    var supList = GetSkuForSupplier(item);
                    item.spList.AddRange(supList);
                }
            }
            if (objCon.isResultWare == 1)
            {
                var skuIds = "";
                foreach (var item in pageData.Items)
                {
                    skuIds += item.id + ",";
                }
                skuIds = skuIds.TrimEnd(',');
                var wareList = GetSkuForWare(skuIds);
                foreach (var item in pageData.Items)
                {
                    var tempList = wareList.Where(m => m.sId == item.id).ToList();
                    if (tempList.Count > 0)
                        item.wareList = tempList;
                }
            }
            var strJson = CommonBaseLib.EncodeAndJson(pageData);
            return strJson;
        }

        /// <summary>
        /// 获取SKU对应的所有供应商
        /// </summary>
        /// <returns></returns>
        private static List<GetSupplierInfo> GetSkuForSupplier(ResultAllProductInfo model)
        {
            Sql sqlSup = Sql.Builder;
            sqlSup.Append(" select b.sp_id id,b.sp_relation_id relationId,b.sp_main_id mainId,b.sp_sid sId,b.sp_sku sku,b.sp_enquiry_id enquiryId,");
            sqlSup.Append(" b.sp_enquiry_name enquiryName,b.sp_deliver_id deliverId,b.sp_deliver_name deliverName,");
            sqlSup.Append(" b.sp_link link,b.sp_price price,b.sp_delivery delivery,sp_allot_delivery allotDelivery,b.sp_moq moq,b.sp_internal_moq internalMoq,a.sp_default isDefault,b.sp_have_stall haveStall,");
            sqlSup.Append(" b.sp_take_address takeAddress,b.sp_istake_goods istakeGoods,b.sp_remark remark from yt_product_supplier_relate as a left join yt_product_supplier as b on a.sp_id = b.sp_relation_id");
            sqlSup.Append(" where a.sp_sku_id = @0", model.id);
            var supList = repo.Fetch<GetSupplierInfo>(sqlSup).Where(m => m.deliverId > 0).ToList();
            return supList;
        }

        /// <summary>
        /// 获取sku对应仓库信息
        /// </summary>
        /// <param name="skuIds"></param>
        /// <returns></returns>
        public static List<GetWareAreaInfo> GetSkuForWare(string skuIds)
        {
            Sql sqlWare = Sql.Builder;
            string[] skuIdArr = skuIds.Split(',');
            sqlWare.Append(" select pw_id id,pw_sid sId,pw_sku sku,pw_area_id areaId,pw_ware_code wareCode,pw_isdefault isDefault from yt_product_ware where pw_sid in (@skuId)", new { skuId = skuIdArr });
            var wareList = repo.Fetch<GetWareAreaInfo>(sqlWare).ToList();
            return wareList;
        }

        #region 产品库数据导出模块
        /// <summary>
        /// 按条件筛选导出入口
        /// </summary>
        public static string ExportProductEntrance(ConditionInterface objCon, List<WareInfo> wareList, int isResultAll = 0)
        {
            /*DataTable dt = new DataTable();
            dt.Columns.Add("已上传环球");
            dt.Columns.Add("sku类型");
            dt.Columns.Add("采购仓库");
            dt.Columns.Add("内部商品编码");
            dt.Columns.Add("内部产品编码");
            dt.Columns.Add("商品编码");
            dt.Columns.Add("产品编码");
            dt.Columns.Add("中文名称");
            dt.Columns.Add("英文名称");
            dt.Columns.Add("分类编号");
            dt.Columns.Add("分类名称");
            dt.Columns.Add("颜色");
            dt.Columns.Add("规格1");
            dt.Columns.Add("规格2");
            dt.Columns.Add("规格3");
            dt.Columns.Add("充电器规格");
            dt.Columns.Add("商品状态");
            dt.Columns.Add("同步状态");
            dt.Columns.Add("同步失败原因");
            dt.Columns.Add("虚拟供应商");
            dt.Columns.Add("供应商");
            dt.Columns.Add("业务开发员");
            dt.Columns.Add("采购员");
            dt.Columns.Add("询价员");
            dt.Columns.Add("质检工时");
            dt.Columns.Add("采购价(CNY)");
            dt.Columns.Add("币种");
            dt.Columns.Add("产品重量(克)");
            dt.Columns.Add("产品尺寸");
            dt.Columns.Add("包装尺寸");
            dt.Columns.Add("包装重量(克)");
            dt.Columns.Add("包装价格");
            dt.Columns.Add("包装名称");
            dt.Columns.Add("中文申报名");
            dt.Columns.Add("英文申报名");
            dt.Columns.Add("中文配货名");
            dt.Columns.Add("英文配货名");
            dt.Columns.Add("海关编码");
            dt.Columns.Add("产品性质");
            dt.Columns.Add("交期");
            dt.Columns.Add("最小订单量");
            dt.Columns.Add("内部最小订单量");
            dt.Columns.Add("贴标要求");
            dt.Columns.Add("单位");
            dt.Columns.Add("供应商链接");
            dt.Columns.Add("质检要求");
            dt.Columns.Add("备注");
            dt.Columns.Add("开发站点");
            dt.Columns.Add("销售价格");
            dt.Columns.Add("创建人");
            dt.Columns.Add("创建时间");
            dt.Columns.Add("更新人");
            dt.Columns.Add("更新时间");*/

            string virtualPath = "";
            if (isResultAll == 1)
                virtualPath = $"/ExprotFile/ExprotProduct/离线导出产品库数据.csv";
            else
                virtualPath = $"/ExprotFile/ExprotProduct/导出产品库数据.csv";
            string fullFileName = System.Web.Hosting.HostingEnvironment.MapPath("~" + virtualPath);
            //创建文件夹，保存文件
            //string path = Path.GetDirectoryName(fullFileName);
            //if (path != null) Directory.CreateDirectory(path);
            //ExcelUtil.SaveCSV(dt, fullFileName);

            bool haveData = true;
            int page = 1;
            int rowNum = 1;  //从第二列开始写入数据
            Workbook workbook = new Workbook();
            workbook.Version = ExcelVersion.Version2013;
            Worksheet sheet = workbook.Worksheets[0];
            workbook.SaveToFile(fullFileName);  //先生成文件，标识已经在导出中
            #region 设置表头名称
            int index = 1;
            sheet.SetCellValue(rowNum, index++, "已上传环球");
            sheet.SetCellValue(rowNum, index++, "sku类型");
            sheet.SetCellValue(rowNum, index++, "采购仓库");
            sheet.SetCellValue(rowNum, index++, "内部商品编码");
            sheet.SetCellValue(rowNum, index++, "内部产品编码");
            sheet.SetCellValue(rowNum, index++, "商品编码");
            sheet.SetCellValue(rowNum, index++, "产品编码");
            sheet.SetCellValue(rowNum, index++, "中文名称");
            sheet.SetCellValue(rowNum, index++, "英文名称");
            sheet.SetCellValue(rowNum, index++, "百伦分类");
            sheet.SetCellValue(rowNum, index++, "百伦分类名称");
            sheet.SetCellValue(rowNum, index++, "环球分类");
            sheet.SetCellValue(rowNum, index++, "环球分类名称");
            sheet.SetCellValue(rowNum, index++, "产品系列");
            sheet.SetCellValue(rowNum, index++, "颜色");
            sheet.SetCellValue(rowNum, index++, "规格1");
            sheet.SetCellValue(rowNum, index++, "规格2");
            sheet.SetCellValue(rowNum, index++, "规格3");
            sheet.SetCellValue(rowNum, index++, "充电器规格");
            sheet.SetCellValue(rowNum, index++, "商品状态");
            sheet.SetCellValue(rowNum, index++, "同步状态");
            sheet.SetCellValue(rowNum, index++, "同步失败原因");
            sheet.SetCellValue(rowNum, index++, "供应商");
            sheet.SetCellValue(rowNum, index++, "业务开发员");
            sheet.SetCellValue(rowNum, index++, "采购员");
            sheet.SetCellValue(rowNum, index++, "询价员");
            sheet.SetCellValue(rowNum, index++, "质检工时");
            sheet.SetCellValue(rowNum, index++, "采购价(CNY)");
            sheet.SetCellValue(rowNum, index++, "币种");
            sheet.SetCellValue(rowNum, index++, "产品重量(克)");
            sheet.SetCellValue(rowNum, index++, "产品尺寸");
            sheet.SetCellValue(rowNum, index++, "包装尺寸");
            sheet.SetCellValue(rowNum, index++, "包装重量(克)");
            sheet.SetCellValue(rowNum, index++, "包装价格");
            sheet.SetCellValue(rowNum, index++, "包装名称");
            sheet.SetCellValue(rowNum, index++, "中文申报名");
            sheet.SetCellValue(rowNum, index++, "英文申报名");
            sheet.SetCellValue(rowNum, index++, "中文配货名");
            sheet.SetCellValue(rowNum, index++, "英文配货名");
            sheet.SetCellValue(rowNum, index++, "海关编码");
            sheet.SetCellValue(rowNum, index++, "产品性质");
            sheet.SetCellValue(rowNum, index++, "交期");
            sheet.SetCellValue(rowNum, index++, "最小订单量");
            sheet.SetCellValue(rowNum, index++, "内部最小订单量");
            sheet.SetCellValue(rowNum, index++, "贴标要求");
            sheet.SetCellValue(rowNum, index++, "单位");
            sheet.SetCellValue(rowNum, index++, "供应商链接");
            sheet.SetCellValue(rowNum, index++, "质检要求");
            sheet.SetCellValue(rowNum, index++, "备注");
            sheet.SetCellValue(rowNum, index++, "开发站点");
            sheet.SetCellValue(rowNum, index++, "销售价格");
            sheet.SetCellValue(rowNum, index++, "创建人");
            sheet.SetCellValue(rowNum, index++, "创建时间");
            sheet.SetCellValue(rowNum, index++, "更新人");
            sheet.SetCellValue(rowNum, index++, "更新时间");
            rowNum++;
            #endregion
            while (haveData)
            {
                try
                {
                    objCon.page = page;
                    objCon.pageSize = 5000;
                    var sql = GetSearchSqlStr(objCon);
                    var dataList = repo.Fetch<ResultAllProductInfo>(sql);
                    if (dataList.Count > 0)
                    {
                        foreach (var item in dataList)
                        {
                            try
                            {
                                index = 1;
                                var objWare = wareList.FirstOrDefault(m => m.code == item.wareCode);
                                sheet.SetCellValue(rowNum, index++, item.isUpApi == 1 ? "是" : "否");
                                sheet.SetCellValue(rowNum, index++, Enum.GetName(typeof(EIsFinish), item.isFinish));
                                sheet.SetCellValue(rowNum, index++, objWare != null ? objWare.name : "");
                                sheet.SetCellValue(rowNum, index++, item.goodsCode);
                                sheet.SetCellValue(rowNum, index++, item.productCode);
                                sheet.SetCellValue(rowNum, index++, item.product);
                                sheet.SetCellValue(rowNum, index++, item.sku.ToUpper());
                                sheet.SetCellValue(rowNum, index++, item.cTitle);
                                sheet.SetCellValue(rowNum, index++, item.eTitle);
                                sheet.SetCellValue(rowNum, index++, item.cateBailunId.ToString());
                                sheet.SetCellValue(rowNum, index++, item.cateBailunName);
                                sheet.SetCellValue(rowNum, index++, item.categoryId.ToString());
                                sheet.SetCellValue(rowNum, index++, item.categoryName);
                                sheet.SetCellValue(rowNum, index++, item.series);
                                sheet.SetCellValue(rowNum, index++, item.color);
                                sheet.SetCellValue(rowNum, index++, item.size);
                                sheet.SetCellValue(rowNum, index++, item.size1);
                                sheet.SetCellValue(rowNum, index++, item.size2);
                                sheet.SetCellValue(rowNum, index++, Enum.GetName(typeof(EChargerSpec), item.chargerSpec));
                                sheet.SetCellValue(rowNum, index++, Enum.GetName(typeof(EStatus), item.status));
                                sheet.SetCellValue(rowNum, index++, item.lastUpdateState == 0 ? "未同步" : item.lastUpdateState == 1 ? "已同步" : "同步失败");
                                sheet.SetCellValue(rowNum, index++, item.reason);
                                sheet.SetCellValue(rowNum, index++, item.deliverName);
                                sheet.SetCellValue(rowNum, index++, item.bussinessName);
                                sheet.SetCellValue(rowNum, index++, item.buyerName);
                                sheet.SetCellValue(rowNum, index++, item.enquiryName);
                                sheet.SetCellValue(rowNum, index++, item.testHour.ToString());
                                sheet.SetCellValue(rowNum, index++, item.price.ToString());
                                sheet.SetCellValue(rowNum, index++, item.currency);
                                sheet.SetCellValue(rowNum, index++, item.weight.ToString());
                                sheet.SetCellValue(rowNum, index++, item.productSize.Replace(",", "*"));
                                sheet.SetCellValue(rowNum, index++, item.packingSize.Replace(",", "*"));
                                sheet.SetCellValue(rowNum, index++, item.packingWeight);
                                sheet.SetCellValue(rowNum, index++, item.packingPrice.ToString());
                                sheet.SetCellValue(rowNum, index++, item.packingName);
                                sheet.SetCellValue(rowNum, index++, item.cBaoGuan);
                                sheet.SetCellValue(rowNum, index++, item.eBaoGuan);
                                sheet.SetCellValue(rowNum, index++, item.cPeiHuo);
                                sheet.SetCellValue(rowNum, index++, item.ePeiHuo);
                                sheet.SetCellValue(rowNum, index++, item.hsCode);
                                sheet.SetCellValue(rowNum, index++, item.productCharacter);
                                sheet.SetCellValue(rowNum, index++, item.delivery.ToString());
                                sheet.SetCellValue(rowNum, index++, item.moq.ToString());
                                sheet.SetCellValue(rowNum, index++, item.internalMoq.ToString());
                                sheet.SetCellValue(rowNum, index++, item.labelReq);
                                sheet.SetCellValue(rowNum, index++, item.unit);
                                sheet.SetCellValue(rowNum, index++, item.link);
                                sheet.SetCellValue(rowNum, index++, item.zhijianReq);
                                sheet.SetCellValue(rowNum, index++, HttpUtility.HtmlEncode(item.remark));
                                sheet.SetCellValue(rowNum, index++, item.exploitSite);
                                sheet.SetCellValue(rowNum, index++, item.salesPrice.ToString());
                                sheet.SetCellValue(rowNum, index++, item.createName);
                                sheet.SetCellValue(rowNum, index++, item.createTime.ToString());
                                sheet.SetCellValue(rowNum, index++, item.updateName);
                                sheet.SetCellValue(rowNum, index++, item.updateTime.ToString());
                                rowNum++;
                            }
                            catch (Exception ex)
                            {

                            }
                        }
                        page++;
                    }
                    else
                        haveData = false;
                }
                catch
                {

                }
            }
            workbook.SaveToFile(fullFileName);
            sheet.Dispose();
            workbook.Dispose();
            if(isResultAll == 1)
            {
                string completePath = $"~/ExprotFile/ExprotProduct/离线导出产品库数据(完成).csv";
                string destFilePath = System.Web.Hosting.HostingEnvironment.MapPath(completePath);
                FileInfo file = new FileInfo(fullFileName);
                if (File.Exists(destFilePath))
                {
                    FileInfo destFile = new FileInfo(destFilePath);
                    destFile.Delete();
                }
                file.MoveTo(destFilePath);
                return destFilePath;
            }

            return fullFileName;
        }

        public static string SelectExportProductEntrance(ConditionInterface objCon, List<WareInfo> wareList, int isResultAll = 0)
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("已上传环球");
            dt.Columns.Add("sku类型");
            dt.Columns.Add("采购仓库");
            dt.Columns.Add("内部商品编码");
            dt.Columns.Add("内部产品编码");
            dt.Columns.Add("商品编码");
            dt.Columns.Add("产品编码");
            dt.Columns.Add("中文名称");
            dt.Columns.Add("英文名称");
            dt.Columns.Add("百伦分类");
            dt.Columns.Add("百伦分类名称");
            dt.Columns.Add("环球分类");
            dt.Columns.Add("环球分类名称");
            dt.Columns.Add("产品系列");
            dt.Columns.Add("颜色");
            dt.Columns.Add("规格1");
            dt.Columns.Add("规格2");
            dt.Columns.Add("规格3");
            dt.Columns.Add("充电器规格");
            dt.Columns.Add("商品状态");
            dt.Columns.Add("同步状态");
            dt.Columns.Add("同步失败原因");
            //dt.Columns.Add("虚拟供应商");
            dt.Columns.Add("供应商");
            dt.Columns.Add("业务开发员");
            dt.Columns.Add("采购员");
            dt.Columns.Add("询价员");
            dt.Columns.Add("质检工时");
            dt.Columns.Add("采购价(CNY)");
            dt.Columns.Add("币种");
            dt.Columns.Add("产品重量(克)");
            dt.Columns.Add("产品尺寸");
            dt.Columns.Add("包装尺寸");
            dt.Columns.Add("包装重量(克)");
            dt.Columns.Add("包装价格");
            dt.Columns.Add("包装名称");
            dt.Columns.Add("中文申报名");
            dt.Columns.Add("英文申报名");
            dt.Columns.Add("中文配货名");
            dt.Columns.Add("英文配货名");
            dt.Columns.Add("海关编码");
            dt.Columns.Add("产品性质");
            dt.Columns.Add("交期");
            dt.Columns.Add("最小订单量");
            dt.Columns.Add("内部最小订单量");
            dt.Columns.Add("贴标要求");
            dt.Columns.Add("单位");
            dt.Columns.Add("供应商链接");
            dt.Columns.Add("质检要求");
            dt.Columns.Add("备注");
            dt.Columns.Add("开发站点");
            dt.Columns.Add("销售价格");
            dt.Columns.Add("创建人");
            dt.Columns.Add("创建时间");
            dt.Columns.Add("更新人");
            dt.Columns.Add("更新时间");

            string virtualPath = "";
            if (isResultAll == 1)
                virtualPath = $"/ExprotFile/ExprotProduct/离线导出产品库数据.csv";
            else
                virtualPath = $"/ExprotFile/ExprotProduct/导出产品库数据.csv";
            string fullFileName = System.Web.Hosting.HostingEnvironment.MapPath("~" + virtualPath);
            //创建文件夹，保存文件
            string path = Path.GetDirectoryName(fullFileName);
            if (path != null) Directory.CreateDirectory(path);
            ExcelUtil.SaveCSV(dt, fullFileName);

            bool haveData = true;
            int page = 1;
            int rowNum = 1;  //从第二列开始写入数据
                             // Workbook workbook = new Workbook();
                             // workbook.Version = ExcelVersion.Version2013;
                             // Worksheet sheet = workbook.Worksheets[0];
                             //// workbook.SaveToFile(fullFileName);  //先生成文件，标识已经在导出中
            #region 设置表头名称
            // int index = 1;
            // sheet.SetCellValue(rowNum, index++, "已上传环球");
            // sheet.SetCellValue(rowNum, index++, "sku类型");
            // sheet.SetCellValue(rowNum, index++, "采购仓库");
            // sheet.SetCellValue(rowNum, index++, "内部商品编码");
            // sheet.SetCellValue(rowNum, index++, "内部产品编码");
            // sheet.SetCellValue(rowNum, index++, "商品编码");
            // sheet.SetCellValue(rowNum, index++, "产品编码");
            // sheet.SetCellValue(rowNum, index++, "中文名称");
            // sheet.SetCellValue(rowNum, index++, "英文名称");
            // sheet.SetCellValue(rowNum, index++, "百伦分类");
            // sheet.SetCellValue(rowNum, index++, "百伦分类名称");
            // sheet.SetCellValue(rowNum, index++, "环球分类");
            // sheet.SetCellValue(rowNum, index++, "环球分类名称");
            // sheet.SetCellValue(rowNum, index++, "产品系列");
            // sheet.SetCellValue(rowNum, index++, "颜色");
            // sheet.SetCellValue(rowNum, index++, "规格1");
            // sheet.SetCellValue(rowNum, index++, "规格2");
            // sheet.SetCellValue(rowNum, index++, "规格3");
            // sheet.SetCellValue(rowNum, index++, "充电器规格");
            // sheet.SetCellValue(rowNum, index++, "商品状态");
            // sheet.SetCellValue(rowNum, index++, "同步状态");
            // sheet.SetCellValue(rowNum, index++, "同步失败原因");
            // sheet.SetCellValue(rowNum, index++, "供应商");
            // sheet.SetCellValue(rowNum, index++, "业务开发员");
            // sheet.SetCellValue(rowNum, index++, "采购员");
            // sheet.SetCellValue(rowNum, index++, "询价员");
            // sheet.SetCellValue(rowNum, index++, "质检工时");
            // sheet.SetCellValue(rowNum, index++, "采购价(CNY)");
            // sheet.SetCellValue(rowNum, index++, "币种");
            // sheet.SetCellValue(rowNum, index++, "产品重量(克)");
            // sheet.SetCellValue(rowNum, index++, "产品尺寸");
            // sheet.SetCellValue(rowNum, index++, "包装尺寸");
            // sheet.SetCellValue(rowNum, index++, "包装重量(克)");
            // sheet.SetCellValue(rowNum, index++, "包装价格");
            // sheet.SetCellValue(rowNum, index++, "包装名称");
            // sheet.SetCellValue(rowNum, index++, "中文申报名");
            // sheet.SetCellValue(rowNum, index++, "英文申报名");
            // sheet.SetCellValue(rowNum, index++, "中文配货名");
            // sheet.SetCellValue(rowNum, index++, "英文配货名");
            // sheet.SetCellValue(rowNum, index++, "海关编码");
            // sheet.SetCellValue(rowNum, index++, "产品性质");
            // sheet.SetCellValue(rowNum, index++, "交期");
            // sheet.SetCellValue(rowNum, index++, "最小订单量");
            // sheet.SetCellValue(rowNum, index++, "内部最小订单量");
            // sheet.SetCellValue(rowNum, index++, "贴标要求");
            // sheet.SetCellValue(rowNum, index++, "单位");
            // sheet.SetCellValue(rowNum, index++, "供应商链接");
            // sheet.SetCellValue(rowNum, index++, "质检要求");
            // sheet.SetCellValue(rowNum, index++, "备注");
            // sheet.SetCellValue(rowNum, index++, "开发站点");
            // sheet.SetCellValue(rowNum, index++, "销售价格");
            // sheet.SetCellValue(rowNum, index++, "创建人");
            // sheet.SetCellValue(rowNum, index++, "创建时间");
            // sheet.SetCellValue(rowNum, index++, "更新人");
            // sheet.SetCellValue(rowNum, index++, "更新时间");
            // rowNum++;
            #endregion
            while (haveData)
            {
                try
                {
                    objCon.page = page;
                    objCon.pageSize = 5000;
                    var sql = GetSearchSqlStr(objCon);
                    var dataList = repo.Fetch<ResultAllProductInfo>(sql);
                    if (dataList.Count > 0)
                    {
                        foreach (var item in dataList)
                        {
                            try
                            {
                                //index = 1;
                                DataRow row = dt.NewRow();
                                var objWare = wareList.FirstOrDefault(m => m.code == item.wareCode);
                                #region 之前的
                                //sheet.SetCellValue(rowNum, index++, item.isUpApi == 1 ? "是" : "否");
                                //sheet.SetCellValue(rowNum, index++, Enum.GetName(typeof(EIsFinish), item.isFinish));
                                //sheet.SetCellValue(rowNum, index++, objWare != null ? objWare.name : "");
                                //sheet.SetCellValue(rowNum, index++, item.goodsCode);
                                //sheet.SetCellValue(rowNum, index++, item.productCode);
                                //sheet.SetCellValue(rowNum, index++, item.product);
                                //sheet.SetCellValue(rowNum, index++, item.sku.ToUpper());
                                //sheet.SetCellValue(rowNum, index++, item.cTitle);
                                //sheet.SetCellValue(rowNum, index++, item.eTitle);
                                //sheet.SetCellValue(rowNum, index++, item.cateBailunId.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.cateBailunName);
                                //sheet.SetCellValue(rowNum, index++, item.categoryId.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.categoryName);
                                //sheet.SetCellValue(rowNum, index++, item.series);
                                //sheet.SetCellValue(rowNum, index++, item.color);
                                //sheet.SetCellValue(rowNum, index++, item.size);
                                //sheet.SetCellValue(rowNum, index++, item.size1);
                                //sheet.SetCellValue(rowNum, index++, item.size2);
                                //sheet.SetCellValue(rowNum, index++, Enum.GetName(typeof(EChargerSpec), item.chargerSpec));
                                //sheet.SetCellValue(rowNum, index++, Enum.GetName(typeof(EStatus), item.status));
                                //sheet.SetCellValue(rowNum, index++, item.lastUpdateState == 0 ? "未同步" : item.lastUpdateState == 1 ? "已同步" : "同步失败");
                                //sheet.SetCellValue(rowNum, index++, item.reason);
                                //sheet.SetCellValue(rowNum, index++, item.deliverName);
                                //sheet.SetCellValue(rowNum, index++, item.bussinessName);
                                //sheet.SetCellValue(rowNum, index++, item.buyerName);
                                //sheet.SetCellValue(rowNum, index++, item.enquiryName);
                                //sheet.SetCellValue(rowNum, index++, item.testHour.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.price.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.currency);
                                //sheet.SetCellValue(rowNum, index++, item.weight.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.productSize.Replace(",", "*"));
                                //sheet.SetCellValue(rowNum, index++, item.packingSize.Replace(",", "*"));
                                //sheet.SetCellValue(rowNum, index++, item.packingWeight);
                                //sheet.SetCellValue(rowNum, index++, item.packingPrice.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.packingName);
                                //sheet.SetCellValue(rowNum, index++, item.cBaoGuan);
                                //sheet.SetCellValue(rowNum, index++, item.eBaoGuan);
                                //sheet.SetCellValue(rowNum, index++, item.cPeiHuo);
                                //sheet.SetCellValue(rowNum, index++, item.ePeiHuo);
                                //sheet.SetCellValue(rowNum, index++, item.hsCode);
                                //sheet.SetCellValue(rowNum, index++, item.productCharacter);
                                //sheet.SetCellValue(rowNum, index++, item.delivery.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.moq.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.internalMoq.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.labelReq);
                                //sheet.SetCellValue(rowNum, index++, item.unit);
                                //sheet.SetCellValue(rowNum, index++, item.link);
                                //sheet.SetCellValue(rowNum, index++, item.zhijianReq);
                                //sheet.SetCellValue(rowNum, index++, HttpUtility.HtmlEncode(item.remark));
                                //sheet.SetCellValue(rowNum, index++, item.exploitSite);
                                //sheet.SetCellValue(rowNum, index++, item.salesPrice.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.createName);
                                //sheet.SetCellValue(rowNum, index++, item.createTime.ToString());
                                //sheet.SetCellValue(rowNum, index++, item.updateName);
                                //sheet.SetCellValue(rowNum, index++, item.updateTime.ToString());
                                #endregion
                                row["已上传环球"] = (item.isUpApi == 1 ? "是" : "否");
                                row["sku类型"] = (Enum.GetName(typeof(EIsFinish), item.isFinish));
                                row["采购仓库"] = (objWare != null ? objWare.name : "");
                                row["内部商品编码"] = (item.goodsCode);
                                row["内部产品编码"] = (item.productCode);
                                row["商品编码"] = (item.product);
                                row["产品编码"] = (item.sku.ToUpper());
                                row["中文名称"] = (item.cTitle);
                                row["英文名称"] = (item.eTitle);
                                row["百伦分类"] = (item.cateBailunId.ToString());
                                row["百伦分类名称"] = (item.cateBailunName);
                                row["环球分类"] = (item.categoryId.ToString());
                                row["环球分类名称"] = (item.categoryName);
                                row["产品系列"] = (item.series);
                                row["颜色"] = (item.color);
                                row["规格1"] = (item.size);
                                row["规格2"] = (item.size1);
                                row["规格3"] = (item.size2);
                                row["充电器规格"] = (Enum.GetName(typeof(EChargerSpec), item.chargerSpec));
                                row["商品状态"] = (Enum.GetName(typeof(EStatus), item.status));
                                row["同步状态"] = (item.lastUpdateState == 0 ? "未同步" : item.lastUpdateState == 1 ? "已同步" : "同步失败");
                                row["同步失败原因"] = (item.reason);
                                row["供应商"] = (item.deliverName);
                                row["业务开发员"] = (item.bussinessName);
                                row["采购员"] = (item.buyerName);
                                row["询价员"] = (item.enquiryName);
                                row["质检工时"] = (item.testHour.ToString());
                                row["采购价(CNY)"] = (item.price.ToString());
                                row["币种"] = (item.currency);
                                row["产品重量(克)"] = (item.weight.ToString());
                                row["产品尺寸"] = (item.productSize.Replace(",", "*"));
                                row["包装尺寸"] = (item.packingSize.Replace(",", "*"));
                                row["包装重量(克)"] = (item.packingWeight);
                                row["包装价格"] = (item.packingPrice.ToString());
                                row["包装名称"] = (item.packingName);
                                row["中文申报名"] = (item.cBaoGuan);
                                row["英文申报名"] = (item.eBaoGuan);
                                row["中文配货名"] = (item.cPeiHuo);
                                row["英文配货名"] = (item.ePeiHuo);
                                row["海关编码"] = (item.hsCode);
                                row["产品性质"] = (item.productCharacter);
                                row["交期"] = (item.delivery.ToString());
                                row["最小订单量"] = (item.moq.ToString());
                                row["内部最小订单量"] = (item.internalMoq.ToString());
                                row["贴标要求"] = (item.labelReq);
                                row["单位"] = (item.unit);
                                row["供应商链接"] = (item.link);
                                row["质检要求"] = (item.zhijianReq);
                                row["备注"] = (HttpUtility.HtmlEncode(item.remark));
                                row["开发站点"] = (item.exploitSite);
                                row["销售价格"] = (item.salesPrice.ToString());
                                row["创建人"] = (item.createName);
                                row["创建时间"] = (item.createTime.ToString());
                                row["更新人"] = (item.updateName);
                                row["更新时间"] = (item.updateTime.ToString());
                                dt.Rows.Add(row);
                                rowNum++;
                            }
                            catch (Exception ex)
                            {

                            }
                        }
                        ExcelUtil.AppendCSV(dt, fullFileName);
                        dt.Clear();
                        page++;
                    }
                    else
                        haveData = false;
                }
                catch
                {

                }
            }
            //workbook.SaveToFile(fullFileName);
            //sheet.Dispose();
            //workbook.Dispose();
            if (isResultAll == 1)
            {
                string completePath = $"~/ExprotFile/ExprotProduct/离线导出产品库数据(完成).csv";
                string destFilePath = System.Web.Hosting.HostingEnvironment.MapPath(completePath);
                FileInfo file = new FileInfo(fullFileName);
                if (File.Exists(destFilePath))
                {
                    FileInfo destFile = new FileInfo(destFilePath);
                    destFile.Delete();
                }
                file.MoveTo(destFilePath);
                return destFilePath;
            }

            return fullFileName;
        }
        #endregion

        #region 产品库供应商数据导出模块
        /// <summary>
        /// 按条件筛选导出入口
        /// </summary>
        public static string ExportSupplierEntrance(ConditionInterface objCon)
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("产品编码");
            dt.Columns.Add("询价员");
            dt.Columns.Add("供应商");
            dt.Columns.Add("供应商链接");
            dt.Columns.Add("供应商报价");
            dt.Columns.Add("交期");
            dt.Columns.Add("最小订单量");
            dt.Columns.Add("内部moq");
            dt.Columns.Add("是否有档口");
            dt.Columns.Add("提货地点");
            dt.Columns.Add("支持提货");
            dt.Columns.Add("备注信息");
            dt.Columns.Add("默认供应商");

            string virtualPath = $"/ExprotFile/ExprotProduct/导出SKU对应供应商数据.csv";
            string fullFileName = System.Web.Hosting.HostingEnvironment.MapPath("~" + virtualPath);
            //创建文件夹，保存文件
            string path = Path.GetDirectoryName(fullFileName);
            if (path != null) Directory.CreateDirectory(path);
            ExcelUtil.SaveCSV(dt, fullFileName);

            return ExportSupplierCenter(dt, fullFileName, objCon);
        }

        /// <summary>
        /// 导出sku对应供应商数据处理中心
        /// </summary>
        private static string ExportSupplierCenter(DataTable dt, string fullFileName, ConditionInterface objCon, int page = 1, int pageSize = 5000)
        {
            objCon.page = page;
            objCon.pageSize = pageSize;
            var sql = GetSearchSqlStr(objCon);
            var dataList = repo.Fetch<ResultAllProductInfo>(sql);
            if (dataList.Count > 0)
            {
                page++;
                dt = ExportSupplierExecute(dt, dataList);
                ExcelUtil.AppendCSV(dt, fullFileName);
                dt.Clear();
                return ExportSupplierCenter(dt, fullFileName, objCon, page);
            }
            return fullFileName;
        }

        /// <summary>
        /// 导出执行具体方法
        /// </summary>
        private static DataTable ExportSupplierExecute(DataTable dt, List<ResultAllProductInfo> dataList)
        {
            foreach (var item in dataList)
            {
                var supList = GetSkuForSupplier(item);
                foreach (var model in supList)
                {
                    //创建一个DataRow实例  
                    DataRow row = dt.NewRow();
                    row["产品编码"] = model.sku.ToUpper();
                    row["询价员"] = model.enquiryName;
                    row["供应商"] = model.deliverName;
                    row["供应商链接"] = model.link;
                    row["供应商报价"] = model.price;
                    row["交期"] = model.delivery;
                    row["最小订单量"] = model.moq;
                    row["内部moq"] = model.internalMoq;
                    row["是否有档口"] = model.haveStall == 1 ? "是" : "否";
                    row["提货地点"] = model.takeAddress;
                    row["支持提货"] = model.istakeGoods == 1 ? "是" : "否";
                    row["备注信息"] = model.remark;
                    row["默认供应商"] = model.isDefault == 1 ? "是" : "否";

                    //加入到DataTable  
                    dt.Rows.Add(row);
                }
            }
            return dt;
        }
        #endregion
    }

    #region 枚举模块
    /// <summary>
    /// 商品多属性
    /// </summary>
    public enum ESkuType
    {
        单属性 = 0,
        多属性 = 1,
        捆绑商品 = 2,
        组装商品 = 3
    }

    /// <summary>
    /// 是否成品
    /// </summary>
    public enum EIsFinish
    {
        成品 = 1,
        半成品 = 2,
        耗材 = 3,
        固定资产 = 4,
        组合SKU = 5
    }

    /// <summary>
    /// 商品状态
    /// </summary>
    public enum EStatus
    {
        停售 = 1,
        在售 = 2,
        试卖 = 3,
        停产 = 4,
        清仓 = 5,
        重点维护 = 6,
        SMT侵权 = 7,
        开发中 = 8
    }

    /// <summary>
    /// 采购状态
    /// </summary>
    public enum EIsBuy
    {
        采购 = 1,
        不采购 = 2
    }

    /// <summary>
    /// 充电器规格
    /// </summary>
    public enum EChargerSpec
    {
        无 = 1,
        美规 = 2,
        英规 = 3,
        欧规 = 4,
        澳规 = 5,
        德规 = 6,
        中规 = 7
    }
    #endregion
}
