﻿using System;
using System.Linq;
using System.Reflection;

namespace CommonControl
{
    /// <summary>
    /// 版 本 1.0
    /// Copyright (c) 2016-2021 广州百伦供应链科技有限公司
    /// 创建人：张攀
    /// 日 期：2017/2/13 15:28:02
    /// 描 述：
    /// </summary>
    public static class ObjectExtension
    {
        public static object GetPropertyValue(this object obj, string propertyName)
        {
            if (!obj.IsEmpty())
            {
                Type t = obj.GetType(); //获得该类的Type  
                //再用Type.GetProperties获得PropertyInfo[],然后就可以用foreach 遍历了  
                foreach (PropertyInfo pi in t.GetProperties())
                {
                    var name = pi.Name; //获得属性的名字
                    if (name == propertyName)
                    {
                        var value = pi.GetValue(obj, null); //用pi.GetValue获得值  
                        return value;
                    }
                }
            }
            return null;
        }

        public static decimal ToDecimal(this object obj)
        {
            if (!obj.IsEmpty())
            {
                return Convert.ToDecimal(obj);
            }
            return 0;
        }

        public static double ToDouble(this object obj)
        {
            if (!obj.IsEmpty())
            {
                return Convert.ToDouble(obj);
            }
            return 0;
        }

        public static int ToInt(this object obj)
        {
            if (!obj.IsEmpty())
            {
                return Convert.ToInt32(obj);
            }
            return 0;
        }
        public static bool ToBool(this object obj)
        {
            if (!obj.IsEmpty())
            {
                return Convert.ToBoolean(obj);
            }
            return false;
        }
        /// <summary>
        /// 反射常量
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="obj"></param>
        /// <param name="propertyName"></param>
        /// <returns></returns>
        public static object GetStaticValue<T>(string propertyName) where T : new()
        {
            var ds = typeof(T).GetFields(BindingFlags.Static | BindingFlags.Public | BindingFlags.NonPublic);
            return ds.SingleOrDefault(s => s.Name == propertyName).GetValue(null);
        }
    }
}
