﻿using ApiControl;
using CommonControl;
using DbConn;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Threading.Tasks;

namespace API.Services.PmsApiServices
{
    public class ImageUploadServices
    {
        private static readonly string PicServerUrl = ConfigurationManager.AppSettings["QiNiuCdnUrl"];
        public static void ImageDataSyncQinNiu()
        {
            Task.Factory.StartNew(() =>
            {
                var list = yt_product_base.Fetch($" where (s_main_image != '' and s_main_image not like '%http://p6jo4u8x0.bkt.clouddn.com%') or (s_child_image != '' and s_child_image not like '%http://p6jo4u8x0.bkt.clouddn.com%') limit 5000");  //s_main_image != '' or s_child_image != '' limit {index},5000
                if (list.Count > 0)
                {
                    //Thread.Sleep(10000);
                    ImageDataSync(list);
                    ImageDataSyncQinNiu();
                }
            });
            //var list = yt_product_base.Fetch($" where (s_main_image != '' and s_main_image not like '%http://p6jo4u8x0.bkt.clouddn.com%') or (s_child_image != '' and s_child_image not like '%http://p6jo4u8x0.bkt.clouddn.com%') limit 5000");  //s_main_image != '' or s_child_image != '' limit {index},5000
            //if (list.Count > 0)
            //{
            //    //Thread.Sleep(10000);
            //    ImageDataSync(list);
            //    ImageDataSyncQinNiu();
            //}
        }

        public static void ImageDataSync(List<yt_product_base> list)
        {
            foreach(var item in list)
            {
                //var objBase = ImageDataToSync(item);
                //objBase.Update(new string[] { "s_main_image", "s_child_image" });
            }
        }

        /// <summary>
        /// 单个实体同步
        /// </summary>
        public static yt_product_base ImageDataToSync(yt_product_base item, bool isDelete = false)
        {
            var mainImage = "";
            var childImage = "";
            var uploadImage = "";
            var mainArr = !string.IsNullOrWhiteSpace(item.s_main_image) ? item.s_main_image.Split(',') : new string[] { };
            foreach (var mainUrl in mainArr)
            {
                uploadImage = UploadImageToQinNiu(item.s_sku, mainUrl);
                mainImage += uploadImage;
                if (item.s_child_image.Contains(mainUrl))
                {
                    item.s_child_image = item.s_child_image.Replace(mainUrl, uploadImage.TrimEnd(','));
                }
            }
            var childArr = !string.IsNullOrWhiteSpace(item.s_child_image) ? item.s_child_image.Split(',') : new string[] { };
            foreach (var childUrl in childArr)
            {
                childImage += UploadImageToQinNiu(item.s_sku, childUrl);
            }

            //删除图片
            if (isDelete)
            {
                foreach (var mainUrl in mainArr)
                {
                    DeleteServerImage(mainUrl);
                }
                foreach (var childUrl in childArr)
                {
                    DeleteServerImage(childUrl);
                }
            }

            item.s_main_image = mainImage.TrimEnd(',').Replace("%3F", "?");
            item.s_child_image = childImage.TrimEnd(',').Replace("%3F", "?");

            return item;
        }

        /// <summary>
        /// 上传到七牛云功能
        /// </summary>
        public static string UploadImageToQinNiu(string sku, string url)
        {
            if (!string.IsNullOrWhiteSpace(url) && !url.Contains(PicServerUrl))
            {
                var imgUrl = "";
                var fileName = "";
                if (url.Contains("http"))
                {
                    if(url.ToLower().Contains(".jpg") || url.ToLower().Contains(".png") || url.ToLower().Contains(".gif"))
                        imgUrl = url;
                    else
                    {
                        LoggerHelper.Error($"图片为非jpg,png,gif链接:{sku},图片路径为:{url}");
                        return "";
                    }
                }
                else
                {
                    if (url.Contains("/upload/image/"))
                    {
                        imgUrl = "http://bi.bailuntec.com" + url;
                    }
                    else
                    {
                        imgUrl = "http://skums.bailuntec.com" + url;
                    }
                }

                if (imgUrl.Contains("i.ebayimg.com"))
                {
                    imgUrl = imgUrl.Replace('\\','/');
                    var nameArr = imgUrl.Split('/');
                    if (nameArr.Length > 1)
                    {
                        fileName = nameArr[nameArr.Length - 3] + "_" + nameArr[nameArr.Length - 2] + "_" + nameArr[nameArr.Length - 1];
                    }
                    else
                        fileName = Path.GetFileName(url);
                }
                else if (imgUrl.Contains("https://") || imgUrl.Contains("http://"))
                {
                    fileName = Guid.NewGuid().ToString();
                }
                else
                    fileName = Path.GetFileName(url);

                fileName = CommonBaseLib.UrlToDecode(fileName);
                var result = QiNiuCloudHelper.FetchFile(imgUrl, ref fileName);
                if(result.Code == 200)
                {
                    LoggerHelper.Info($"上传成功:{sku},图片名称为:{result.Text}");
                    return fileName + ",";
                }
                else
                {
                    LoggerHelper.Error($"上传失败{result.Code},{result.RefCode}:{sku},图片名称为:{result.Text}");
                }
            }
            return url + ",";
        }

        /// <summary>
        /// 删除服务器图片
        /// </summary>
        private static void DeleteServerImage(string url)
        {
            if (!url.Contains("http") || url.Contains("bailuntec.com"))
            {
                try
                {
                    string fileUrl = System.Web.HttpContext.Current.Server.MapPath(url.Replace('\\', '/').Replace("http://skums.bailuntec.com", ""));
                    FileInfo file = new FileInfo(fileUrl);
                    if (file.Exists && file.CreationTime > Convert.ToDateTime("2018-04-05"))
                    {
                        file.Delete();
                    }
                }
                catch(Exception ex)
                {
                    LoggerHelper.Error("图片路径删除错误：" + ex.Message);
                }
            }
        }
    }
}
