﻿using Petapoco.ShowProduct.Custom;
using PetaPoco;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DbConn
{
    public partial class dv_product_mian_deve : DbConnDB.Record<dv_product_mian_deve>
    {
        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="page">页码</param>
        /// <param name="pageSize">每页显示个数</param>
        /// <returns></returns>
        public static ShowProductIndex QueryIndexPage(int page = 1, int pageSize = 50)
        {
            Sql sql = Sql.Builder;
            Sql sqlCount = Sql.Builder;
            sql.Append("select pd_mian_id as mainId,pd_sku mainSku,pd_chinaname as cName,pd_mainimgurl as imageUrl,pd_brand as brand,pd_price as salePrice,pd_daysales as daySale,pd_monthsales as avgDaySale,minPrice,maxPrice,coin from (");
            sql.Append(" select s_main_id,min(s_price) as minPrice,max(s_price) as maxPrice,s_currency coin from yt_product_base as a");
            sql.Append(" left join yt_product_state as b on a.s_id = b.st_sid");
            sql.Append(" where s_isfinish = 1 and st_status = 2 and s_main_id > 0 and s_operatetype != 'Delete'");
            sql.Append(" group by s_main_id");
            //sql.Append(sqlCount);
            sql.Append($" limit {(page - 1) * pageSize},{pageSize}) as c");
            sql.Append(" join dv_product_mian_deve as d on c.s_main_id = d.pd_mian_id");
            var objShowPro = new ShowProductIndex();
            var dataList = repo.Fetch<ShowProduct>(sql);
            Page<ShowProduct> pageData = new Page<ShowProduct>();
            pageData.Items = dataList;
            pageData.CurrentPage = page;
            pageData.ItemsPerPage = pageSize;
            //pageData.TotalItems = 0;
            //pageData.TotalPages = 0;
            objShowPro.proList = pageData;

            var mainIds = "";
            foreach(var objPro in dataList)
            {
                mainIds += objPro.mainId + ",";
            }
            mainIds = mainIds.TrimEnd(',');
            var mainIdArr = mainIds.Split(',');

            Sql smSql = Sql.Builder;
            smSql.Append(" select s_main_id mainId,s_main_image mainImage from (select s_id,s_main_id,s_color,s_main_image from yt_product_base");
            smSql.Append("  where s_main_id in (@mainIds) and s_main_image != '' and s_main_image is not null GROUP BY s_color) as a", new { mainIds = mainIdArr });
            objShowPro.smallImages = repo.Fetch<smallImages>(smSql).ToList();
            return objShowPro;
        }
    }
}
