﻿using API.Services.PmsApiServices;
using API.Services.SkuMapManageServices;
using API.Services.StockManageServices;
using ApiControl;
using System;

namespace API.Services
{
    public class ApiAddressCenter
    {
        /// <summary>
        /// API地址中转分析中心
        /// </summary>
        /// <param name="sign"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        public static ApiResult ApiAnalysisCenter(DataStr ds)
        {
            ApiResult result = new ApiResult();
            try
            {
                if(ds == null)
                {
                    result = ApiDataManage.CreateApiResult(400);
                    result.result_msg += $"参数DataStr数据为空，请检查";
                    return result;
                }
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    result = GetApiKey(pare.data, ds);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch(Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg += ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 获取系统编码接口
        /// </summary>
        /// <param name="apiCode"></param>
        /// <returns></returns>
        public static ApiResult GetApiKey(ApiEntrance api, DataStr ds)
        {
            switch (api.code)
            {
                case "BaiLunSku":
                    return GetSkuApiName(api, ds);  // Sku系统接口中心
                case "BaiLunSkuMap":
                    return GetSkuMapApiName(api, ds);  // Sku系统映射接口中心
                case "BaiLunPds":
                    return GetPdsApiName(api, ds);  // 开发系统相关
                default:
                    return ApiDataManage.CreateApiResult(402);
            }
        }

        /// <summary>
        /// 获取PMS接口名称
        /// </summary>
        /// <param name="api"></param>
        /// <returns></returns>
        private static ApiResult GetSkuApiName(ApiEntrance api, DataStr ds)
        {
            switch (api.key)
            {
                case "get.product.all":
                    return GetDataServices.GetProductInfos(api);  // 获取产品信息
                case "get.product.base":
                    return GetDataServices.GetProductBase(api);  // 获取产品基础信息
                case "get.product.exploit":
                    return GetDataServices.GetProductExploit(api);  // 获取开发基础信息
                case "get.product.supplier":
                    return GetDataServices.GetProductSupplier(api);  // 获取sku供应商基础信息
                case "set.product.base":
                    return SetDataServices.SaveProductInfo(api);  // 修改产品信息
                case "get.skumap.base":
                    return GetDataServices.GetSkuMapInfo(api);  // 获取sku映射信息
                case "get.goods.list":
                    return GetDataServices.GetGoodsListInfo(api);  // 获取商品列表信息
                default:
                    return ApiDataManage.CreateApiResult(404);
            }
        }

        /// <summary>
        /// 获取PMS接口名称
        /// </summary>
        /// <param name="api"></param>
        /// <returns></returns>
        private static ApiResult GetSkuMapApiName(ApiEntrance api, DataStr ds)
        {
            switch (api.key)
            {
                case "add.skumap.info":
                    return SkuMapServices.AddSkuMapClaimInfo(api);  //生成SKU认领
                default:
                    return ApiDataManage.CreateApiResult(404);
            }
        }

        /// <summary>
        /// 获取PDS接口名称
        /// </summary>
        /// <param name="api"></param>
        /// <returns></returns>
        private static ApiResult GetPdsApiName(ApiEntrance api, DataStr ds)
        {
            switch (api.key)
            {
                case "get.productcode.stock":
                    return StockServices.GetDistributeStockInfo(api);  //生成SKU认领
                default:
                    return ApiDataManage.CreateApiResult(404);
            }
        }
    }
}
