﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Petapoco.Custom.HqygDto
{
    public class ResultProductInfo
    {
        /// <summary>
        /// 返回信息
        /// </summary>
        public bool response { get; set; }
        public int error_code { get; set; }
        public string error_msg { get; set; }

        public string errr_Info
        {
            get
            {
                switch (error_code)
                {
                    case 1:return $"{error_code}验证接口错误";
                    case 2:return $"{error_code}post方法错误";
                    case 3:return $"{error_code}内部系统错误";
                    case 4:return $"{error_code}产品编码错误";
                    case 5:return $"{error_code}商品编码错误";
                    case 6:return $"{error_code}分类不存在或者不是底级分类或者无权限";
                    case 7:return $"{error_code}系统中不存在该币种";
                    case 8:return $"{error_code}充电器规格必须是由系统提供";
                    case 9:return $"{error_code}产品性质为空，或者不存在系统中";
                    case 10:return $"{error_code}产品名称不能为空";
                    case 11:return $"{error_code}产品英文名称不能为空";
                    case 12:return $"{error_code}海关中文名称不能为空";
                    case 13:return $"{error_code}海关英文名称不能为空";
                    case 14:return $"{error_code}海关编码不能为空";
                    case 15:return $"{error_code}产品实际重量不能为空，且需为浮点型，且大于0";
                    case 16:return $"{error_code}包装尺寸长不能为空，且需为浮点型，且大于0";
                    case 17:return $"{error_code}包装尺寸宽不能为空，且需为浮点型，且大于0";
                    case 18:return $"{error_code}包装尺寸高不能为空，且需为浮点型，且大于0";
                    case 19:return $"{error_code}采购价不能为空，且需为浮点型，且大于0";
                    case 20:return $"{error_code}如果填写了产品尺寸，则长宽高都不能小于0";
                    case 21:return $"{error_code}添加新品或者复制同款时，规格组合不能为空，规格组合也不能超过10个";
                    case 22:return $"{error_code}产品编辑时，规组合必须是一个";
                    case 23:return $"{error_code}规格颜色不能为空";
                    case 24:return $"{error_code}规格颜色、尺寸不能包含中文";
                    case 25:return $"{error_code}提交的规格值重复";
                    case 26:return $"{error_code}提交的规格值和同款产品规格重复";
                    case 27:return $"{error_code}请上传一个本地文件";
                    case 28:return $"{error_code}文件格式必须为JPG格式";
                    case 29:return $"{error_code}当前产品不属于百伦事业部，不允许编辑或添加同款";
                    default:
                        return error_msg;

                }
            }
        }

        public List<ResultInfoList> result { get; set; }
    }

    public class ResultInfoList
    {
        /// <summary>
        /// 返回的标识id    
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 产品编码        
        /// </summary>
        public string goods_sn { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_sn { get; set; }

        /// <summary>
        /// 颜色    
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 尺寸    
        /// </summary>
        public string size { get; set; }
    }
}
