﻿using PetaPoco;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Petapoco.ShowProduct.Custom
{
    public class ConditionShowProduct
    {
        /// <summary>
        /// 页数
        /// </summary>
        public int page { get; set; }

        /// <summary>
        /// 分页大小，最大1000
        /// </summary>
        public int pageSize { get; set; }
    }

    /// <summary>
    /// 返回实体
    /// </summary>
    public class ShowProductIndex
    {
        /// <summary>
        /// 商品列表数据
        /// </summary>
        public Page<ShowProduct> proList { get; set; }

        /// <summary>
        /// 子图路径
        /// </summary>
        public List<smallImages> smallImages { get; set; }
    }

    public class ShowProduct
    {
        /// <summary>
        /// 产品主键
        /// </summary>
        public int mainId { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string mainSku { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string cName { get; set; }

        /// <summary>
        /// 最低采购价
        /// </summary>
        public double minPrice { get; set; }

        /// <summary>
        /// 最高采购价
        /// </summary>
        public double maxPrice { get; set; }

        /// <summary>
        /// 币种单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 图片链接
        /// </summary>
        public string imageUrl { get; set; }

        /// <summary>
        /// 产品品牌
        /// </summary>
        public string brand { get; set; }

        /// <summary>
        /// 销售价
        /// </summary>
        public double salePrice { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string coin { get; set; }

        /// <summary>
        /// 近日销量
        /// </summary>
        public double daySale { get; set; }

        /// <summary>
        /// 日均销量
        /// </summary>
        public double avgDaySale { get; set; }
    }

    public class smallImages
    {
        /// <summary>
        /// 商品Id
        /// </summary>
        public string mainId { get; set; }

        /// <summary>
        /// sku主图
        /// </summary>
        public string mainImage { get; set; }
    }

    public class FilterProduct
    {
        /// <summary>
        /// 是否筛选品牌
        /// </summary>
        public bool isBrand { get; set; }

        /// <summary>
        /// 产品品牌列表
        /// </summary>
        public List<BrandList> BrandList { get; set; }

        /// <summary>
        /// 是否筛选采购价
        /// </summary>
        public bool isPrice { get; set; }
    }

    public class BrandList
    {
        /// <summary>
        /// 产品品牌
        /// </summary>
        public string Brand { get; set; }
    }
}
