﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PetaPoco.Custom.ProductData
{
    public class AllProductInfo
    {
        ///<summary>
		///基础主键
		///</summary>
        public int s_id { get; set; }

        ///<summary>
		///商品主键
		///</summary>
        public int s_main_id { get; set; }

        ///<summary>
		///内部商品编码
		///</summary>
        public string s_goods_code { get; set; }

        ///<summary>
		///内部产品编码
		///</summary>
        public string s_product_code { get; set; }

        ///<summary>
		///商品编码
		///</summary>
        public string s_product { get; set; }

        ///<summary>
		///sku编号
		///</summary>
        public string s_sku { get; set; }

        ///<summary>
		///中文标题
		///</summary>
        public string s_ctitle { get; set; }

        ///<summary>
		///英文标题
		///</summary>
        public string s_etitle { get; set; }

        ///<summary>
		///中文别名（不含属性）
		///</summary>
        public string s_ctitle_alias { get; set; }

        /// <summary>
        /// 百伦分类ID
        /// </summary>
        public int s_category_bailun_id { get; set; }

        ///<summary>
        ///Shopify分类ID
        ///</summary>
        public int s_shopify_cateid { get; set; }

        /// <summary>
        /// 简易分类ID
        /// </summary>
        public int s_category_simple { get; set; }

        ///<summary>
		///百伦分类名称
		///</summary>
        public string s_category_bailun_name { get; set; }

        ///<summary>
		///分类ID
		///</summary>
        public int s_category_id { get; set; }

        ///<summary>
		///分类名称
		///</summary>
        public string s_category_name { get; set; }

        /// <summary>
        /// 产品系列
        /// </summary>
        public string s_series { get; set; }

        /// <summary>
        /// 产品类型
        /// </summary>
        public string s_product_type { get; set; } = "0";

        ///<summary>
		///0:单属性商品 1：多属性 2：捆绑商品 3：组装商品
		///</summary>
        public sbyte s_skutype { get; set; }

        ///<summary>
		///是否成品商品，1成品；2半成品，3耗材，4固定资产，5组合SKU
		///</summary>
        public int s_isfinish { get; set; }

        ///<summary>
		///重量
		///</summary>
        public decimal s_weight { get; set; }

        ///<summary>
		///最小计量单位
		///</summary>
        public string s_unit { get; set; }

        ///<summary>
		///采购价
		///</summary>
        public decimal s_price { get; set; }

        ///<summary>
		///币种
		///</summary>
        public string s_currency { get; set; }

        ///<summary>
		///产品主图
		///</summary>
        public string s_main_image { get; set; }
        /// <summary>
        /// 沃尔玛 Upc
        /// </summary>
        public string s_walmrat_upc { get; set; }

        ///<summary>
		///子图集合
		///</summary>
        public string s_child_image { get; set; }

        ///<summary>
		///颜色
		///</summary>
        public string s_color { get; set; }

        ///<summary>
		///规格
		///</summary>
        public string s_size { get; set; }

        ///<summary>
		///规格1
		///</summary>
        public string s_size1 { get; set; }

        ///<summary>
		///规格2
		///</summary>
        public string s_size2 { get; set; }

        ///<summary>
		///产品尺寸
		///</summary>
        public string s_product_size { get; set; }

        ///<summary>
		///包装尺寸
		///</summary>
        public string s_packing_size { get; set; }

        ///<summary>
		///包装名称
		///</summary>
        public string s_packing_name { get; set; }

        ///<summary>
		///包装价格
		///</summary>
        public decimal s_packing_price { get; set; }

        ///<summary>
		///包装重量
		///</summary>
        public decimal s_packing_weight { get; set; }

        ///<summary>
		///包装要求
		///</summary>
        public string s_packing_req { get; set; }

        ///<summary>
		///包装规格，绑定的skuid
		///</summary>
        public int s_packing_skuid { get; set; }

        ///<summary>
		///充电器规格
		///</summary>
        public int s_charger_spec { get; set; }

        ///<summary>
		///产品性质
		///</summary>
        public string s_product_character { get; set; }

        ///<summary>
		///百伦内部性质
		///</summary>
        public string s_bailun_character { get; set; }

        ///<summary>
		///配货中文名
		///</summary>
        public string s_cpeihuo { get; set; }

        ///<summary>
		///配货英文名
		///</summary>
        public string s_epeihuo { get; set; }

        ///<summary>
		///报关中文名
		///</summary>
        public string s_cbaoguan { get; set; }

        ///<summary>
		///报关英文名
		///</summary>
        public string s_ebaoguan { get; set; }

        ///<summary>
		///海关编码
		///</summary>
        public string s_hscode { get; set; }

        ///<summary>
		///产品描述
		///</summary>
        public string s_content { get; set; }

        ///<summary>
		///备注
		///</summary>
        public string s_remarks { get; set; }

        ///<summary>
		///开发时间
		///</summary>
        public DateTime s_developtime { get; set; }

        ///<summary>
		///创建人名称
		///</summary>
        public string s_createname { get; set; }

        ///<summary>
		///创建时间
		///</summary>
        public DateTime s_createtime { get; set; }

        ///<summary>
		///更新人名称
		///</summary>
        public string s_updatename { get; set; }

        ///<summary>
		///更新时间
		///</summary>
        public DateTime s_updatetime { get; set; }

        ///<summary>
		///操作类型
		///</summary>
        public string s_operatetype { get; set; }

        ///<summary>
		///英国海关编码
		///</summary>
		public string s_uk_customs_code { get; set; }

        ///<summary>
        ///发货打包要求
        ///</summary>
        public string s_packaging_requirements { get; set; }

        /// <summary>
        /// 材质
        /// </summary>
        public string s_skumaterialquality { get; set; }
        /// <summary>
        /// 用途
        /// </summary>
        public string s_skupurpose { get; set; }

        ///<summary>
		///开发主键
		///</summary>
        public int ex_id { get; set; }

        ///<summary>
		///商品主键
		///</summary>
        public int ex_main_id { get; set; }

        ///<summary>
		///sku主键
		///</summary>
        public int ex_sid { get; set; }

        ///<summary>
        ///sku编号
        ///</summary>
        public string ex_sku { get; set; }

        ///<summary>
		///审核池ID
		///</summary>
        public int ex_examid { get; set; }

        ///<summary>
		///站点
		///</summary>
        public string ex_shopname { get; set; }

        ///<summary>
		///业务开发员ID
		///</summary>
        public int ex_bussiness_id { get; set; }

        ///<summary>
		///业务开发员名称
		///</summary>
        public string ex_bussiness_name { get; set; }

        ///<summary>
		///采购员编号
		///</summary>
        public int ex_buyer { get; set; }

        ///<summary>
		///采购员名称
		///</summary>
        public string ex_buyer_name { get; set; }

        ///<summary>
		///开发系统供应商ID
		///</summary>
        public int ex_supplier_id { get; set; }

        ///<summary>
		///销售价格
		///</summary>
        public decimal ex_sales_price { get; set; }

        ///<summary>
		///利润
		///</summary>
        public decimal ex_maxlirun { get; set; }

        ///<summary>
		///利润率
		///</summary>
        public decimal ex_maxlirunlv { get; set; }

        /// <summary>
        /// 运费
        /// </summary>
        public decimal ex_shipping_fee { get; set; }

        ///<summary>
		///默认采购仓库
		///</summary>
        public string ex_default_warecode { get; set; }

        ///<summary>
		///贴标要求
		///</summary>
        public string ex_label_req { get; set; }

        /// <summary>
        /// 质检类型
        /// </summary>
        public int ex_zhijian_type { get; set; }

        ///<summary>
		///质检工时
		///</summary>
        public decimal ex_testhour { get; set; }

        ///<summary>
		///质检要求
		///</summary>
        public string ex_zhijian_req { get; set; }

        ///<summary>
		///质检描述
		///</summary>
        public string ex_zhijian_desc { get; set; }

        /// <summary>
        /// 开发来源
        /// </summary>
        public int ex_source { get; set; }

        ///<summary>
		///产品流程状态
		///</summary>
        public int ex_procestatus { get; set; }

        ///<summary>
		///是否启用
		///</summary>
        public int ex_is_hesuan { get; set; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public int ex_enable { get; set; }

        ///<summary>
		///资料员是否完成
		///</summary>
        public int ex_zlyfinish { get; set; }

        ///<summary>
		///更新人名称
		///</summary>
        public string ex_updatename { get; set; }

        ///<summary>
		///更新时间
		///</summary>
        public DateTime ex_updatetime { get; set; }


        public string ex_selfShip_packingReq { get; set; } = "";

        public string ex_transfer_packingReq { get; set; } = "";

        public string ex_fba_packingReq { get; set; } = "";

        ///<summary>
		///状态主键
		///</summary>
        public int st_id { get; set; }

        ///<summary>
		///商品主键
		///</summary>
        public int st_main_id { get; set; }

        ///<summary>
		///sku主键
		///</summary>
        public int st_sid { get; set; }

        ///<summary>
        ///sku编号
        ///</summary>
        public string st_sku { get; set; }

        ///<summary>
		///商品状态，在售停售
		///</summary>
        public int st_status { get; set; }

        ///<summary>
		///采购状态
		///</summary>
        public int st_isbuy { get; set; }

        ///<summary>
		///最低销售价
		///</summary>
        public int st_distribute { get; set; }

        ///<summary>
		///是否已上传环球
		///</summary>
        public sbyte st_isupapi { get; set; }

        ///<summary>
		///是否同步到环球，0未同步，1已同步，-1失败
		///</summary>
        public sbyte st_lastupdate_state { get; set; }

        ///<summary>
		///同步失败原因
		///</summary>
        public string st_reason { get; set; }

        /// <summary>
        /// 同步到旧表状态
        /// </summary>
        public int st_toold { get; set; }

        /// <summary>
        /// 所属公司ID
        /// </summary>
        public int st_company_id { get; set; }

        /// <summary>
        /// 创建时间索引
        /// </summary>
        public string st_createtime { get; set; }

        ///<summary>
		///更新人名称
		///</summary>
        public string st_updatename { get; set; }

        ///<summary>
		///更新时间
		///</summary>
        public DateTime st_updatetime { get; set; }

        public List<SupplierInfo> spList { get; set; }

        /// <summary>
        /// 发货仓库ID
        /// </summary>
        public int pw_id { get; set; }

        /// <summary>
        /// 发货仓库skuid
        /// </summary>
        public int pw_sid { get; set; }

        /// <summary>
        /// 发货仓sku
        /// </summary>
        public string pw_sku { get; set; }

        /// <summary>
        /// 区域Id
        /// </summary>
        public int pw_area_id { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string pw_ware_code { get; set; }

        /// <summary>
        /// 默认仓库
        /// </summary>
        public int pw_isdefault { get; set; }

        ///<summary>
		/// 发货仓创建人
		///</summary>
        public string pw_createuser { get; set; }

        ///<summary>
		///发货仓创建时间
		///</summary>
        public DateTime pw_createtime { get; set; }

        ///<summary>
		///发货仓更新人名称
		///</summary>
        public string pw_updatename { get; set; }

        ///<summary>
		///发货仓更新时间
		///</summary>
        public DateTime pw_updatetime { get; set; }
    }

    public class SupplierInfo
    {
        ///<summary>
		///开发供应商Id
		///</summary>
        public int sp_sp_id { get; set; }

        ///<summary>
		///默认供应商
		///</summary>
        public int sp_default { get; set; }

        ///<summary>
		///供应商主键
		///</summary>
        public int sp_id { get; set; }

        ///<summary>
		///关联表Id
		///</summary>
        public int sp_relation_id { get; set; }

        ///<summary>
		///商品主键
		///</summary>
        public int sp_main_id { get; set; }

        ///<summary>
		///sku主键
		///</summary>
        public int sp_sid { get; set; }

        ///<summary>
        ///sku编号
        ///</summary>
        public string sp_sku { get; set; }

        ///<summary>
		///询价员编号
		///</summary>
        public int sp_enquiry_id { get; set; }

        ///<summary>
		///询价员名称
		///</summary>
        public string sp_enquiry_name { get; set; }

        ///<summary>
		///供应商编号
		///</summary>
        public int sp_deliver_id { get; set; }

        ///<summary>
		///供应商名称
		///</summary>
        public string sp_deliver_name { get; set; }

        ///<summary>
		///虚拟供应商编号
		///</summary>
        public int sp_virdeliver_id { get; set; }

        ///<summary>
		///虚拟供应商名称
		///</summary>
        public string sp_virdeliver_name { get; set; }

        ///<summary>
		///供应商链接
		///</summary>
        public string sp_link { get; set; }

        ///<summary>
		///交期（天）
		///</summary>
        public int sp_delivery { get; set; }

        ///<summary>
		///调拨计划交期（天）
		///</summary>
        public int sp_allot_delivery { get; set; }

        ///<summary>
		///最小订单量
		///</summary>
        public int sp_moq { get; set; }

        ///<summary>
		///内部moq
		///</summary>
        public int sp_internal_moq { get; set; }

        /// <summary>
        /// 是否有档口
        /// </summary>
        public int sp_have_stall { get; set; }

        /// <summary>
        /// 提货地点
        /// </summary>
        public string sp_take_address { get; set; }

        /// <summary>
        /// 是否支持直接提货
        /// </summary>
        public int sp_istake_goods { get; set; }

        ///<summary>
        ///备注
        ///</summary>
        public string sp_remark { get; set; }

        ///<summary>
		///更新人名称
		///</summary>
        public string sp_updatename { get; set; }

        ///<summary>
		///更新时间
		///</summary>
        public DateTime sp_updatetime { get; set; }
    }
}
