﻿using Qiniu.Http;
using Qiniu.Storage;
using Qiniu.Util;
using System.Configuration;
using System.IO;
using System.Text.RegularExpressions;

namespace CommonControl
{
    /// <summary>
    /// 七牛云辅助类
    /// </summary>
    public class QiNiuCloudHelper
    {
        private static readonly string AccessKey = ConfigurationManager.AppSettings["QiNiuAccessKey"];
        private static readonly string SecretKey = ConfigurationManager.AppSettings["QiNiuSecretKey"];
        private static readonly string PicServerUrl = ConfigurationManager.AppSettings["QiNiuCdnUrl"];
        /// <summary>
        /// 七牛存储节点
        /// </summary>
        private static readonly string Bucket = "bailun-publish-img";
        #region 上传文件
        /// <summary>
        /// 上传文件
        /// </summary>
        /// <param name="saveFile">自定义文件名</param>
        /// <param name="content">二进制文件流</param>
        /// <returns></returns>
        public static HttpResult UploadStream(ref string saveFile, byte[] content)
        {
            Mac mac = new Mac(AccessKey, SecretKey);
            saveFile = Regex.Replace(saveFile, @"[^\x00-\xff]", ""); //去除汉字
            saveFile = Path.ChangeExtension(saveFile, ".jpg");
            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket;
            //putPolicy.SetExpires(3600);
            //putPolicy.DeleteAfterDays = 1;
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Config config = new Config();
            // 设置上传区域
            config.Zone = Zone.ZONE_CN_South;
            // 设置 http 或者 https 上传
            //config.UseHttps = true;
            //config.UseCdnDomains = true;
            //config.ChunkSize = ChunkUnit.U512K;
            FormUploader target = new FormUploader(config);
            var result = target.UploadStream(new MemoryStream(content), saveFile, token, null);
            saveFile = PicServerUrl + "/" + saveFile;
            return result;
        }
        #endregion

        #region 查找文件路径
        /// <summary>
        /// 查找文件路径
        /// </summary>
        /// <param name="saveFile"></param>
        /// <returns></returns>
        public static string CreatePublishUrl(string saveFile)
        {
            var url = DownloadManager.CreatePublishUrl(PicServerUrl, saveFile);
            return url;
        }

        #endregion
        /// <summary>
        /// 七牛云拉取文件
        /// </summary>
        /// <param name="url"></param>
        /// <param name="saveFile"></param>
        /// <returns></returns>
        public static FetchResult FetchFile(string url, ref string saveFile)
        {
            // 公网可访问的文件链接
            Mac mac = new Mac(AccessKey, SecretKey);
            saveFile = Regex.Replace(saveFile, @"[^\x00-\xff]", ""); //去除汉字
            saveFile = Path.ChangeExtension(saveFile, ".jpg");
            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket;
            //putPolicy.SetExpires(3600);
            //putPolicy.DeleteAfterDays = 1;
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Config config = new Config();
            // 设置上传区域
            config.Zone = Zone.ZONE_CN_South;
            var buckerManager = new BucketManager(mac, config);
            FetchResult ret = buckerManager.Fetch(url, Bucket, saveFile);
            saveFile = PicServerUrl + "/" + saveFile;
            return ret;
        }
    }
}
