﻿using API.Services.HqygManageServices;
using API.Services.ProductManageServices;
using ApiControl;
using DbConn;
using PetaPoco;
using PetaPoco.Custom.ProductData;
using PetaPoco.Ext.Dto;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using static API.Services.ProductManageServices.ProductServices;

namespace API.Services.PmsApiServices
{
    public class SetDataServices
    {
        #region 旧表数据修改操作
        /// <summary>
        /// 修改产品数据
        /// </summary>
        /// <param name="dataJson"></param>
        /// <returns></returns>
        public static ApiResult SetProductInfo(ApiEntrance api, DataStr ds)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            UpdateTable objUpdate = CommonBaseLib.GetJsonToObject<UpdateTable>(dataJson);
            string msg = oldVerifyTheField(objUpdate);
            if (msg != "")
            {
                result = ApiDataManage.CreateApiResult(600);
                result.result_msg += "：" + msg;
                return result;
            }

            using (var dbContext = DbConnDB.GetInstance())
            {
                using (var tx = dbContext.GetTransaction())
                {
                    try
                    {
                        Sql sql = ProductInfoServices.UpdateWhereData(objUpdate);
                        yt_stock objStock = yt_stock.FirstOrDefault(sql);
                        //创建操作日志
                        CreateOperateLog(ds.appId, api, objUpdate, objStock);
                        objStock = (yt_stock)ProductInfoServices.UpdateDataAssembly(objUpdate, objStock);
                        if (objStock != null)
                        {
                            int count = objStock.Update();
                            result = ApiDataManage.CreateApiResult(1);
                            tx.Complete();
                        }
                        else
                        {
                            result = ApiDataManage.CreateApiResult(504);
                        }
                    }
                    catch (Exception ex)
                    {
                        tx.Dispose();
                        result = ApiDataManage.CreateApiResult(500);
                    }
                }
            }

            return result;
        }

        /// <summary>
        /// 验证可修改的字段
        /// </summary>
        /// <returns></returns>
        private static string oldVerifyTheField(UpdateTable objUpdate)
        {
            string msg = "";
            List<UpdateColumn> list = objUpdate.col;
            if (string.IsNullOrWhiteSpace(objUpdate.user))
                msg += "操作人信息不能为空。";

            if (list.Count > 0)
            {
                foreach (var item in list)
                {
                    msg += oldVerifyTheFieldMsg(item.key);
                }
                if (msg != "")
                    msg += "不允许修改列：" + msg.TrimEnd(',');
            }
            else
            {
                msg += "参数错误，没有需要修改的列";
            }

            return msg;
        }

        /// <summary>
        /// 判断可修改的字段
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        private static string oldVerifyTheFieldMsg(string key)
        {
            switch (key)
            {
                case "S_BUYER":
                    return "";
                case "S_BUYER_NAME":
                    return "";
                default:
                    return key + ",";
            }
        }

        #endregion

        #region 新表数据操作

        /// <summary>
        /// 修改产品数据
        /// </summary>
        /// <param name="dataJson"></param>
        /// <returns></returns>
        public static ApiResult SaveProductInfo(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            List<UpdateTable> updateList = CommonBaseLib.DecodeAndObject<List<UpdateTable>>(dataJson);
            updateList = FilterTheField(updateList);
            List<yt_product_base> packingSkus = yt_product_base.Fetch("SELECT s_id,s_sku,s_ctitle,s_packing_name,s_packing_size,s_packing_price,s_packing_weight FROM yt_product_base WHERE s_isfinish = 3 AND s_operatetype != 'Delete'");
            using (var dbContext = DbConnDB.GetInstance())
            {
                using (var tx = dbContext.GetTransaction())
                {
                    try
                    {
                        foreach (var objUpdate in updateList)
                        {
                            Sql sql = ProductInfoServices.UpdateWhereData(objUpdate);
                            if (objUpdate.table == "dv_product_mian_deve")
                            {
                                var modelList = dv_product_mian_deve.Fetch(sql).ToList();
                                if(modelList.Count > 0)
                                {
                                    foreach(var objOldModel in modelList)
                                    {
                                        dv_product_mian_deve tempModel = CommonBaseLib.GetJsonToObject<dv_product_mian_deve>(CommonBaseLib.GetJsonToString(objOldModel));
                                        var objNewModel = (dv_product_mian_deve)ProductInfoServices.UpdateDataAssembly(objUpdate, objOldModel);
                                        objNewModel.pd_updater = objUpdate.user;
                                        objNewModel.pd_updatedate = DateTime.Now;
                                        int count = objNewModel.Update();
                                        //增加日志
                                        AsyncSaveMainBaseLog(objUpdate, tempModel, objUpdate.user);
                                        result.result_msg = "成功";
                                        result.result_code = 1;
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(600);
                                    result.result_msg = $"{CommonBaseLib.GetJsonToString(objUpdate)}找不到相关数据;";
                                    tx.Dispose();
                                    break;
                                }
                            }
                            else if (objUpdate.table == "yt_product_base")
                            {
                                var modelList = yt_product_base.Fetch(sql).ToList();
                                if(modelList.Count > 0)
                                {
                                    foreach(var objOldModel in modelList)
                                    {
                                        yt_product_base tempModel = CommonBaseLib.GetJsonToObject<yt_product_base>(CommonBaseLib.GetJsonToString(objOldModel));
                                        var objNewModel = (yt_product_base)ProductInfoServices.UpdateDataAssembly(objUpdate, objOldModel);
                                        //百伦分类名称改变时重新获取分类路径
                                        if(objNewModel.s_category_bailun_id > 0)
                                        {
                                            if (tempModel.s_category_bailun_id != objNewModel.s_category_bailun_id || tempModel.s_category_bailun_name != objNewModel.s_category_bailun_name)
                                            {
                                                var myCateList = yt_category_bailun.GetMyParentCategories(objNewModel.s_category_bailun_id);
                                                var objMyCate = myCateList.FirstOrDefault(m => m.c_id == objNewModel.s_category_bailun_id);
                                                tempModel.s_category_bailun_name = yt_category_bailun.GetFullNameByList(myCateList);
                                            }
                                        }

                                        //包装规格SKU，自动更新包装信息
                                        if (!string.IsNullOrEmpty(objNewModel.s_packing_req))
                                        {
                                            var objPack = packingSkus.FirstOrDefault(m => m.s_sku == objNewModel.s_packing_req);
                                            if (objPack != null)
                                            {
                                                objNewModel.s_packing_name = objPack.s_ctitle;
                                                objNewModel.s_packing_price = objPack.s_packing_price;
                                                objNewModel.s_packing_size = objPack.s_packing_size;
                                                objNewModel.s_packing_weight = objPack.s_packing_weight;
                                                objNewModel.s_packing_skuid = objPack.s_id;
                                                objNewModel.s_packing_req = "";
                                            }
                                        }

                                        //采购价变动时默认供应商报价同时更改
                                        if (tempModel.s_price != objNewModel.s_price)
                                        {
                                            ChangePriceSameToSupplier(tempModel.s_id, objNewModel.s_price.Value);
                                        }
                                        //图片路径改变时上传至云
                                        var tempBase = ImageUploadServices.ImageDataToSync(objNewModel, true);
                                        objNewModel.s_main_image = tempBase.s_main_image;
                                        objNewModel.s_child_image = tempBase.s_child_image;

                                        objNewModel.s_updatename = objUpdate.user;
                                        objNewModel.s_updatetime = DateTime.Now;
                                        int count = objNewModel.Update();

                                        //增加日志
                                        AsyncSaveBaseLog(objUpdate, tempModel, objUpdate.user);
                                        // 设置数据需要同步
                                        SetToSameTask(objNewModel.s_id);
                                        //开启自动同步到环球
                                        //PdmDataServices.InsertOrUpdateToSame();
                                        result.result_msg = "成功";
                                        result.result_code = 1;
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(600);
                                    result.result_msg = $"{CommonBaseLib.GetJsonToString(objUpdate)}找不到相关数据;";
                                    tx.Dispose();
                                    break;
                                }
                            }
                            else if (objUpdate.table == "yt_product_exploit")
                            {
                                var modelList = yt_product_exploit.Fetch(sql).ToList();
                                if(modelList.Count > 0)
                                {
                                    foreach(var objOldModel in modelList)
                                    {
                                        yt_product_exploit tempModel = CommonBaseLib.GetJsonToObject<yt_product_exploit>(CommonBaseLib.GetJsonToString(objOldModel));
                                        var objNewModel = (yt_product_exploit)ProductInfoServices.UpdateDataAssembly(objUpdate, objOldModel);
                                        if (tempModel.ex_default_warecode != objNewModel.ex_default_warecode)
                                        {
                                            var wareDataList = WareDataServices.GetDefaultWareList(0, 18); //18为中国区域，采购仓只有中国采购
                                            var objWare = wareDataList.FirstOrDefault(m => m.code == objNewModel.ex_default_warecode);
                                            if (objWare != null)
                                            {
                                                //设置该采购仓库中国区域发货仓
                                                var wareList = new List<yt_product_ware>();
                                                var myWareList = yt_product_ware.Fetch(" where pw_sid = @0 and pw_area_id = 18", tempModel.ex_sid);
                                                var objMyWare = myWareList.FirstOrDefault(m => m.pw_ware_code == objNewModel.ex_default_warecode);
                                                if (objMyWare != null)
                                                {
                                                    objMyWare.pw_isdefault = 1;
                                                    objMyWare.pw_ware_code = objNewModel.ex_default_warecode;
                                                    objMyWare.pw_updatename = objNewModel.ex_updatename;
                                                    wareList.Add(objMyWare);
                                                }
                                                else if (objMyWare == null && !string.IsNullOrWhiteSpace(objNewModel.ex_default_warecode))
                                                {
                                                    objMyWare = new yt_product_ware();
                                                    objMyWare.pw_sid = tempModel.ex_sid;
                                                    objMyWare.pw_sku = tempModel.ex_sku;
                                                    objMyWare.pw_area_id = 18;
                                                    objMyWare.pw_isdefault = 1;
                                                    objMyWare.pw_ware_code = objNewModel.ex_default_warecode;
                                                    objMyWare.pw_updatename = objNewModel.ex_updatename;
                                                    wareList.Add(objMyWare);
                                                }
                                                var oldDefaultWare = myWareList.FirstOrDefault(m => m.pw_ware_code != objNewModel.ex_default_warecode && m.pw_isdefault == 1);
                                                if(oldDefaultWare != null)
                                                {
                                                    oldDefaultWare.pw_isdefault = 0;
                                                    oldDefaultWare.pw_updatename = objNewModel.ex_updatename;
                                                    wareList.Add(oldDefaultWare);
                                                }
                                                if (wareList.Count > 0)
                                                    SaveProductWare(wareList, false);
                                            } 
                                        }
                                        objNewModel.ex_updatename = objUpdate.user;
                                        objNewModel.ex_updatetime = DateTime.Now;
                                        int count = objNewModel.Update();
                                        //增加日志
                                        AsyncSaveExploitLog(objUpdate, tempModel, objUpdate.user);
                                        // 设置数据需要同步
                                        SetToSameTask(objNewModel.ex_sid);
                                        result.result_msg = "成功";
                                        result.result_code = 1;
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(600);
                                    result.result_msg = $"{CommonBaseLib.GetJsonToString(objUpdate)}找不到相关数据;";
                                    tx.Dispose();
                                    break;
                                }
                            }
                            else if (objUpdate.table == "yt_product_supplier")
                            {
                                var modelList = yt_product_supplier.Fetch(sql).ToList();
                                if(modelList.Count > 0)
                                {
                                    foreach(var objOldModel in modelList)
                                    {
                                        var isDefault = 0;
                                        yt_product_supplier tempModel = CommonBaseLib.GetJsonToObject<yt_product_supplier>(CommonBaseLib.GetJsonToString(objOldModel));
                                        var objNewModel = (yt_product_supplier)ProductInfoServices.UpdateDataAssembly(objUpdate, objOldModel);
                                        //如果当前唯一供应商为空，则为默认供应商
                                        var objSupRelate = yt_product_supplier_relate.Func_GetById(tempModel.sp_relation_id);
                                        isDefault = objSupRelate.sp_default;
                                        if (!(tempModel.sp_deliver_id > 0) && objNewModel.sp_deliver_id > 0)
                                        {
                                            objSupRelate.sp_sp_id = objNewModel.sp_deliver_id;
                                            objSupRelate.Update();
                                        }
                                        //默认供应商报价变动时采购价同时更改
                                        if (tempModel.sp_price != objNewModel.sp_price && isDefault == 1)
                                        {
                                            ChangePriceSameToSupplier(tempModel.sp_sid, objNewModel.sp_price, 2);
                                        }
                                        objNewModel.sp_updatename = objUpdate.user;
                                        objNewModel.sp_updatetime = DateTime.Now;
                                        int count = objNewModel.Update();
                                        //增加日志
                                        AsyncSaveSupplierLog(objUpdate, tempModel, objUpdate.user);
                                        var objRelate = yt_product_supplier_relate.FirstOrDefault(" where sp_id = @0", objNewModel.sp_relation_id);
                                        // 设置数据需要同步
                                        SetToSameTask(objRelate.sp_sku_id);
                                        result.result_msg = "成功";
                                        result.result_code = 1;
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(600);
                                    result.result_msg = $"{CommonBaseLib.GetJsonToString(objUpdate)}找不到相关数据;";
                                    tx.Dispose();
                                    break;
                                }
                            }
                            else if (objUpdate.table == "yt_product_supplier_relate")
                            {
                                var modelList = yt_product_supplier_relate.Fetch(sql).ToList();
                                if (modelList.Count > 0)
                                {
                                    foreach (var objOldModel in modelList)
                                    {
                                        yt_product_supplier_relate tempModel = CommonBaseLib.GetJsonToObject<yt_product_supplier_relate>(CommonBaseLib.GetJsonToString(objOldModel));
                                        var objNewModel = (yt_product_supplier_relate)ProductInfoServices.UpdateDataAssembly(objUpdate, objOldModel);
                                        //如果当前为默认供应商则更新采购价
                                        if (objNewModel.sp_default == 1)
                                        {
                                            //先把所有供应商设为非默认
                                            yt_product_supplier_relate.PocoDb.Execute("update yt_product_supplier_relate set sp_default = 0 where sp_sku_id = @0", objNewModel.sp_sku_id);
                                            var baseList = new List<yt_product_base>();
                                            var objBase = yt_product_base.Func_GetById(objNewModel.sp_sku_id);
                                            var objSup = yt_product_supplier.FirstOrDefault(" where sp_relation_id = @0", objNewModel.sp_id);
                                            int count = objNewModel.Update();
                                            //采购价与供应商报价不一致时才更改
                                            if (objBase.s_price != objSup.sp_price)
                                            {
                                                objBase.s_price = objSup.sp_price;
                                                objBase.s_updatename = objUpdate.user;
                                                baseList.Add(objBase);
                                                ProductServices.SaveProductBase(baseList);
                                            }
                                            //增加日志
                                            AsyncSaveSupplierRelateLog(objUpdate, tempModel, objUpdate.user);
                                            result.result_msg = "成功";
                                            result.result_code = 1;
                                        }
                                        else
                                        {
                                            //获取所有该SKU对应的供应商，确保至少有一个为默认供应商
                                            var allSupList = yt_product_supplier_relate.Fetch(" where sp_sku_id = @0 and sp_sp_id != @1 and sp_default = 1", objNewModel.sp_sku_id, objNewModel.sp_sp_id);
                                            if(allSupList.Count > 0)
                                            {
                                                int count = objNewModel.Update();
                                                //增加日志
                                                AsyncSaveSupplierRelateLog(objUpdate, tempModel, objUpdate.user);
                                                result.result_msg = "成功";
                                                result.result_code = 1;
                                            }
                                            else
                                            {
                                                result = ApiDataManage.CreateApiResult(600);
                                                //如果其他供应商非默认供应商，则当前还是默认供应商
                                                result.result_msg = "失败,修改为非默认供应商，最少一个为该SKU的默认供应商;";
                                                tx.Dispose();
                                                break;
                                            }
                                        }
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(600);
                                    result.result_msg = $"{CommonBaseLib.GetJsonToString(objUpdate)}找不到相关数据;";
                                    tx.Dispose();
                                    break;
                                }
                            }
                            else if (objUpdate.table == "yt_product_state")
                            {
                                var modelList = yt_product_state.Fetch(sql).ToList();
                                if(modelList.Count > 0)
                                {
                                    foreach(var objOldModel in modelList)
                                    {
                                        yt_product_state tempModel = CommonBaseLib.GetJsonToObject<yt_product_state>(CommonBaseLib.GetJsonToString(objOldModel));
                                        var objNewModel = (yt_product_state)ProductInfoServices.UpdateDataAssembly(objUpdate, objOldModel);
                                        objNewModel.st_updatename = objUpdate.user;
                                        objNewModel.st_updatetime = DateTime.Now;
                                        objNewModel.st_toold = 0;
                                        int count = objNewModel.Update();
                                        //增加日志
                                        AsyncSaveStateLog(objUpdate, tempModel);
                                        result.result_msg = "成功";
                                        result.result_code = 1;
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(600);
                                    result.result_msg += $"{CommonBaseLib.GetJsonToString(objUpdate)}找不到相关数据;";
                                    tx.Dispose();
                                    break;
                                }
                            }
                        }
                        tx.Complete();
                    }
                    catch (Exception ex)
                    {
                        tx.Dispose();
                        result = ApiDataManage.CreateApiResult(500);
                        result.result_msg += ex.Message;
                    }
                }
            }

            //开启同步到旧表
            //DataToSameStock.InsertOrUpdateToSame();
            return result;
        }

        /// <summary>
        /// 验证可修改的字段
        /// </summary>
        /// <returns></returns>
        private static string VerifyTheField(List<UpdateTable> updateList)
        {
            string msg = "";
            foreach (var objUpdate in updateList)
            {
                List<UpdateColumn> list = objUpdate.col;
                if (string.IsNullOrWhiteSpace(objUpdate.user))
                    msg = "操作人信息不能为空。";

                if (list.Count > 0)
                {
                    foreach (var item in list)
                    {
                        msg += VerifyTheFieldColumn.VerifyTheFieldMsg(item.key);
                    }
                    if (msg != "")
                        msg += "不允许修改列：" + msg.TrimEnd(',');
                }
                else
                {
                    msg += "参数错误，没有需要修改的列";
                }
            }

            return msg;
        }

        /// <summary>
        /// 过滤可修改的字段
        /// </summary>
        /// <returns></returns>
        private static List<UpdateTable> FilterTheField(List<UpdateTable> updateList)
        {
            foreach (var objUpdate in updateList)
            {
                var tempList = objUpdate.col.Where(m => 1 == 1).ToList();
                List<UpdateColumn> list = objUpdate.col;
                if (list.Count > 0)
                {
                    foreach (var item in tempList)
                    {
                        var key = VerifyTheFieldColumn.FilterTheFieldMsg(item.key);
                        if(key != "")
                        {
                            list.Remove(item);
                        }
                        if (item.key == "s_product_size" || item.key == "s_packing_size")
                            item.val = item.val.Replace("*", ",");
                    }
                }
            }

            return updateList;
        }

        /// <summary>
        /// 异步商品基础信息保存日志
        /// </summary>
        public static void AsyncSaveMainBaseLog(UpdateTable objUpdate, dv_product_mian_deve objModel, string userName)
        {
            Task.Factory.StartNew(() =>
            {
                Dictionary<string, string> dicModel = new Dictionary<string, string>();
                foreach (var item in objUpdate.col)
                {
                    dicModel.Add(item.key, item.val);
                }

                List<yt_product_log> logList = new List<yt_product_log>();
                List<object> paralist = new List<object>();
                ProductServices.GetPropertyValue(objModel, dicModel, out paralist, out logList, 0);
                logList.ForEach(m =>
                {
                    m.Operator = userName;
                    m.OperateTime = DateTime.Now;
                    m.ProductId = objModel.pd_mian_id;
                    m.ProductCode = objModel.pd_sku;
                    m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                    m.LogType = Convert.ToInt32(LogType.ProductLog);
                });
                //批量插入日志记录
                ProductServices.AddProductLog(logList);

            });
        }

        /// <summary>
        /// 异步基础信息保存日志
        /// </summary>
        public static void AsyncSaveBaseLog(UpdateTable objUpdate, yt_product_base objModel, string userName)
        {
            Task.Factory.StartNew(() =>
            {
                Dictionary<string, string> dicModel = new Dictionary<string, string>();
                foreach (var item in objUpdate.col)
                {
                    dicModel.Add(item.key, item.val);
                }

                List<yt_product_log> logList = new List<yt_product_log>();
                List<object> paralist = new List<object>();
                ProductServices.GetPropertyValue(objModel, dicModel, out paralist, out logList, 0);
                logList.ForEach(m =>
                {
                    m.Operator = userName;
                    m.OperateTime = DateTime.Now;
                    m.ProductId = objModel.s_id;
                    m.ProductCode = objModel.s_sku;
                    m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                    m.LogType = Convert.ToInt32(LogType.SkuLog);
                });
                //批量插入日志记录
                ProductServices.AddProductLog(logList);
            });
        }

        /// <summary>
        /// 异步开发信息保存日志
        /// </summary>
        public static void AsyncSaveExploitLog(UpdateTable objUpdate, yt_product_exploit objModel, string userName)
        {
            Task.Factory.StartNew(() =>
            {
                Dictionary<string, string> dicModel = new Dictionary<string, string>();
                foreach (var item in objUpdate.col)
                {
                    dicModel.Add(item.key, item.val);
                }

                List<yt_product_log> logList = new List<yt_product_log>();
                List<object> paralist = new List<object>();
                yt_product_base objBase = yt_product_base.Func_GetById(objModel.ex_sid);
                ProductServices.GetPropertyValue(objModel, dicModel, out paralist, out logList, 0);
                logList.ForEach(m =>
                {
                    m.Operator = userName;
                    m.OperateTime = DateTime.Now;
                    m.ProductId = objBase.s_id;
                    m.ProductCode = objBase.s_sku;
                    m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                    m.LogType = Convert.ToInt32(LogType.SkuLog);
                });
                //批量插入日志记录
                ProductServices.AddProductLog(logList);
            });
        }

        /// <summary>
        /// 异步供应商信息保存日志
        /// </summary>
        public static void AsyncSaveSupplierLog(UpdateTable objUpdate, yt_product_supplier objModel, string userName)
        {
            Task.Factory.StartNew(() =>
            {
                Dictionary<string, string> dicModel = new Dictionary<string, string>();
                foreach (var item in objUpdate.col)
                {
                    dicModel.Add(item.key, item.val);
                }

                List<yt_product_log> logList = new List<yt_product_log>();
                List<object> paralist = new List<object>();
                var objRelate = yt_product_supplier_relate.Func_GetById(objModel.sp_relation_id);
                yt_product_base objBase = yt_product_base.Func_GetById(objRelate.sp_sku_id);
                ProductServices.GetPropertyValue(objModel, dicModel, out paralist, out logList, 0);
                logList.ForEach(m =>
                {
                    m.Operator = userName;
                    m.OperateTime = DateTime.Now;
                    m.ProductId = objBase.s_id;
                    m.ProductCode = objBase.s_sku;
                    m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                    m.LogType = Convert.ToInt32(LogType.SkuLog);
                });
                //批量插入日志记录
                ProductServices.AddProductLog(logList);
            });
        }

        /// <summary>
        /// 异步供应商关系信息保存日志
        /// </summary>
        public static void AsyncSaveSupplierRelateLog(UpdateTable objUpdate, yt_product_supplier_relate objModel, string userName)
        {
            Task.Factory.StartNew(() =>
            {
                Dictionary<string, string> dicModel = new Dictionary<string, string>();
                foreach (var item in objUpdate.col)
                {
                    dicModel.Add(item.key, item.val);
                }

                List<yt_product_log> logList = new List<yt_product_log>();
                List<object> paralist = new List<object>();
                yt_product_base objBase = yt_product_base.Func_GetById(objModel.sp_sku_id);
                GetPropertyValue(objModel, dicModel, out paralist, out logList, 0);
                logList.ForEach(m =>
                {
                    m.Operator = userName;
                    m.OperateTime = DateTime.Now;
                    m.ProductId = objBase.s_id;
                    m.ProductCode = objBase.s_sku;
                    m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                    m.LogType = Convert.ToInt32(LogType.SkuLog);
                });
                //批量插入日志记录
                ProductServices.AddProductLog(logList);
            });
        }

        /// <summary>
        /// 异步状态信息保存日志
        /// </summary>
        public static void AsyncSaveStateLog(UpdateTable objUpdate, yt_product_state objModel)
        {
            Task.Factory.StartNew(() =>
            {
                List<yt_product_log> logList = new List<yt_product_log>();
                List<object> paralist = new List<object>();
                yt_product_base objBase = yt_product_base.Func_GetById(objModel.st_sid);
                Dictionary<string, string> dicModel = new Dictionary<string, string>();
                foreach (var item in objUpdate.col)
                {
                    dicModel.Add(item.key, item.val);
                }
                ProductServices.GetPropertyValue(objModel, dicModel, out paralist, out logList, 0);
                logList.ForEach(m =>
                {
                    m.Operator = objUpdate.user;
                    m.OperateTime = DateTime.Now;
                    m.ProductId = objBase.s_id;
                    m.ProductCode = objBase.s_sku;
                    m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                    m.LogType = Convert.ToInt32(LogType.SkuLog);
                });
                //批量插入日志记录
                ProductServices.AddProductLog(logList);

            });
        }

        #endregion

        public static void CreateOperateLog(string appId, ApiEntrance api, UpdateTable model, yt_stock objStock)
        {
            yt_stock_api_log objApiLog = new yt_stock_api_log();
            objApiLog.app_id = appId;
            objApiLog.api_code = api.code;
            objApiLog.api_key = api.key;
            objApiLog.operate_table = model.table;
            objApiLog.operate_id = objStock.S_ID.ToString();
            objApiLog.operate_person = model.user;
            objApiLog.operate_time = DateTime.Now;
            objApiLog.operate_type = "修改";

            List<UpdateColumn> upList = model.col;
            foreach (PropertyInfo item in objStock.GetType().GetProperties())
            {
                for (int i = 0; i < upList.Count; i++)
                {
                    if (item.Name.Equals(upList[i].key))
                    {
                        objApiLog.old_data = item.GetValue(objStock).ToString();
                        objApiLog.new_data = upList[i].val;
                        objApiLog.Insert();
                    }
                }
            }
        }
    }
}
