﻿using API.Services;
using ApiControl;
using System.Web.Http;

namespace WebApi.Areas.ApiCenter.Controllers
{
    /// <summary>
    /// Api入口控制中心
    /// </summary>
    [RoutePrefix("api/ApiCenter")]
    public class ApiEntranceController : ApiController
    {
        /// <summary>
        /// 获取公共数据入口
        /// </summary>
        /// <returns></returns>
        [Route("GetData")]
        public ApiResult GetData(string sign, string appId, string data)
        {
            DataStr ds = new DataStr() {
                sign = sign,
                appId = appId,
                data = data
            };
            ApiResult result = ApiAddressCenter.ApiAnalysisCenter(ds);
            return result;
        }

        /// <summary>
        /// 操作公共数据入口
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [Route("SetData")]
        public ApiResult SetData(DataStr ds)
        {
            ApiResult result = ApiAddressCenter.ApiAnalysisCenter(ds);
            return result;
        }
    }
}