﻿using System;
using System.Drawing;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;

namespace ApiControl
{
    public class HttpGetOrPost
    {
        public static string httpGet(string url, string contentType = "application/json")
        {
            string result;
            WebRequest req = WebRequest.Create(url);
            req.ContentType = contentType;

            using (HttpWebResponse response = (HttpWebResponse)req.GetResponse())
            {
                using (Stream receiveStream = response.GetResponseStream())
                {
                    using (StreamReader readerOfStream = new StreamReader(receiveStream, System.Text.Encoding.UTF8))
                    {
                        result = readerOfStream.ReadToEnd();
                    }
                }
            }
            return result;
        }

        //post方法调用接口获取json文件内容
        public static string httpPost(string url, string postDataStr, string encoding = "utf-8")
        {
            string retString = "";
            try
            {
                byte[] arrB = Encoding.GetEncoding(encoding).GetBytes(postDataStr);
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                request.Method = "POST";
                request.ContentType = "application/x-www-form-urlencoded";
                request.ContentLength = arrB.Length;
                Stream outStream = request.GetRequestStream();
                outStream.Write(arrB, 0, arrB.Length);
                outStream.Close();

                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {
                    if (response.StatusCode != HttpStatusCode.OK)
                    {
                        throw new Exception("httppost请求响应失败。");
                    }

                    using (Stream myResponseStream = response.GetResponseStream())
                    {
                        using (StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.GetEncoding(encoding)))
                        {
                            retString = myStreamReader.ReadToEnd();
                        }
                    }
                }
            }
            catch(WebException ex)
            {
                if (ex.Status == WebExceptionStatus.ProtocolError)
                {
                    using (Stream myResponseStream = ((HttpWebResponse)ex.Response).GetResponseStream())
                    {
                        using (StreamReader myStreamReader = new StreamReader(myResponseStream,
                                Encoding.GetEncoding("utf-8")))
                        {
                            retString = myStreamReader.ReadToEnd();
                        }
                    }
                }
            }

            return retString;
        }

        /// <summary>
        /// POST参数为LIST调用
        /// </summary>
        /// <param name="Url"></param>
        /// <param name="postDataStr"></param>
        /// <returns></returns>
        public static string HttpPostJson(string Url, string postDataStr, string encoding = "utf-8")
        {
            string retString = "";
            try
            {
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(Url);
                request.Method = "POST";
                request.ContentType = "application/json";
                request.Timeout = 1200000;
                byte[] buffer = Encoding.GetEncoding(encoding).GetBytes(postDataStr);
                request.ContentLength = buffer.Length;
                Stream outStream = request.GetRequestStream();
                outStream.Write(buffer, 0, buffer.Length);
                outStream.Close();

                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {
                    if (response.StatusCode != HttpStatusCode.OK)
                    {
                        throw new Exception("httppost请求响应失败。");
                    }

                    using (Stream myResponseStream = response.GetResponseStream())
                    {
                        using (StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.GetEncoding(encoding)))
                        {
                            retString = myStreamReader.ReadToEnd();
                        }
                    }
                }
            }
            catch(WebException ex)
            {
                if (ex.Status == WebExceptionStatus.ProtocolError)
                {
                    using (Stream myResponseStream = ((HttpWebResponse)ex.Response).GetResponseStream())
                    {
                        using (StreamReader myStreamReader = new StreamReader(myResponseStream,
                                Encoding.GetEncoding("utf-8")))
                        {
                            retString = myStreamReader.ReadToEnd();
                        }
                    }
                }
            }
            
            return retString;
        }

        /// <summary>
        /// 获取IP地址
        /// </summary>
        public static string IPAddress
        {
            get
            {
                string userIP;
                // HttpRequest Request = HttpContext.Current.Request;
                HttpRequest Request = HttpContext.Current.Request; // ForumContext.Current.Context.Request;
                // 如果使用代理，获取真实IP
                if (Request.ServerVariables["HTTP_X_FORWARDED_FOR"] != "")
                    userIP = Request.ServerVariables["REMOTE_ADDR"];
                else
                    userIP = Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
                if (userIP == null || userIP == "")
                    userIP = Request.UserHostAddress;
                return userIP;
            }
        }

        /// <summary>
		/// 图片转为Byte字节数组
		/// </summary>
		/// <param name="FilePath">路径</param>
		/// <returns>字节数组</returns>
		public byte[] ImageToByteArray(string FilePath)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                using (Image imageIn = Image.FromFile(FilePath))
                {
                    using (Bitmap bmp = new Bitmap(imageIn))
                    {
                        bmp.Save(ms, imageIn.RawFormat);
                    }
                }
                return ms.ToArray();
            }
        }
    }
}