﻿using MySql.Data.MySqlClient;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;

namespace ApiControl
{
    public class ApiDataManage
    {
        public static string ApiUrl = System.Configuration.ConfigurationManager.AppSettings["ApiCenter"];
        public static string ApiAppId = System.Configuration.ConfigurationManager.AppSettings["ApiCenAppId"];
        public static string ApiAppKey = System.Configuration.ConfigurationManager.AppSettings["ApiCenAppKey"];
        public static string SystemConfig = "";

        #region API数据处理
        #region 接口中心合成
        /// <summary>
        /// 公共获取接口
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static ApiResult ApiGet(ApiEntrance model)
        {
            return ApiSend("get", model);
        }

        /// <summary>
        /// 公共操作接口
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static ApiResult ApiPost(ApiEntrance model)
        {
            return ApiSend("post", model);
        }

        private static ApiResult ApiSend(string type, ApiEntrance model)
        {
            string strJson = "";
            string url = ApiUrl;
            string sign = GetSign(ApiAppKey, model);
            string data = CommonBaseLib.UrlToEncode(CommonBaseLib.GetJsonToString(model));
            
            if (type == "get")
            {
                url += "/api/ApiCenter/GetData";
                strJson = HttpGetOrPost.httpGet(url + "?sign=" + sign + "&appId=" + ApiAppId + "&data=" + data);
            }
            else if (type == "post")
            {
                DataStr ds = new DataStr();
                ds.sign = sign;
                ds.appId = ApiAppId;
                ds.data = data;
                string dataStr = CommonBaseLib.GetJsonToString(ds);
                url += "/api/ApiCenter/SetData";
                strJson = HttpGetOrPost.HttpPostJson(url, dataStr);
            }
            
            ApiResult ar = CommonBaseLib.GetJsonToObject<ApiResult>(strJson);
            return ar;
        }
        #endregion

        #region 自定义接口合成
        /// <summary>
        /// 自定义获取接口
        /// </summary>
        /// <param name="model"></param>
        /// <param name="url">全链接</param>
        /// <returns></returns>
        public static ApiResult ApiGetUrl(ApiEntrance model, string url)
        {
            return ApiSendUrl("get", model, url);
        }

        /// <summary>
        /// 自定义操作接口
        /// </summary>
        /// <param name="model"></param>
        /// <param name="url">全链接</param>
        /// <returns></returns>
        public static ApiResult ApiPostUrl(ApiEntrance model, string url)
        {
            return ApiSendUrl("post", model, url);
        }

        private static ApiResult ApiSendUrl(string type, ApiEntrance model, string url)
        {
            string strJson = "";
            string sign = GetSign(ApiAppKey, model);
            string data = CommonBaseLib.UrlToEncode(CommonBaseLib.GetJsonToString(model));

            if (type == "get")
            {
                strJson = HttpGetOrPost.httpGet(url + "?sign=" + sign + "&appId=" + ApiAppId + "&data=" + data);
            }
            else if (type == "post")
            {
                DataStr ds = new DataStr();
                ds.sign = sign;
                ds.appId = ApiAppId;
                ds.data = data;
                string dataStr = CommonBaseLib.GetJsonToString(ds);
                strJson = HttpGetOrPost.HttpPostJson(url, dataStr);
            }
            
            ApiResult ar = CommonBaseLib.GetJsonToObject<ApiResult>(strJson);
            return ar;
        }
        #endregion

        /// <summary>
        /// 获取API签名
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static string GetSign(string appKey, ApiEntrance model)
        {
            string sign = Security.md5Encrypt(appKey + model.code + Security.md5Encrypt(model.key + model.data));
            return sign;
        }

        /// <summary>
        /// 配置各系统的代码 bailun+System
        /// </summary>
        /// <param name="appId"></param>
        /// <returns></returns>
        private static string GetAppIdKey(string appId)
        {
            if(SystemConfig == "")
            {
                string path = HttpContext.Current.Server.MapPath("~/SystemKeyConfig.json");
                SystemConfig = File.ReadAllText(path, Encoding.UTF8);
            }
            var systemList = CommonBaseLib.GetJsonToObject<List<SystemConfig>>(SystemConfig);
            var objSys = systemList.FirstOrDefault(m => m.key == appId);
            if (objSys != null)
                return objSys.value;
            else
                return "";
        }

        /// <summary>
        /// 验证签名是否匹配
        /// </summary>
        /// <param name="sign">签名</param>
        /// <param name="data">Json数据</param>
        /// <returns></returns>
        public static ApiCompare GetSignCompare(DataStr ds)
        {
            ApiEntrance model = CommonBaseLib.DecodeAndObject<ApiEntrance>(ds.data);

            ApiCompare pare = new ApiCompare();
            //验证签名是否匹配,否则返回签名错误代码
            string appKey = GetAppIdKey(ds.appId);
            if (ds.sign.Equals(GetSign(appKey, model)) && !string.IsNullOrWhiteSpace(appKey))
            {
                pare.state = true;
                pare.data = model;
            }
            else
            {
                ApiResult result = CreateApiResult(401);

                pare.state = false;
                pare.result = result;
            }
            //监控接口调用情况,根据调用系统记录
            //LoggerHelper.Monitor($"签名状态：{pare.state}\r\nIP: {IPAddress}\r\n参数：{CommonBaseLib.GetJsonToString(model)}", ds.appId);
            return pare;
        }

        /// <summary>
        /// 获取生成的加密数据
        /// </summary>
        /// <param name="code">系统标识码</param>
        /// <param name="key">接口标识</param>
        /// <param name="strJson">未编码Json数据</param>
        /// <returns></returns>
        public static string GetApiEncrypt(string code, string key, string strJson)
        {
            ApiEntrance model = new ApiEntrance()
            {
                code = code,
                key = key,
                data = strJson
            };
            string strData = CommonBaseLib.UrlToDecode(CommonBaseLib.GetJsonToString(model));
            return strData;
        }

        public static ApiResult CreateApiResult(int resultCode)
        {
            ApiResult result = new ApiResult();
            result.result_code = resultCode;
            result.result_msg = Enum.GetName(typeof(Eresult_code), resultCode);
            return result;
        }

        /// <summary>
        /// 获取IP地址
        /// </summary>
        public static string IPAddress
        {
            get
            {
                string userIP;
                // HttpRequest Request = HttpContext.Current.Request;
                HttpRequest Request = HttpContext.Current.Request; // ForumContext.Current.Context.Request;
                // 如果使用代理，获取真实IP
                if (Request.ServerVariables["HTTP_X_FORWARDED_FOR"] != "")
                    userIP = Request.ServerVariables["REMOTE_ADDR"];
                else
                    userIP = Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
                if (userIP == null || userIP == "")
                    userIP = Request.UserHostAddress;
                return userIP;
            }
        }
        #endregion
    }

    #region API调用入口实体
    public class ApiCompare
    {
        /// <summary>
        /// 签名是否正确
        /// </summary>
        public bool state { get; set; }

        /// <summary>
        /// 调用的数据
        /// </summary>
        public ApiEntrance data { get; set; }

        /// <summary>
        /// 返回结果数据
        /// </summary>
        public ApiResult result { get; set; }
    }

    /// <summary>
    /// API公共入口
    /// </summary>
    public class ApiEntrance
    {
        /// <summary>
        /// 系统标识码
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 接口名标识
        /// </summary>
        public string key { get; set; }

        /// <summary>
        /// Json数据
        /// </summary>
        public string data { get; set; }
    }
    #endregion

    #region API公共返回数据实体
    public class ApiResult
    {
        /// <summary>
        /// 返回代码
        /// </summary>
        public int result_code { get; set; }

        /// <summary>
        /// 返回信息
        /// </summary>
        public string result_msg { get; set; }

        /// <summary>
        /// 返回JSON数据
        /// </summary>
        public string data { get; set; }
    }

    public class SystemConfig
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 系统主键
        /// </summary>
        public string key { get; set; }

        /// <summary>
        /// 系统值
        /// </summary>
        public string value { get; set; }
    }

    public enum Eresult_code
    {
        成功 = 1,
        数据验证不通过 = 400,
        签名错误 = 401,
        找不到对应的系统名 = 402,
        找不到对应的接口名 = 404,
        系统错误 = 500,
        SQL格式错误 = 504,
        其他信息 = 600
    }

    #endregion
}
