﻿using ApiControl;
using DbConn;
using PetaPoco.Custom.Stock;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace API.Services.StockManageServices
{
    public class StockServices
    {
        /// <summary>
        /// 获取分销虚拟库存
        /// </summary>
        /// <returns></returns>
        public static ApiResult GetDistributeStockInfo(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            try
            {
                var skuArr = dataJson.Split(',');
                var dataList = DbConnDB.GetInstance().Fetch<DistributeStock>("select ei_sku skuCode,ei_stock stock from dv_exploit_info where ei_sku in (@sku) and ei_stock > 0 and (ei_shopname = 'tuonisi' or ei_shopname = 'dengyu') limit 1000", new { sku = skuArr });
                result = ApiDataManage.CreateApiResult(1);
                result.data = CommonBaseLib.EncodeAndJson(dataList);
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = "系统异常。" + ex.Message;
            }
            return result;
        }
    }
}
