﻿using API.Services.PmsApiServices;
using ApiControl;
using DbConn;
using PetaPoco;
using PetaPoco.Custom.ProductData;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Threading.Tasks;

namespace API.Services.ProductManageServices
{
    public class ProductServices
    {
        #region 实体合并模块
        /// <summary>
        /// 添加SKU信息接口
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveAllProductInfo(List<AllProductInfo> productList)
        {
            using (Database DB = DbConnDB.GetInstance())
            {
                using (var tx = DB.GetTransaction())
                {
                    var result = SaveAllProduct(productList);
                    if (result.result_code == 1)
                        tx.Complete();
                    else
                        tx.Dispose();

                    return result;
                }
            }
        }

        /// <summary>
        /// 添加SKU信息执行
        /// </summary>
        /// <param name="productList"></param>
        /// <returns></returns>
        public static ApiResult SaveAllProduct(List<AllProductInfo> productList)
        {
            ApiResult result = new ApiResult();
            StringBuilder errorMsg = new StringBuilder();
            int index = 0;
            try
            {
                foreach (var item in productList)
                {
                    index += 1;
                    var baseList = new List<yt_product_base>();
                    var objBase = new yt_product_base();
                    var listBase = new List<yt_product_base>();
                    var objExploit = new yt_product_exploit();
                    var listExploit = new List<yt_product_exploit>();
                    var objRelate = new yt_product_supplier_relate();
                    var objSupplier = new yt_product_supplier();
                    var listSupplier = new List<yt_product_supplier>();
                    var objState = new yt_product_state();
                    var listState = new List<yt_product_state>();
                    var objWare = new yt_product_ware();
                    var listWare = new List<yt_product_ware>();

                    var allProInfo = ConvertToDictionary(item);

                    //产品基本信息
                    objBase = ExChangeToEntity(objBase, allProInfo);
                    listBase.Add(objBase);
                    var resultBase = SaveProductBase(listBase, false);
                    if (resultBase.result_code == 1 && objBase.s_id > 0)
                    {
                        var newBase = CommonBaseLib.GetJsonToObject<yt_product_base>(resultBase.data);
                        objBase.s_id = newBase.s_id;
                        item.s_id = objBase.s_id;
                                
                        //开发表信息
                        item.ex_sid = item.ex_sid > 0 ? item.ex_sid : item.s_id;
                        item.ex_main_id = item.s_main_id;
                        item.ex_sku = item.s_sku;
                        //状态表信息
                        item.st_main_id = item.s_main_id;
                        item.st_sid = item.st_sid > 0 ? item.st_sid : item.s_id;
                        item.st_sku = item.s_sku;
                        item.st_createtime = Convert.ToDateTime(newBase.s_createtime).ToString("yyyy-MM-dd");
                    }
                    else
                    {
                        errorMsg.Append($"{item.s_goods_code}第{index}行数据插入失败，error：{resultBase.result_msg};");
                        continue;
                    }

                    //产品开发信息
                    allProInfo = ConvertToDictionary(item);
                    objExploit = ExChangeToEntity(objExploit, allProInfo);
                    listExploit.Add(objExploit);
                    objExploit.ex_sid = objExploit.ex_sid > 0 ? objExploit.ex_sid : item.s_id;
                    var resultExploit = SaveProductExploit(listExploit, false);
                    if (resultExploit.result_code == 1 && objExploit.ex_id > 0)
                    {
                        objExploit.ex_id = Convert.ToInt32(resultExploit.data);
                        item.ex_id = objExploit.ex_id;
                    }
                    else
                    {
                        errorMsg.Append($"{item.s_goods_code}第{index}行数据插入失败，error：{resultBase.result_msg};");
                        continue;
                    }

                    //产品状态信息
                    allProInfo = ConvertToDictionary(item);
                    objState = ExChangeToEntity(objState, allProInfo);
                    listState.Add(objState);
                    objState.st_sid = objState.st_sid > 0 ? objState.st_sid : item.s_id;
                    var resultState = SaveProductState(listState, false);
                    if (resultState.result_code == 1 && objState.st_id > 0)
                    {
                        objState.st_id = Convert.ToInt32(resultState.data);
                        item.st_id = objState.st_id;
                    }
                    else
                    {
                        errorMsg.Append($"{item.s_goods_code}第{index}行数据插入失败，error：{resultBase.result_msg};");
                        continue;
                    }

                    foreach (var sp in item.spList)
                    {
                        var supInfo = ConvertToDictionary(sp);
                        objSupplier = ExChangeToEntity(objSupplier, supInfo);
                        if (objSupplier.sp_relation_id > 0)
                        {
                            listSupplier.Add(objSupplier);
                            var resultSupplier = SaveProductSupplier(listSupplier, false);
                            if (resultSupplier.result_code != 1)
                            {
                                errorMsg.Append($"{item.s_goods_code}第{index}行数据插入失败，error：{resultBase.result_msg};");
                                continue;
                            }
                        }
                        else
                        {
                            //新增供应商关系表
                            objRelate.sp_main_id = objBase.s_main_id;
                            objRelate.sp_sku_id = objBase.s_id;
                            objRelate.sp_sp_id = sp.sp_sp_id;
                            objRelate.sp_default = sp.sp_default;
                            objRelate.Insert();

                            //供应商外键信息赋值
                            objSupplier.sp_relation_id = objRelate.sp_id;
                            objSupplier.sp_main_id = item.s_main_id;
                            objSupplier.sp_sid = item.s_id;
                            objSupplier.sp_sku = item.s_sku;

                            listSupplier.Add(objSupplier);
                            var resultSupplier = SaveProductSupplier(listSupplier, false);
                            if (resultSupplier.result_code == 1 && objSupplier.sp_id > 0)
                            {
                                objSupplier.sp_id = Convert.ToInt32(resultSupplier.data);
                                sp.sp_id = objSupplier.sp_id;
                                sp.sp_sp_id = objRelate.sp_sp_id;
                                sp.sp_relation_id = objRelate.sp_id;
                                sp.sp_main_id = item.s_main_id;
                                sp.sp_sid = item.s_id;
                                sp.sp_sku = item.s_sku;
                            }
                            else
                            {
                                errorMsg.Append($"{item.s_goods_code}第{index}行数据插入失败，error：{resultBase.result_msg};");
                                continue;
                            }
                        }
                    }

                    //发货仓库状态信息
                    if(!string.IsNullOrWhiteSpace(item.pw_ware_code))
                    {
                        allProInfo = ConvertToDictionary(item);
                        objWare = ExChangeToEntity(objWare, allProInfo);
                        objWare.pw_sid = objWare.pw_sid > 0 ? objWare.pw_sid : item.s_id;
                        listWare.Add(objWare);
                        var resultWare = SaveProductWare(listWare, false);
                        if (resultWare.result_code == 1)
                        {
                            objWare.pw_id = Convert.ToInt32(resultWare.data);
                            item.pw_id = objWare.pw_id;
                        }
                        else
                        {
                            errorMsg.Append($"{item.s_goods_code}第{index}行数据插入失败，error：{resultBase.result_msg};");
                            continue;
                        }
                    }
                }
                if (errorMsg.Length>0)
                {
                    result.result_msg = errorMsg.ToString();
                }
                result.result_code = 1;
                result.data = CommonBaseLib.GetJsonToString(productList);

                //开启同步到旧表
                //DataToSameStock.InsertOrUpdateToSame();
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = ex.Message;
            }
            return result;
        }
        #endregion

        #region 批量保存操作模块
        public static ApiResult BatchProductInfo(BatchProductInfo batchProduct)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            string[] skuArr = batchProduct.skus.Split(',');
            using (var dbContext = DbConnDB.GetInstance())
            {
                using (var tx = dbContext.GetTransaction())
                {
                    try
                    {
                        var objMain = CommonBaseLib.GetJsonToObject<dv_product_mian_deve>(CommonBaseLib.GetJsonToString(batchProduct));
                        if (GetBatchPropertyValue(objMain))
                        {
                            var myMainBaseList = new List<dv_product_mian_deve>();
                            var baseList = yt_product_base.Fetch(" where s_sku in (@skus) and s_main_id > 0 group by s_main_id", new { skus = skuArr }).ToList();
                            foreach (var item in baseList)
                            {
                                var objOldMain = dv_product_mian_deve.FirstOrDefault(" where pd_mian_id = @0", item.s_main_id);
                                if(objOldMain != null)
                                {
                                    var tempMain = new dv_product_mian_deve();
                                    var dicModel = ConvertToDictionary(objMain);
                                    tempMain = ExChangeBatchToEntity(objOldMain, dicModel);
                                    tempMain.pd_updater = batchProduct.updateName;
                                    myMainBaseList.Add(tempMain);
                                }
                            }
                            SaveMainProductBase(myMainBaseList);
                        }

                        var objBase = CommonBaseLib.GetJsonToObject<yt_product_base>(CommonBaseLib.GetJsonToString(batchProduct));
                        if (GetBatchPropertyValue(objBase))
                        {
                            var myBaseList = new List<yt_product_base>();
                            var baseList = yt_product_base.Fetch(" where s_sku in (@skus)", new { skus = skuArr }).ToList();
                            foreach (var item in baseList)
                            {
                                var tempBase = new yt_product_base();
                                var dicModel = ConvertToDictionary(objBase);
                                if (objBase.s_category_simple > 0)
                                {
                                    tempBase.s_category_simple = objBase.s_category_simple;
                                }
                                tempBase = ExChangeBatchToEntity(item, dicModel);
                                tempBase.s_updatename = batchProduct.updateName;
                                myBaseList.Add(tempBase);
                            }
                            SaveProductBase(myBaseList, true, true);
                        }

                        var objExploit = CommonBaseLib.GetJsonToObject<yt_product_exploit>(CommonBaseLib.GetJsonToString(batchProduct));
                        if (GetBatchPropertyValue(objExploit))
                        {
                            var myExploitList = new List<yt_product_exploit>();
                            var exploitList = yt_product_exploit.Fetch(" where ex_sku in (@skus)", new { skus = skuArr }).ToList();
                            foreach (var item in exploitList)
                            {
                                var tempExploit = new yt_product_exploit();
                                var dicModel = ConvertToDictionary(objExploit);
                                tempExploit = ExChangeBatchToEntity(item, dicModel);
                                tempExploit.ex_updatename = batchProduct.updateName;
                                myExploitList.Add(tempExploit);
                            }
                            SaveProductExploit(myExploitList, true, true);
                        }

                        var objSupplier = CommonBaseLib.GetJsonToObject<yt_product_supplier>(CommonBaseLib.GetJsonToString(batchProduct));
                        if (GetBatchPropertyValue(objSupplier))
                        {
                            var mySupplierList = new List<yt_product_supplier>();
                            var supplierList = yt_product_supplier.Fetch(" where sp_sku in (@skus)", new { skus = skuArr }).ToList();
                            foreach (var item in supplierList)
                            {
                                var tempSupplier = new yt_product_supplier();
                                var dicModel = ConvertToDictionary(objSupplier);
                                tempSupplier = ExChangeBatchToEntity(item, dicModel);
                                tempSupplier.sp_updatename = batchProduct.updateName;
                                mySupplierList.Add(tempSupplier);
                            }
                            SaveProductSupplier(mySupplierList, true, true);
                        }

                        var objState = CommonBaseLib.GetJsonToObject<yt_product_state>(CommonBaseLib.GetJsonToString(batchProduct));
                        if (GetBatchPropertyValue(objState))
                        {
                            var myStateList = new List<yt_product_state>();
                            var stateList = yt_product_state.Fetch(" where st_sku in (@skus)", new { skus = skuArr }).ToList();
                            foreach (var item in stateList)
                            {
                                var tempState = new yt_product_state();
                                var dicModel = ConvertToDictionary(objState);
                                tempState = ExChangeBatchToEntity(item, dicModel);
                                tempState.st_updatename = batchProduct.updateName;
                                myStateList.Add(tempState);
                            }
                            SaveProductState(myStateList, true, true);
                        }
                        List<yt_product_ware> myWares = new List<yt_product_ware>();
                        var wareList = yt_product_ware.Fetch(" where pw_sku in (@skus) and pw_isdefault=1 ", new { skus = skuArr }).ToList();
                        if (wareList?.Count > 0)
                        {
                            foreach (var item in wareList)
                            {
                                item.pw_ware_code = batchProduct.pw_ware_code;
                                item.pw_updatename = batchProduct.updateName;
                                myWares.Add(item);
                            }
                            AddProductWare(myWares);
                        }
                        //if (!string.IsNullOrEmpty(batchProduct.pw_ware_code))
                        //{
                        //    List<yt_product_ware> myWares = new List<yt_product_ware>();
                        //    var wareList = yt_product_ware.Fetch(" where pw_sku in (@skus) and pw_isdefault=1 ", new { skus = skuArr }).ToList();
                        //    if (wareList?.Count > 0)
                        //    {
                        //        foreach (var item in wareList)
                        //        {
                        //            item.pw_ware_code = batchProduct.pw_ware_code;
                        //            item.pw_updatename = batchProduct.updateName;
                        //            myWares.Add(item);
                        //        }
                        //        SaveProdcutWare(myWares);
                        //    }
                        //}
                        tx.Complete();
                        result.result_code = 1;
                        result.result_msg = "操作成功";
                    }
                    catch(Exception ex)
                    {
                        tx.Dispose();
                        result.result_code = 500;
                        result.result_msg = "操作出错！原因：" + ex.Message;
                    }
                }
            }

            return result;
        }
        #endregion

        #region 单实体保存模块
        /// <summary>
        /// 保存产品状态信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveMainProductBase(List<dv_product_mian_deve> modelList)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            try
            {
                Sql sql = Sql.Builder;
                foreach (var item in modelList)
                {
                    List<yt_product_log> _logList = new List<yt_product_log>();
                    item.pd_updatedate = DateTime.Now;
                    if (item.pd_mian_id > 0)
                    {
                        var objModel = dv_product_mian_deve.Func_GetById(item.pd_mian_id);
                        var dicModel = ConvertToDictionary(objModel);
                        var strSql = GetPropertyValue(item, dicModel, out paralist, out _logList);
                        if (strSql != "")
                        {
                            sql.Append($"update dv_product_mian_deve set {strSql} where pd_mian_id = {item.pd_mian_id};", paralist.ToArray());
                            _logList.ForEach(m =>
                            {
                                m.Operator = item.pd_updater;
                                m.OperateTime = item.pd_updatedate.Value;
                                m.ProductId = objModel.pd_mian_id;
                                m.ProductCode = objModel.pd_sku;
                                m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                                m.LogType = Convert.ToInt32(LogType.ProductLog);
                            });
                            logList.AddRange(_logList);
                        }
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "商品信息的主键信息不能为空。";
                    }
                }
                if (logList.Count > 0)
                {
                    var count = dv_product_mian_deve.PocoDb.Execute(sql);
                    if (count > 0)
                    {
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                }
                result.result_code = 1;
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 保存产品基本信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveProductBase(List<yt_product_base> modelList, bool isSame = true, bool isBatch = false)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();

            try
            {
                var skuIds = "";
                Sql sql = Sql.Builder;
                foreach (var item in modelList)
                {
                    item.s_product_size = string.IsNullOrWhiteSpace(item.s_product_size) ? "0,0,0" : item.s_product_size;
                    item.s_packing_size = string.IsNullOrWhiteSpace(item.s_packing_size) ? "0,0,0" : item.s_packing_size;
                    item.s_updatetime = DateTime.Now;
                    if (item.s_id > 0)
                    {
                        newSql: ;
                        var strSql = "";
                        List<yt_product_log> _logList = new List<yt_product_log>();
                        item.s_operatetype = "Update";
                        var objModel = yt_product_base.Func_GetById(item.s_id);
                        if (!isBatch || (isBatch && string.IsNullOrWhiteSpace(sql.SQL)))
                        {
                            var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", objModel.s_id);
                            //已上传环球SKU则不能再修改
                            if (objState.st_isupapi == 1 && objModel.s_sku != item.s_sku)
                            {
                                item.s_product = objModel.s_product;
                                item.s_sku = objModel.s_sku;
                            }
                            //百伦分类名称改变时重新获取分类路径
                            if(item.s_category_bailun_id > 0)
                            {
                                if (objModel.s_category_bailun_id != item.s_category_bailun_id || objModel.s_category_bailun_name != item.s_category_bailun_name)
                                {
                                    var myCateList = yt_category_bailun.GetMyParentCategories(item.s_category_bailun_id);
                                    var objMyCate = myCateList.FirstOrDefault(m => m.c_id == item.s_category_bailun_id);
                                    item.s_category_bailun_name = yt_category_bailun.GetFullNameByList(myCateList);
                                }
                            }
                            //if (item.s_category_simple == 1 && objModel.s_category_simple > 0)
                            //{
                            //    item.s_category_simple = objModel.s_category_simple;
                            //}                          
                        }
                        //采购价变动时默认供应商报价同时更改
                        if (objModel.s_price != item.s_price)
                        {
                            ChangePriceSameToSupplier(objModel.s_id, item.s_price.Value);
                        }
                        var dicModel = ConvertToDictionary(objModel);
                        strSql = GetPropertyValue(item, dicModel, out paralist, out _logList);
                        if (strSql != "" || isBatch)
                        {
                            //批量修改
                            if(isBatch)
                            {
                                skuIds += item.s_id + ",";
                                if (sql.Arguments.Length == 0)
                                {
                                    sql = Sql.Builder;
                                    sql.Append($"update yt_product_base set {strSql} ", paralist.ToArray());
                                }
                                else if (sql.Arguments.Length < paralist.Count)
                                {
                                    sql = Sql.Builder;
                                    goto newSql;
                                }
                                    
                            }
                            else
                                sql.Append($"update yt_product_base set {strSql} where s_id = {item.s_id};", paralist.ToArray());

                            _logList.ForEach(m =>
                            {
                                m.Operator = item.s_updatename;
                                m.OperateTime = item.s_updatetime.Value;
                                m.ProductCode = item.s_sku;
                                m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                                m.LogType = Convert.ToInt32(LogType.SkuLog);
                            });
                            if (objModel.s_product != item.s_product || objModel.s_sku != item.s_sku)
                            {
                                _logList.Add(new yt_product_log()
                                {
                                    OperateContent = "商品编码",
                                    BeforeOperated = objModel.s_product,
                                    AfterOperated = item.s_product,
                                    ProductId = objModel.s_id,
                                    ProductCode = objModel.s_sku,
                                    Operator = item.s_updatename,
                                    OperateTime = item.s_updatetime.Value,
                                    UpdateDate = item.s_updatetime.Value.ToString("yyyy-MM-dd"),
                                    LogType = Convert.ToInt32(LogType.SkuLog)
                                });
                                _logList.Add(new yt_product_log()
                                {
                                    OperateContent = "产品编码",
                                    BeforeOperated = objModel.s_sku,
                                    AfterOperated = item.s_sku,
                                    ProductId = objModel.s_id,
                                    ProductCode = objModel.s_sku,
                                    Operator = item.s_updatename,
                                    OperateTime = item.s_updatetime.Value,
                                    UpdateDate = item.s_updatetime.Value.ToString("yyyy-MM-dd"),
                                    LogType = Convert.ToInt32(LogType.SkuLog)
                                });
                            }
                            logList.AddRange(_logList);
                                
                            if (isSame)
                                SetToSameTask(item.s_id);//设置数据需要同步
                        }
                    }
                    else if (!(item.s_id > 0))
                    {
                        item.s_category_bailun_name = yt_category_bailun.GetFullNameByID(item.s_category_bailun_id);
                        item.s_createtime = DateTime.Now;
                        item.s_operatetype = "Add";

                        var objModel = yt_product_base.Insert(item);

                        Task.Factory.StartNew(() =>
                        {
                            var tempBase = ImageUploadServices.ImageDataToSync(objModel, true);
                            item.s_main_image = tempBase.s_main_image;
                            item.s_child_image = tempBase.s_child_image;
                            item.Update(new string[] { "s_main_image", "s_child_image" });
                        });
                        
                        if (objModel.s_id > 0)
                        {
                            result.result_code = 1;
                            result.data = CommonBaseLib.GetJsonToString(objModel);
                        }
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "sku的主键信息不能为空。";
                        return result;
                    }
                }
                if (logList.Count > 0)
                {
                    if(isBatch)
                    {
                        string[] skuIdArr = skuIds.TrimEnd(',').Split(',');
                        sql.Append(" where s_id in (@sIds)", new { sIds = skuIdArr });
                    }
                    var count = yt_product_base.PocoDb.Execute(sql);
                    if (count > 0)
                    {
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                }
                result.result_code = 1;
                //开启同步到旧表
                if (isSame)
                {
                    //DataToSameStock.InsertOrUpdateToSame();
                    //开启自动同步到环球
                    //PdmDataServices.InsertOrUpdateToSame();
                }

                
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 保存产品开发信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveProductExploit(List<yt_product_exploit> modelList, bool isSame = true, bool isBatch = false)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            try
            {
                var exIds = "";
                Sql sql = Sql.Builder;
                foreach (var item in modelList)
                {
                    List<yt_product_log> _logList = new List<yt_product_log>();
                    item.ex_updatetime = DateTime.Now;
                    if (item.ex_id > 0 && item.ex_sid > 0)
                    {
                        newSql: ;
                        var strSql = "";
                        var objBase = yt_product_base.Func_GetById(item.ex_sid);
                        var objModel = yt_product_exploit.Func_GetById(item.ex_id);
                        if (!isBatch || (isBatch && string.IsNullOrWhiteSpace(sql.SQL)))
                        {
                            var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", objBase.s_id);
                            //已上传环球SKU则不能再修改
                            if (objState.st_isupapi == 1 && objModel.ex_sku != item.ex_sku)
                            {
                                item.ex_sku = objModel.ex_sku;
                            }
                        }
                        if (isSame)
                        {
                            //修改采购仓库，如果可为发货仓同时修改该区域下的发货仓，没有则新增
                            if (item.ex_default_warecode != objModel.ex_default_warecode)
                            {
                                var wareDataList = WareDataServices.GetDefaultWareList(0, 18); //18为中国区域，采购仓只有中国采购
                                var objWare = wareDataList.FirstOrDefault(m => m.code == item.ex_default_warecode);
                                if (objWare != null)
                                {
                                    var wareTypeList = objWare.functions;
                                    var objWareType = wareTypeList.FirstOrDefault(m => m.id == 2);
                                    if (objWareType != null)
                                    {
                                        //设置该采购仓库中国区域发货仓
                                        var wareList = new List<yt_product_ware>();
                                        var myWareList = yt_product_ware.Fetch(" where pw_sid = @0 and pw_area_id = 18", item.ex_sid);
                                        var objMyWare = myWareList.FirstOrDefault(m => m.pw_ware_code == item.ex_default_warecode);
                                        if (objMyWare != null)
                                        {
                                            objMyWare.pw_isdefault = 1;
                                            objMyWare.pw_ware_code = item.ex_default_warecode;
                                            objMyWare.pw_updatename = item.ex_updatename;
                                            wareList.Add(objMyWare);
                                        }
                                        else if (objMyWare == null && !string.IsNullOrWhiteSpace(item.ex_default_warecode))
                                        {
                                            objMyWare = new yt_product_ware();
                                            objMyWare.pw_sid = item.ex_sid;
                                            objMyWare.pw_sku = item.ex_sku;
                                            objMyWare.pw_area_id = 18;
                                            objMyWare.pw_isdefault = 1;
                                            objMyWare.pw_ware_code = item.ex_default_warecode;
                                            objMyWare.pw_updatename = item.ex_updatename;
                                            wareList.Add(objMyWare);
                                        }
                                        var oldDefaultWare = myWareList.FirstOrDefault(m => m.pw_ware_code != item.ex_default_warecode && m.pw_isdefault == 1);
                                        if (oldDefaultWare != null)
                                        {
                                            oldDefaultWare.pw_isdefault = 0;
                                            oldDefaultWare.pw_updatename = item.ex_updatename;
                                            wareList.Add(oldDefaultWare);
                                        }

                                        if (wareList.Count > 0)
                                            SaveProductWare(wareList, false);
                                    }
                                }
                            }
                        }
                        var dicModel = ConvertToDictionary(objModel);
                        strSql = GetPropertyValue(item, dicModel, out paralist, out _logList);

                        if (strSql != "" || isBatch)
                        {
                            //批量修改
                            if (isBatch)
                            {
                                exIds += item.ex_id + ",";
                                if (sql.Arguments.Length == 0) 
                                {
                                    sql = Sql.Builder;
                                    sql.Append($"update yt_product_exploit set {strSql} ", paralist.ToArray());
                                }
                                else if (sql.Arguments.Length < paralist.Count)
                                {
                                    sql = Sql.Builder;
                                    goto newSql;
                                }
                            }
                            else
                                sql.Append($"update yt_product_exploit set {strSql} where ex_id = {item.ex_id};", paralist.ToArray());

                            _logList.ForEach(m =>
                            {
                                m.Operator = item.ex_updatename;
                                m.OperateTime = item.ex_updatetime.Value;
                                m.ProductId = objBase.s_id;
                                m.ProductCode = objBase.s_sku;
                                m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                                m.LogType = Convert.ToInt32(LogType.SkuLog);
                            });
                            logList.AddRange(_logList);

                            if (isSame)
                                SetToSameTask(objBase.s_id);//设置数据需要同步
                        }
                    }
                    else if (!(item.ex_id > 0))
                    {
                        var objModel = yt_product_exploit.Insert(item);
                        if (objModel.ex_id > 0)
                        {
                            //设置该采购仓库中国区域发货仓
                            var wareList = new List<yt_product_ware>();
                            var objMyWare = new yt_product_ware();
                            objMyWare.pw_sid = item.ex_sid;
                            objMyWare.pw_sku = item.ex_sku;
                            objMyWare.pw_area_id = 18;
                            objMyWare.pw_isdefault = 1;
                            objMyWare.pw_ware_code = item.ex_default_warecode;
                            objMyWare.pw_updatename = item.ex_updatename;
                            wareList.Add(objMyWare);
                            if (wareList.Count > 0)
                                SaveProductWare(wareList, false);

                            result.result_code = 1;
                            result.data = objModel.ex_id.ToString();
                        }
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "sku的主键信息不能为空。";
                        return result;
                    }
                }
                if (logList.Count > 0)
                {
                    if (isBatch)
                    {
                        string[] exIdArr = exIds.TrimEnd(',').Split(',');
                        sql.Append(" where ex_id in (@exIds)", new { exIds = exIdArr });
                    }
                    var count = yt_product_exploit.PocoDb.Execute(sql);
                    if (count > 0)
                    {
                        result.result_code = 1;
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                }
                result.result_code = 1;
                //开启同步到旧表
                //if (isSame)
                //DataToSameStock.InsertOrUpdateToSame();
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 保存产品供应商信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveProductSupplier(List<yt_product_supplier> modelList, bool isSame = true, bool isBatch = false)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            try
            {
                var spIds = "";
                Sql sql = Sql.Builder;
                foreach (var item in modelList)
                {
                    List<yt_product_log> _logList = new List<yt_product_log>();
                    item.sp_updatetime = DateTime.Now;
                    if (item.sp_id > 0 && item.sp_sid > 0)
                    {
                        newSql: ;
                        var strSql = "";
                        var isDefault = 0;
                        var objBase = yt_product_base.Func_GetById(item.sp_sid);
                        var objModel = yt_product_supplier.Func_GetById(item.sp_id);
                        //如果当前唯一供应商为空，则为默认供应商
                        var objSupRelate = yt_product_supplier_relate.Func_GetById(objModel.sp_relation_id);
                        isDefault = objSupRelate.sp_default;
                        if (!(objModel.sp_deliver_id > 0) && item.sp_deliver_id > 0)
                        {
                            objSupRelate.sp_sp_id = item.sp_deliver_id;
                            objSupRelate.Update();
                        }
                        //默认供应商报价变动时采购价同时更改
                        if (objModel.sp_price != item.sp_price && isDefault == 1)
                        {
                            ChangePriceSameToSupplier(objModel.sp_sid, item.sp_price, 2);
                        }

                        if (!isBatch || (isBatch && string.IsNullOrWhiteSpace(sql.SQL)))
                        {
                            var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", objBase.s_id);
                            //已上传环球SKU则不能再修改
                            if (objState.st_isupapi == 1 && objModel.sp_sku != item.sp_sku)
                            {
                                item.sp_sku = objModel.sp_sku;
                            }
                        }
                        var dicModel = ConvertToDictionary(objModel);
                        strSql = GetPropertyValue(item, dicModel, out paralist, out _logList);

                        if (strSql != "" || isBatch)
                        {
                            //批量修改
                            if (isBatch)
                            {
                                spIds += item.sp_id + ",";
                                if (sql.Arguments.Length == 0) 
                                {
                                    sql = Sql.Builder;
                                    sql.Append($"update yt_product_supplier set {strSql} ", paralist.ToArray());
                                }
                                else if (sql.Arguments.Length < paralist.Count)
                                {
                                    sql = Sql.Builder;
                                    goto newSql;
                                }
                            }
                            else
                                sql.Append($"update yt_product_supplier set {strSql} where sp_id = {item.sp_id};", paralist.ToArray());

                            _logList.ForEach(m =>
                            {
                                m.Operator = item.sp_updatename;
                                m.OperateTime = item.sp_updatetime.Value;
                                m.ProductId = objBase.s_id;
                                m.ProductCode = objBase.s_sku;
                                m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                                m.LogType = Convert.ToInt32(LogType.SkuLog);
                            });
                            logList.AddRange(_logList);

                            if (isSame)
                                SetToSameTask(objBase.s_id);//设置数据需要同步
                        }
                    }
                    else if (!(item.sp_id > 0))
                    {
                        var objSupRelate = yt_product_supplier_relate.FirstOrDefault(" where sp_sku_id = @0 and sp_sp_id = 0", item.sp_sid);
                        if(objSupRelate != null)
                        {
                            objSupRelate.sp_sp_id = item.sp_deliver_id;
                            objSupRelate.Update(new string[] { "sp_sp_id" });

                            var objModel = yt_product_supplier.FirstOrDefault(" where sp_relation_id = @0", objSupRelate.sp_id);
                            if(objModel != null)
                            {
                                objModel.sp_deliver_id = item.sp_deliver_id;
                                objModel.sp_deliver_name = item.sp_deliver_name;
                                objModel.sp_updatename = item.sp_updatename;
                                objModel.sp_updatetime = item.sp_updatetime;
                                objModel.Update(new string[] { "sp_deliver_id", "sp_deliver_name", "sp_updatename", "sp_updatetime" });
                            }
                            else
                            {
                                objModel = yt_product_supplier.Insert(item);
                            }

                            result.result_code = 1;
                            result.data = objModel.sp_id.ToString();
                        }
                        else
                        {
                            var objModel = yt_product_supplier.Insert(item);
                            if (objModel.sp_id > 0)
                            {
                                result.result_code = 1;
                                result.data = objModel.sp_id.ToString();
                            }

                            //如果关联表供应商不存在则新增
                            if (!(objModel.sp_relation_id > 0))
                            {
                                var objBase = yt_product_base.Func_GetById(item.sp_sid);
                                yt_product_supplier_relate objRelate = new yt_product_supplier_relate();
                                objRelate.sp_main_id = objBase.s_main_id;
                                objRelate.sp_sku_id = objBase.s_id;
                                objRelate.sp_sp_id = objModel.sp_deliver_id;
                                objRelate.sp_default = 0;
                                objRelate.Insert();

                                objModel.sp_relation_id = objRelate.sp_id;
                                objModel.sp_updatename = item.sp_updatename;
                                objModel.sp_updatetime = item.sp_updatetime;
                                objModel.Update(new string[] { "sp_relation_id", "sp_updatename", "sp_updatetime" });
                            }
                        }
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "sku的主键信息不能为空。";
                        return result;
                    }
                }
                if(logList.Count > 0)
                {
                    if (isBatch)
                    {
                        string[] spIdArr = spIds.TrimEnd(',').Split(',');
                        sql.Append(" where sp_id in (@spIds)", new { spIds = spIdArr });
                    }
                    var count = yt_product_supplier.PocoDb.Execute(sql);
                    if (count > 0)
                    {
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                }
                result.result_code = 1;
                //开启同步到旧表
                //if (isSame)
                //DataToSameStock.InsertOrUpdateToSame();
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 保存产品状态信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveProductWare(List<yt_product_ware> modelList, bool isSame = true)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            try
            {
                Sql sql = Sql.Builder;
                foreach (var item in modelList)
                {
                    List<yt_product_log> _logList = new List<yt_product_log>();
                    item.pw_updatetime = DateTime.Now;
                    if (item.pw_id > 0 && item.pw_sid > 0)
                    {
                        var objBase = yt_product_base.Func_GetById(item.pw_sid);
                        var objModel = yt_product_ware.Func_GetById(item.pw_id);
                        item.pw_createuser = objModel.pw_createuser;
                        item.pw_createtime = objModel.pw_createtime;
                        //如果修改中国发货仓，则同步对应中国采购仓
                        if (isSame)
                        {
                            if (item.pw_area_id == 18 && item.pw_isdefault == 1)
                            {
                                var exploitList = new List<yt_product_exploit>();
                                var objExploit = yt_product_exploit.FirstOrDefault(" where ex_sid = @0", item.pw_sid);
                                if(objExploit.ex_default_warecode != item.pw_ware_code)
                                {
                                    objExploit.ex_default_warecode = item.pw_ware_code;
                                    objExploit.ex_updatename = item.pw_updatename;
                                    objExploit.Update(new string[] { "ex_default_warecode", "ex_updatename" });
                                }
                            }
                        }
                        
                        var dicModel = ConvertToDictionary(objModel);
                        var strSql = GetPropertyValue(item, dicModel, out paralist, out _logList);
                        if (strSql != "")
                        {
                            sql.Append($"update yt_product_ware set {strSql} where pw_id = {item.pw_id};", paralist.ToArray());
                            _logList.ForEach(m =>
                            {
                                m.Operator = item.pw_updatename;
                                m.OperateTime = item.pw_updatetime.Value;
                                m.ProductId = objBase.s_id;
                                m.ProductCode = objBase.s_sku;
                                m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                                m.LogType = Convert.ToInt32(LogType.SkuLog);
                            });
                            logList.AddRange(_logList);
                        }
                    }
                    else if (!(item.pw_id > 0))
                    {
                        var myWareList = yt_product_ware.Fetch(" where pw_sid = @0 and pw_area_id = @1", item.pw_sid, item.pw_area_id);
                        var isExist = myWareList.FirstOrDefault(m => m.pw_ware_code == item.pw_ware_code);
                        if (isExist == null)
                        {
                            if(item.pw_isdefault == 1)
                            {
                                var oldDefaultWare = myWareList.FirstOrDefault(m => m.pw_ware_code != item.pw_ware_code && m.pw_isdefault == 1);
                                if(oldDefaultWare != null)
                                {
                                    oldDefaultWare.pw_isdefault = 0;
                                    oldDefaultWare.pw_updatename = item.pw_updatename;
                                    oldDefaultWare.Update();
                                }
                            }
                            item.pw_createtime = DateTime.Now;
                            item.pw_createuser = item.pw_updatename;
                            var objModel = yt_product_ware.Insert(item);
                            if (objModel.pw_id > 0)
                            {
                                result.result_code = 1;
                                result.data = objModel.pw_id.ToString();
                            }
                        }
                        else
                        {
                            result.result_code = 1;
                            result.data = isExist.pw_id.ToString();
                        }
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "sku的主键信息不能为空。";
                        return result;
                    }
                }
                if (logList.Count > 0)
                {
                    var count = yt_product_ware.PocoDb.Execute(sql);
                    if (count > 0)
                    {
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                }
                result.result_code = 1;
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 保存产品状态信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult SaveProductState(List<yt_product_state> modelList, bool isSame = true, bool isBatch = false)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            try
            {
                var stIds = "";
                Sql sql = Sql.Builder;
                foreach (var item in modelList)
                {
                    List<yt_product_log> _logList = new List<yt_product_log>();
                    item.st_updatetime = DateTime.Now;
                    if (item.st_id > 0 && item.st_sid > 0)
                    {
                        newSql:;
                        var strSql = "";
                        var objBase = yt_product_base.Func_GetById(item.st_sid);
                        var objModel = yt_product_state.Func_GetById(item.st_id);
                        if (!isBatch || (isBatch && string.IsNullOrWhiteSpace(sql.SQL)))
                        {
                            //已上传环球SKU则不能再修改
                            if (objModel.st_isupapi == 1 && objModel.st_sku != item.st_sku)
                            {
                                item.st_sku = objModel.st_sku;
                            }
                        }
                        var dicModel = ConvertToDictionary(objModel);
                        strSql = GetPropertyValue(item, dicModel, out paralist, out _logList);

                        if (strSql != "" || isBatch)
                        {
                            //批量修改
                            if (isBatch)
                            {
                                stIds += item.st_id + ",";
                                if (sql.Arguments.Length == 0)
                                {
                                    sql = Sql.Builder;
                                    sql.Append($"update yt_product_state set {strSql} ", paralist.ToArray());
                                }
                                else if (sql.Arguments.Length < paralist.Count)
                                {
                                    sql = Sql.Builder;
                                    goto newSql;
                                }
                            }
                            else
                                sql.Append($"update yt_product_state set {strSql} where st_id = {item.st_id};", paralist.ToArray());

                            _logList.ForEach(m =>
                            {
                                m.Operator = item.st_updatename;
                                m.OperateTime = item.st_updatetime.Value;
                                m.ProductId = objBase.s_id;
                                m.ProductCode = objBase.s_sku;
                                m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                                m.LogType = Convert.ToInt32(LogType.SkuLog);
                            });
                            logList.AddRange(_logList);

                            if (isSame)
                                SetToSameTask(objBase.s_id);//设置数据需要同步
                        }
                    }
                    else if (!(item.st_id > 0))
                    {
                        var objModel = yt_product_state.Insert(item);
                        if (objModel.st_id > 0)
                        {
                            result.result_code = 1;
                            result.data = objModel.st_id.ToString();
                        }
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "sku的主键信息不能为空。";
                        return result;
                    }
                }
                if (logList.Count > 0)
                {
                    if (isBatch)
                    {
                        string[] stIdArr = stIds.TrimEnd(',').Split(',');
                        sql.Append(" where st_id in (@stIds)", new { stIds = stIdArr });
                    }
                    var count = yt_product_state.PocoDb.Execute(sql);
                    if (count > 0)
                    {
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                }
                result.result_code = 1;
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        public static ApiResult AddProductWare(List<yt_product_ware> modelList, bool isSame = true)
        {
            ApiResult result = new ApiResult();
            List<yt_product_log> logList = new List<yt_product_log>();
            if (modelList?.Count == 0)
            {
                result.result_code = 0;
                result.result_msg = "没有需要修改的数据";
                return result;
            }
            try
            {
                var wareList = WareDataServices.GetDefaultWareList(2);
                List<object> paralist = new List<object>();
                var stIds = modelList.Select(m=>m.pw_id);
                var modelWare = modelList.FirstOrDefault();
                var objWare = wareList.FirstOrDefault(m => m.code == modelWare.pw_ware_code);
                if (objWare == null)
                {
                    result.result_code = 0;
                    result.result_msg = "不存在此仓库，请正确填写仓库编码";
                    return result;
                }
                foreach (var item in modelList)
                {
                    var objModel = yt_product_ware.Func_GetById(item.pw_id);
                    item.pw_area_id = objWare.area.id;
                    item.pw_updatetime = DateTime.Now;
                    item.Update(new string[] { "pw_ware_code", "pw_area_id", "pw_updatetime" });
                    yt_product_log _logList = new yt_product_log();
                    _logList.LogType = 2;
                    _logList.OperateContent = "发货仓库";
                    _logList.BeforeOperated = objModel.pw_ware_code;
                    _logList.AfterOperated = modelWare.pw_ware_code;
                    _logList.Operator = item.pw_updatename;
                    _logList.OperateTime = item.pw_updatetime.Value;
                    _logList.ProductId = item.pw_sid;
                    _logList.ProductCode = item.pw_sku;
                    _logList.UpdateDate = item.pw_updatetime?.ToString("yyyy-MM-dd HH:ss");
                    _logList.LogType = Convert.ToInt32(LogType.SkuLog);
                    logList.Add(_logList);
                }
                if (logList.Count > 0)
                {
                    AddProductLog(logList);
                }
                result.result_code = 1;
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 改变sku采购价同步默认供应商信息
        /// </summary>
        public static void ChangePriceSameToSupplier(int sId, decimal price,int type = 1)
        {
            if(type == 1)
            {
                var objSupRelate = yt_product_supplier_relate.FirstOrDefault(" where sp_sku_id = @0 and sp_default = 1", sId);
                var objSupplier = yt_product_supplier.FirstOrDefault(" where sp_relation_id = @0", objSupRelate.sp_id);
                objSupplier.sp_price = price;
                objSupplier.Update(new string[] { "sp_price" });
            }
            else
            {
                var objBase = yt_product_base.Func_GetById(sId);
                objBase.s_price = price;
                objBase.Update(new string[] { "s_price" });
            }
        }

        /// <summary>
        /// 增加产品日志
        /// </summary>
        public static void AddProductLog(List<yt_product_log> logList)
        {
            if(logList.Count > 1)
            {
                Task.Factory.StartNew(() =>
                {
                    foreach (var item in logList)
                    {
                        yt_product_log.Insert(item);
                    }
                });
            }
        }

        /// <summary>
        /// 更新产品库存状态
        /// </summary>
        /// <returns></returns>
        public static ApiResult UpdateProductStockState(List<DistributeProduct> stockList)
        {
            ApiResult result = new ApiResult();
            List<UpdateTable> tableList = new List<UpdateTable>();
            foreach (var item in stockList)
            {
                try
                {
                    var objExInfo = dv_exploit_info.FirstOrDefault(" where ei_sku = @0", item.sku);
                    if(objExInfo != null)
                    {
                        objExInfo.ei_stock = item.stock;
                        objExInfo.ei_updatename = "Api_System";
                        objExInfo.ei_updatetime = DateTime.Now;
                        objExInfo.Update(new string[] { "ei_stock", "ei_updatename", "ei_updatetime" });
                        var objMain = dv_product_mian_deve.FirstOrDefault(" where pd_mian_id = @0", objExInfo.ei_main_id);
                        if(objMain != null)
                        {
                            List<UpdateColumn> ucStateList = new List<UpdateColumn>();
                            List<ConditionDetail> cdnStateList = new List<ConditionDetail>();
                            var exInfoList = dv_exploit_info.Fetch(" where ei_main_id = @0", objExInfo.ei_main_id);
                            if(exInfoList.Where(m => m.ei_stock > 0).Count() > 0)
                            {
                                if(objMain.pd_enable != 2)
                                {
                                    objMain.pd_enable = 2;
                                    objMain.pd_updater = "Api_System";
                                    objMain.pd_updatedate = DateTime.Now;
                                    objMain.Update(new string[] { "pd_enable", "pd_updater", "pd_updatedate" });
                                }
                                ucStateList.Add(new UpdateColumn()
                                {
                                    key = "st_status",
                                    val = "2"
                                });
                            }
                            else if (objMain.pd_enable != 1)
                            {
                                objMain.pd_enable = 1;
                                objMain.pd_updater = "Api_System";
                                objMain.pd_updatedate = DateTime.Now;
                                objMain.Update(new string[] { "pd_enable", "pd_updater", "pd_updatedate" });
                                ucStateList.Add(new UpdateColumn()
                                {
                                    key = "st_status",
                                    val = "1"
                                });
                            }
                            if (ucStateList.Count > 0)
                            {
                                cdnStateList.Add(new ConditionDetail()
                                {
                                    key = "st_sid",
                                    val = objExInfo.ei_sid.ToString(),
                                    cdn = 1
                                });
                                UpdateTable objUpdate = new UpdateTable()
                                {
                                    table = "yt_product_state",
                                    user = "Api_System",
                                    col = ucStateList,
                                    key_value = cdnStateList
                                };
                                tableList.Add(objUpdate);
                            }
                            item.success = true;
                        }
                        else
                        {
                            item.success = false;
                            item.message = "数据异常，找不到商品信息";
                        }
                    }
                    else
                    {
                        item.success = false;
                        item.message = "数据异常，找不到exploit的信息";
                    }
                }
                catch(Exception ex)
                {
                    item.success = false;
                    item.message = $"接口错误，{ex.Message}";
                }
            }
            if (tableList.Count > 0)
            {
                Task.Factory.StartNew(() =>
                {
                    //调用公共接口
                    int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(tableList.Count / 1000.00)));
                    for (int i = 0; i < pageCount; i++)
                    {
                        var tempTableList = tableList.Skip(i * 1000).Take(1000).ToList();
                        string dataJson = CommonBaseLib.GetJsonToString(tempTableList);

                        ApiEntrance objPro = new ApiEntrance();
                        objPro.code = "BaiLunSku";
                        objPro.key = "set.product.base";
                        objPro.data = dataJson;
                        ApiResult ar = ApiDataManage.ApiPost(objPro);
                    }
                });
            }
            result.result_code = 1;
            result.data = CommonBaseLib.GetJsonToString(stockList);
            return result;
        }

        /// <summary>
        /// 设置数据需要同步
        /// </summary>
        /// <param name="id"></param>
        public static void SetToSameTask(int id)
        {
            var objState = yt_product_state.FirstOrDefault(" where st_sid = @0", id);
            //同步到旧表标识
            if (objState != null && objState.st_lastupdate_state != 2)
            {
                objState.st_lastupdate_state = 0;
                objState.st_toold = 0;
                objState.Update(new string[] { "st_lastupdate_state", "st_toold" });
            }
        }

        #endregion

        #region 删除资料执行模块
        /// <summary>
        /// 保存产品基本信息
        /// </summary>
        /// <returns></returns>
        public static ApiResult DeleteProductBase(List<yt_product_base> modelList)
        {
            ApiResult result = new ApiResult();
            List<object> paralist = new List<object>();
            List<yt_product_log> logList = new List<yt_product_log>();
            try
            {
                foreach (var item in modelList)
                {
                    if (item.s_id > 0)
                    {
                        logList.Add(new yt_product_log()
                        {
                            OperateContent = "操作类型",
                            BeforeOperated = item.s_operatetype,
                            AfterOperated = "Delete"
                        });

                        item.s_updatetime = DateTime.Now;
                        item.s_operatetype = "Delete";
                        item.Update(new string[] { "s_updatename", "s_updatetime", "s_operatetype" });

                        result.result_code = 1;                        
                        logList.ForEach(m =>
                        {
                            m.Operator = item.s_updatename;
                            m.OperateTime = item.s_updatetime.Value;
                            m.ProductId = item.s_id;
                            m.ProductCode = item.s_sku;
                            m.UpdateDate = m.OperateTime.ToString("yyyy-MM-dd");
                            m.LogType = Convert.ToInt32(LogType.SkuLog);
                        });
                        //批量插入日志记录
                        AddProductLog(logList);
                    }
                    else
                    {
                        result.result_code = 600;
                        result.result_msg = "sku的主键信息不能为空。";
                    }
                }
            }
            catch (Exception ex)
            {
                result.result_code = 500;
                result.result_msg = "操作出错！原因：" + ex.Message;
            }
            return result;
        }
        #endregion

        #region 公共反射字段处理模块
        /// <summary>
        /// 公共获取字段属性
        /// </summary>
        /// <param name="objNew"></param>
        /// <param name="dic"></param>
        /// <param name="paralist"></param>
        /// <returns></returns>
        public static string GetPropertyValue(object objNew, Dictionary<string, string> dic, out List<object> paralist, out List<yt_product_log> logList, int type = 1)
        {
            string strSql = "";
            paralist = new List<object>();
            logList = new List<yt_product_log>();
            if (objNew != null)
            {
                int num = 0;
                Type t = objNew.GetType(); //获得该类的Type  
                //再用Type.GetProperties获得PropertyInfo[],然后就可以用foreach 遍历了  
                foreach (PropertyInfo pi in t.GetProperties())
                {
                    var name = pi.Name; //获得属性的名字
                    var value = Convert.ToString(pi.GetValue(objNew, null)); //用pi.GetValue获得值
                    if (dic.ContainsKey(name))
                    {
                        dic[name] = GetEntityForProperty(pi, dic[name]);
                        //获取描述名称
                        var objDes = pi.GetCustomAttributes(typeof(DescriptionAttribute), true);
                        var describe = ((DescriptionAttribute)objDes[0]).Description;

                        //组合生成动态更新语句，改什么更新什么
                        string tName = pi.PropertyType.FullName;
                        if (tName.Contains("System.Int"))
                            value = string.IsNullOrWhiteSpace(value) ? "0" : value;
                        else if (tName.Contains("System.Decimal"))
                            value = string.Format("{0:0.####}", Convert.ToDecimal(string.IsNullOrWhiteSpace(value) ? "0" : value));
                        else if (tName.Contains("System.SByte"))
                            value = string.Format("{0:0.####}", Convert.ToSByte(string.IsNullOrWhiteSpace(value) ? "0" : value));

                        if (dic[name] != value)
                        {
                            object objPara = value;
                            paralist.Add(objPara);
                            strSql += string.Format("{0}=@{1},", name, num);

                            if(VerifyTheFieldColumn.VerifyTheFieldLog(name))
                            {
                                if (type == 1)
                                {
                                    logList.Add(new yt_product_log()
                                    {
                                        OperateContent = describe,
                                        BeforeOperated = dic[name],
                                        AfterOperated = value
                                    });
                                }
                                else
                                {
                                    logList.Add(new yt_product_log()
                                    {
                                        OperateContent = describe,
                                        BeforeOperated = value,
                                        AfterOperated = dic[name]
                                    });
                                }
                            }

                            num++;
                        }
                    }
                }
                strSql = strSql.TrimEnd(',');
            }
            return strSql;
        }

        /// <summary>
        /// 实体转换赋值
        /// </summary>
        /// <returns></returns>
        public static T ExChangeToEntity<T>(T objModel, Dictionary<string, string> dic)
        {
            Type t = objModel.GetType(); //获得该类的Type
            //根据新实体遍历赋值
            foreach (PropertyInfo pi in t.GetProperties())
            {
                var name = pi.Name; //获得属性的名字
                var value = Convert.ToString(pi.GetValue(objModel, null)); //用pi.GetValue获得值
                if(dic.ContainsKey(name))
                {
                    string tName = pi.PropertyType.FullName;
                    if (tName.Contains("System.Int32"))
                        pi.SetValue(objModel, Convert.ToInt32(dic[name]));
                    else if (tName.Contains("System.Int64"))
                        pi.SetValue(objModel, Convert.ToInt64(dic[name]));
                    else if (tName.Contains("System.Boolean"))
                        pi.SetValue(objModel, Convert.ToBoolean(dic[name]));
                    else if (tName.Contains("System.Decimal"))
                        pi.SetValue(objModel, Convert.ToDecimal(dic[name]));
                    else if (tName.Contains("System.SByte"))
                        pi.SetValue(objModel, Convert.ToSByte(dic[name]));
                    else if (tName.Contains("System.DateTime"))
                        pi.SetValue(objModel, Convert.ToDateTime(dic[name]));
                    else
                        pi.SetValue(objModel, dic[name]);
                }
            }

            return objModel;
        }


        /// <summary>
        /// 转换对应类型再转回字符返回
        /// </summary>
        /// <param name="pi"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public static string GetEntityForProperty(PropertyInfo pi, string value)
        {
            string tName = pi.PropertyType.FullName;
            if (tName.Contains("System.Int"))
                value = string.IsNullOrWhiteSpace(value) ? "0" : value;
            else if (tName.Contains("System.Decimal"))
                value = string.Format("{0:0.####}", Convert.ToDecimal(string.IsNullOrWhiteSpace(value) ? "0" : value));
            else if (tName.Contains("System.SByte"))
                value = string.Format("{0:0.####}", Convert.ToSByte(string.IsNullOrWhiteSpace(value) ? "0" : value));

            return value;
        }

        /// <summary>
        /// 实体转键值对
        /// </summary>
        /// <typeparam name="T">泛型</typeparam>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static Dictionary<string, string> ConvertToDictionary<T>(T obj)
        {
            //初始化定义一个键值对，注意最后的括号
            Dictionary<string, string> dic = new Dictionary<string, string>();
            //返回当前 Type 的所有公共属性Property集合
            PropertyInfo[] props = typeof(T).GetProperties();
            foreach (PropertyInfo p in props)
            {
                var property = obj.GetType().GetProperty(p.Name);//获取property对象
                string value = p.GetValue(obj) == null ? "" : p.GetValue(obj).ToString();//获取属性值
                dic.Add(p.Name, value);
            }
            return dic;
        }

        /// <summary>
        /// 批量修改转换赋值
        /// </summary>
        /// <returns></returns>
        public static T ExChangeBatchToEntity<T>(T objModel, Dictionary<string, string> dic)
        {
            Type t = objModel.GetType(); //获得该类的Type
            //根据新实体遍历赋值
            foreach (PropertyInfo pi in t.GetProperties())
            {
                var name = pi.Name; //获得属性的名字
                var value = Convert.ToString(pi.GetValue(objModel, null)); //用pi.GetValue获得值
                if (dic.ContainsKey(name))
                {
                    if(!string.IsNullOrWhiteSpace(dic[name]))
                    {
                        string tName = pi.PropertyType.FullName;
                        if (tName.Contains("System.String") && !string.IsNullOrWhiteSpace(dic[name]))
                            pi.SetValue(objModel, dic[name]);
                        else if(tName.Contains("System.Int32") && Convert.ToInt32(dic[name]) > 0)
                            pi.SetValue(objModel, Convert.ToInt32(dic[name]));
                        else if (tName.Contains("System.Int64") && Convert.ToInt64(dic[name]) > 0)
                            pi.SetValue(objModel, Convert.ToInt64(dic[name]));
                        else if (tName.Contains("System.Decimal") && Convert.ToDecimal(dic[name]) > 0)
                            pi.SetValue(objModel, Convert.ToDecimal(dic[name]));
                        else if (tName.Contains("System.SByte") && Convert.ToSByte(dic[name]) > 0)
                            pi.SetValue(objModel, Convert.ToSByte(dic[name]));
                    }
                }
            }

            return objModel;
        }

        /// <summary>
        /// 批量修改验证是否空
        /// </summary>
        /// <param name="objNew"></param>
        /// <param name="dic"></param>
        /// <param name="paralist"></param>
        /// <returns></returns>
        public static bool GetBatchPropertyValue(object objNew)
        {
            var flag = false;
            if (objNew != null)
            {
                Type t = objNew.GetType(); //获得该类的Type  
                //再用Type.GetProperties获得PropertyInfo[],然后就可以用foreach 遍历了  
                foreach (PropertyInfo pi in t.GetProperties())
                {
                    var name = pi.Name; //获得属性的名字
                    var value = Convert.ToString(pi.GetValue(objNew, null)); //用pi.GetValue获得值

                    //组合生成动态更新语句，改什么更新什么
                    if (!string.IsNullOrWhiteSpace(value))
                    {
                        //数字修改也必须大于0
                        string tName = pi.PropertyType.FullName;
                        if (tName.Contains("System.Int32"))
                        {
                            if (!(Convert.ToInt32(value) > 0))
                                continue;
                        }
                        else if (tName.Contains("System.Int64"))
                        {
                            if (!(Convert.ToInt64(value) > 0))
                                continue;
                        }
                        else if (tName.Contains("System.Decimal"))
                        {
                            if (!(Convert.ToDecimal(value) > 0))
                                continue;
                        }
                        else if (tName.Contains("System.SByte"))
                        {
                            if (!(Convert.ToSByte(value) > 0))
                                continue;
                        }

                        flag = true;
                    }
                }
            }
            return flag;
        }

        #endregion

        #region 枚举类型
        /// <summary>
        /// 日志类型
        /// </summary>
        public enum LogType
        {
            Unknow = 0,
            ProductLog = 1,
            SkuLog = 2
        }
        #endregion
    }
}
