﻿using ApiControl;
using DbConn;
using PetaPoco;
using PetaPoco.Custom.ProductData;
using PetaPoco.Custom.SkuMap;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static API.Services.ProductManageServices.ProductServices;

namespace API.Services.ProductManageServices
{
    public class ProductGroupServices
    {
        public static ApiResult AddProductGroup(List<yt_product_base> baseList)
        {
            ApiResult result = new ApiResult();

            //验证数据，添加的SKU中不能存在组合SKU
            var isGroup = baseList.Where(m => m.s_isfinish == 5).ToList().Count;
            if(isGroup > 0)
            {
                result = ApiDataManage.CreateApiResult(400);
                result.result_msg += "不允许添加组合SKU";
                return result;
            }

            //验证是否已存在一样的组合SKU，已存在则沿用之前的
            Sql sql = Sql.Builder;
            sql.Append(" select * from (");
            sql.Append(" select id,stock_id as groId,stock_sku as groSku,GROUP_CONCAT(CONCAT(sku,'*',count) order by sku_id SEPARATOR ',') as sign,COUNT(sku) as totalCount from ( ");
            sql.Append(" select id,stock_id,stock_sku,sku_id,sku,count from yt_product_group ");
            sql.Append(" where stock_sku in (select stock_sku from yt_product_group where sku = @0)) as a ", baseList.FirstOrDefault().s_sku);
            sql.Append(" group by stock_sku) as b");
            sql.Append(" where totalCount = @0", baseList.Count);
            var groupWhere = DbConnDB.Record<GroupWhere>.Fetch(sql).ToList();
            if(groupWhere.Count > 0)
            {
                string sign = "";
                foreach(var myBase in baseList.OrderBy(m => m.s_id))
                {
                    sign += string.Format("{0}*{1},",myBase.s_sku, myBase.s_charger_spec.Value);   //s_charger_spec临时借用为数量
                }
                sign = sign.TrimEnd(',');
                var isExistGroup = groupWhere.FirstOrDefault(m => m.sign == sign);
                if(isExistGroup != null)
                {
                    var oldGroup = yt_product_base.Func_GetById(isExistGroup.groId);
                    if(oldGroup != null)
                    {
                        List<yt_product_base> oldList = new List<yt_product_base>();
                        oldList.Add(oldGroup);
                        result.result_code = 1;
                        result.data = CommonBaseLib.EncodeAndJson(oldList);
                        return result;
                    }
                }
            }

            using (Database DB = DbConnDB.GetInstance())
            {
                using (var tx = DB.GetTransaction())
                {
                    try
                    {
                        #region 计算可组合所得的数据
                        decimal totalWeight = 0;
                        decimal totalPrice = 0;
                        string totalProductSize = "0,0,0";
                        string totalPackingSize = "0,0,0";
                        decimal totalPackingPrice = 0;
                        decimal totalPackingWeight = 0;
                        string pakName = "";
                        string mainUrl = "";
                        string urlList = "";
                        int cateId = baseList.FirstOrDefault().s_category_id.Value;
                        string cateName = baseList.FirstOrDefault().s_category_name;
                        int cateBailunId = baseList.FirstOrDefault().s_category_bailun_id;
                        string cateBailunName = baseList.FirstOrDefault().s_category_bailun_name;
                        string cTitle = baseList.FirstOrDefault().s_ctitle;
                        string eTitle = baseList.FirstOrDefault().s_etitle;
                        string LoginName = baseList.FirstOrDefault().s_updatename;
                        List<AllProductInfo> productList = new List<AllProductInfo>();

                        foreach (var item in baseList)
                        {
                            var count = item.s_charger_spec.Value;
                            totalWeight += item.s_weight.Value * count;
                            totalPrice += item.s_price.Value * count;

                            //产品尺寸相加
                            string[] proSizeArr = totalProductSize.Split(',');
                            string[] proArr = item.s_product_size.Split(',');
                            proSizeArr[0] = ((Convert.ToDecimal(proSizeArr[0]) + Convert.ToDecimal(proArr[0])) * count).ToString();
                            proSizeArr[1] = ((Convert.ToDecimal(proSizeArr[1]) + Convert.ToDecimal(proArr[1])) * count).ToString();
                            proSizeArr[2] = ((Convert.ToDecimal(proSizeArr[2]) + Convert.ToDecimal(proArr[2])) * count).ToString();
                            totalProductSize = string.Format("{0},{1},{2}", proSizeArr[0], proSizeArr[1], proSizeArr[2]);

                            //包装尺寸相加
                            string[] pakSizeArr = totalPackingSize.Split(',');
                            string[] pakArr = item.s_packing_size.Split(',');
                            pakSizeArr[0] = ((Convert.ToDecimal(pakSizeArr[0]) + Convert.ToDecimal(pakArr[0])) * count).ToString();
                            pakSizeArr[1] = ((Convert.ToDecimal(pakSizeArr[1]) + Convert.ToDecimal(pakArr[1])) * count).ToString();
                            pakSizeArr[2] = ((Convert.ToDecimal(pakSizeArr[2]) + Convert.ToDecimal(pakArr[2])) * count).ToString();
                            totalPackingSize = string.Format("{0},{1},{2}", pakSizeArr[0], pakSizeArr[1], pakSizeArr[2]);

                            totalPackingPrice += item.s_packing_price.Value * count;
                            totalPackingWeight += item.s_packing_weight.Value * count;

                            //默认取第一个包装名称
                            if (string.IsNullOrWhiteSpace(pakName))
                                pakName = item.s_packing_name;

                            //获取图片集合
                            if (string.IsNullOrWhiteSpace(mainUrl) && (item.s_main_image.Contains(".png") || item.s_main_image.Contains(".jpg")))
                            {
                                mainUrl = item.s_main_image;
                            }

                            if(urlList.Length < 2000)
                                urlList += item.s_child_image.TrimEnd(',') + ",";
                        }
                        #endregion

                        #region 产品信息总表
                        var objMain = new dv_product_mian_deve();
                        objMain.pd_args = "{}";//json格式
                        objMain.pd_delvy = "";//发货信息
                        objMain.pd_bak = "";//退货信息
                        objMain.pd_ship_to = "";//支持发货的地区
                        objMain.pd_cate_id = "";//类目id以：隔开
                        objMain.pd_default_ship_price = "";//美国默认物流默认运费
                        objMain.pd_pays = "";//支持的支付方式
                        objMain.pd_iframe_url = "";//详细地址
                        objMain.pd_uid = "";
                        objMain.pd_suid = LoginName;
                        objMain.pd_zuid = "";
                        objMain.pd_source = "group";
                        objMain.pd_coin = "";
                        objMain.pd_colorname = "color";
                        objMain.pd_sizename = "";
                        objMain.pd_sizename1 = "";
                        objMain.pd_sizename2 = "";
                        objMain.pd_type = cateId;
                        objMain.pd_pcid = 0;
                        objMain.pd_sec_cate = 0;
                        objMain.pd_thr_cate = 0;

                        objMain.pd_state = -2;
                        objMain.pd_itemid = "";
                        objMain.pd_name = "";
                        objMain.pd_country = "";
                        objMain.pd_sku = ProductDataServices.GenerateCode();
                        objMain.pd_price = Convert.ToDecimal(0);
                        objMain.pd_monthsales = Convert.ToDecimal(0);
                        objMain.pd_daysales = Convert.ToDecimal(0);
                        objMain.pd_sendcountry = "";
                        objMain.pd_sendcompany = "";
                        objMain.pd_sendprice = Convert.ToDecimal(0);
                        objMain.pd_link = "";
                        objMain.pd_mainimgurl = mainUrl;
                        objMain.pd_remark = "";
                        objMain.pd_createtime = DateTime.Now;
                        objMain.pd_sendcode = "";
                        objMain.pd_brand = "";
                        objMain.pd_chinaname = "";
                        objMain.pd_cost = 0;
                        objMain.pd_china_price = 0;
                        objMain.pd_china_send_price = 0;
                        objMain.pd_amazon_price = 0;
                        objMain.pd_amazon_send_price = 0;
                        objMain.pd_amazon_min_price = 0;
                        objMain.pd_amazon_min_send_price = 0;
                        objMain.pd_bug_box_price = 0;
                        objMain.pd_bug_box_send_price = 0;
                        objMain.pd_amzon_weght = 0;
                        objMain.pd_china_gross_price = 0;
                        objMain.pd_amaon_gross_price = 0;
                        objMain.pd_min_gross_price = 0;
                        objMain.pd_ranking = 0;
                        objMain.pd_dt_id = 0;
                        //速卖通
                        objMain.pd_max_price = 0;
                        objMain.pd_min_price = 0;
                        objMain.pd_avg_price = 0;
                        objMain.pd_weight = totalWeight;
                        objMain.pd_tensales = 0;
                        objMain.pd_all_sales = 0;
                        objMain.pd_sendidea = "";
                        objMain.pd_pushtime = Convert.ToDateTime("1999-01-01");
                        objMain.pd_creater = LoginName;
                        objMain.pd_createdate = DateTime.Now;
                        objMain.pd_updater = LoginName;
                        objMain.pd_updatedate = DateTime.Now;
                        objMain.pd_operationrtype = "ADD";
                        objMain.Insert();

                        string goodsCode = objMain.pd_sku;
                        string productCode = ProductDataServices.CreateProductCode(objMain.pd_sku, 0);//生成产品编码

                        var objPro = new AllProductInfo();
                        objPro.s_main_id = objMain.pd_mian_id;
                        objPro.s_goods_code = goodsCode;
                        objPro.s_product_code = productCode;
                        objPro.s_product = goodsCode;
                        objPro.s_sku = productCode;
                        objPro.s_ctitle = cTitle;
                        objPro.s_etitle = eTitle;
                        objPro.s_ctitle_alias = cTitle;
                        objPro.s_category_id = cateId;
                        objPro.s_category_name = cateName;
                        objPro.s_category_bailun_id = cateBailunId;
                        objPro.s_category_bailun_name = cateBailunName;
                        objPro.s_skutype = 0;
                        objPro.s_isfinish = 5;
                        objPro.s_weight = totalWeight;
                        objPro.s_unit = "";
                        objPro.s_price = totalPrice;
                        objPro.s_currency = "";
                        objPro.s_main_image = mainUrl;
                        objPro.s_child_image = urlList;
                        objPro.s_color = "color";
                        objPro.s_size = "";
                        objPro.s_size1 = "";
                        objPro.s_size2 = "";
                        objPro.s_product_size = totalProductSize;
                        objPro.s_packing_size = totalPackingSize;
                        objPro.s_packing_name = pakName;
                        objPro.s_packing_price = totalPackingPrice;
                        objPro.s_packing_weight = totalPackingWeight;
                        objPro.s_packing_req = "";
                        objPro.s_packing_skuid = 0;
                        objPro.s_charger_spec = 1;
                        objPro.s_product_character = "1";
                        objPro.s_bailun_character = "";
                        objPro.s_cpeihuo = "";
                        objPro.s_epeihuo = "";
                        objPro.s_cbaoguan = "";
                        objPro.s_ebaoguan = "";
                        objPro.s_hscode = "";
                        objPro.s_content = "";
                        objPro.s_remarks = "";
                        objPro.s_developtime = DateTime.Now;
                        objPro.s_createname = LoginName;
                        objPro.s_createtime = DateTime.Now;
                        objPro.s_updatename = LoginName;
                        objPro.s_updatetime = DateTime.Now;
                        objPro.s_operatetype = "Add";

                        objPro.ex_main_id = objMain.pd_mian_id;
                        objPro.ex_sid = 0;
                        objPro.ex_sku = "";
                        objPro.ex_examid = 0;
                        objPro.ex_shopname = "";
                        objPro.ex_bussiness_id = 0;
                        objPro.ex_bussiness_name = "";
                        objPro.ex_buyer = 0;
                        objPro.ex_buyer_name = "";
                        objPro.ex_supplier_id = 0;
                        objPro.ex_sales_price = 0;
                        objPro.ex_maxlirun = 0;
                        objPro.ex_maxlirunlv = 0;
                        objPro.ex_default_warecode = "";
                        objPro.ex_label_req = "";
                        objPro.ex_zhijian_type = 0;
                        objPro.ex_testhour = 0;
                        objPro.ex_zhijian_req = "";
                        objPro.ex_zhijian_desc = "";
                        objPro.ex_source = 0;
                        objPro.ex_procestatus = 911;
                        objPro.ex_is_hesuan = 0;
                        objPro.ex_enable = 0;
                        objPro.ex_zlyfinish = 0;
                        objPro.ex_updatename = LoginName;
                        objPro.ex_updatetime = DateTime.Now;

                        objPro.st_main_id = objMain.pd_mian_id;
                        objPro.st_sid = 0;
                        objPro.st_sku = "";
                        objPro.st_status = 2;
                        objPro.st_isbuy = 1;
                        objPro.st_distribute = 0;
                        objPro.st_isupapi = 0;
                        objPro.st_lastupdate_state = 0;
                        objPro.st_reason = "";
                        objPro.st_toold = 0;
                        objPro.st_updatename = LoginName;
                        objPro.st_updatetime = DateTime.Now;

                        SupplierInfo objSup = new SupplierInfo();
                        objSup.sp_sp_id = 0;
                        objSup.sp_default = 1;
                        objSup.sp_main_id = objMain.pd_mian_id;
                        objSup.sp_sid = 0;
                        objSup.sp_sku = "";

                        objSup.sp_enquiry_id = 0;
                        objSup.sp_enquiry_name = "";
                        objSup.sp_deliver_id = 0;
                        objSup.sp_deliver_name = "";
                        objSup.sp_link = "";
                        objSup.sp_delivery = 0;
                        objSup.sp_moq = 0;
                        objSup.sp_internal_moq = 0;
                        objSup.sp_have_stall = 0;
                        objSup.sp_take_address = "";
                        objSup.sp_istake_goods = 0;
                        objSup.sp_remark = "";
                        objSup.sp_updatename = LoginName;
                        objSup.sp_updatetime = DateTime.Now;
                        objPro.spList = new List<SupplierInfo>();
                        objPro.spList.Add(objSup);

                        productList.Add(objPro);
                        #endregion

                        result = ProductServices.SaveAllProduct(productList);
                        if(result.result_code == 1)
                        {
                            var objAllPro = CommonBaseLib.DecodeAndObject<List<yt_product_base>>(result.data).FirstOrDefault();
                            //根据增加的SKU绑定组合SKU的关联信息
                            foreach (var entity in baseList)
                            {
                                var model = new yt_product_group();
                                model.stock_id = objAllPro.s_id;
                                model.stock_sku = objAllPro.s_sku;
                                model.sku_id = entity.s_id;
                                model.sku = entity.s_sku;
                                model.count = entity.s_charger_spec.Value == 0 ? 1 : entity.s_charger_spec.Value;  //传入的数量，借用字段
                                model.createuser = LoginName;
                                model.createtime = DateTime.Now;
                                model.opertertype = "Add";
                                model.Insert();
                            }
                            tx.Complete();
                        }
                        else
                        {
                            tx.Dispose();
                        }
                    }
                    catch (Exception ex)
                    {
                        tx.Dispose();
                        result.result_code = 500;
                        result.result_msg = ex.Message;
                    }
                }
            }
            return result;
        }
    }
}
