﻿using ApiControl;
using DbConn;
using System;
using System.Web.Http;

namespace WebApi.Areas.ProductManage.Controllers
{
    /// <summary>
    /// Api入口控制中心
    /// </summary>
    [RoutePrefix("api/CateData")]
    public class CategoryController : ApiController
    {
        /// <summary>
        /// 获取所有分类信息
        /// </summary>
        /// <returns></returns>
        [Route("GetAllCategoryList")]
        public ApiResult GetAllCategoryList(string sign, string appId, int level = 0)
        {
            DataStr ds = new DataStr()
            {
                sign = sign,
                appId = appId,
            };
            ApiEntrance model = new ApiEntrance();
            model.code = appId;
            model.data = $"{level}";
            ds.data = CommonBaseLib.EncodeAndJson(model);

            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = yt_category_new.GetAllListFromCache(level);
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 获取所有分类信息
        /// </summary>
        /// <returns></returns>
        [Route("GetLevelCategoryList")]
        public ApiResult GetLevelCategoryList(string sign, string appId, int categoryId, string type)
        {
            DataStr ds = new DataStr()
            {
                sign = sign,
                appId = appId,
            };
            ApiEntrance model = new ApiEntrance();
            model.code = appId;
            model.data = $"{categoryId},{type}";
            ds.data = CommonBaseLib.EncodeAndJson(model);

            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = yt_category_new.GetList(categoryId, type);
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 获取所有分类信息
        /// </summary>
        /// <returns></returns>
        [Route("GetFullNameByID")]
        public ApiResult GetFullNameByID(string sign, string appId, int categoryId, string type = "en")
        {
            DataStr ds = new DataStr()
            {
                sign = sign,
                appId = appId,
            };
            ApiEntrance model = new ApiEntrance();
            model.code = appId;
            model.data = $"{categoryId},{type}";
            ds.data = CommonBaseLib.EncodeAndJson(model);

            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var cateStr = yt_category_new.GetFullNameByID(categoryId, type);
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.UrlToEncode(cateStr);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 获取所有包含自己的所有父级分类
        /// </summary>
        /// <returns></returns>
        [Route("GetMyParentCategories")]
        public ApiResult GetMyParentCategories(string sign, string appId, int categoryId)
        {
            DataStr ds = new DataStr()
            {
                sign = sign,
                appId = appId,
            };
            ApiEntrance model = new ApiEntrance();
            model.code = appId;
            model.data = $"{categoryId}";
            ds.data = CommonBaseLib.EncodeAndJson(model);

            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = yt_category_new.GetMyParentCategories(categoryId);
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }

        /// <summary>
        /// 获取最底层所有分类信息
        /// </summary>
        /// <returns></returns>
        [Route("GetAllBottomCategoryList")]
        public ApiResult GetAllBottomCategoryList(string sign, string appId)
        {
            DataStr ds = new DataStr()
            {
                sign = sign,
                appId = appId,
            };
            ApiEntrance model = new ApiEntrance();
            model.code = appId;
            model.data = "";
            ds.data = CommonBaseLib.EncodeAndJson(model);

            ApiResult result = new ApiResult();
            try
            {
                ApiCompare pare = ApiDataManage.GetSignCompare(ds);
                if (pare.state)
                {
                    var modelList = yt_category_new.GetBottomCategoriesUrl();
                    result = ApiDataManage.CreateApiResult(1);
                    result.data = CommonBaseLib.EncodeAndJson(modelList);
                }
                else
                {
                    result = pare.result;
                }
            }
            catch (Exception ex)
            {
                result = ApiDataManage.CreateApiResult(500);
                result.result_msg = ex.Message;
            }
            return result;
        }
    }
}