﻿using Bailun.Cache;
using BailunRedis.ProductInfo;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Petapoco.Custom;
using Petapoco.Custom.ProductData;

namespace DbConn
{
    public partial class yt_category_new : DbConnDB.Record<yt_category_new>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="queryJson">查询参数</param>
        /// <returns>返回列表</returns>
        public static List<CategoryDto> GetList(int categoryId, string type)
        {
            try
            {
                var path = ",";
                List<yt_category_new> listTemp = new List<yt_category_new>();
                List<CategoryDto> list = new List<CategoryDto>();
                var categories = GetAllListFromCache();
                if (type == "bottom")
                {
                    categories = categories.Where(m => m.C_PARENTID == categoryId).ToList();
                }
                else if (type == "top")
                {
                    categories = categories.Where(m => m.C_ID == categoryId).ToList();
                    //遍历获取父级路径
                    var level = 99;
                    var cId = categoryId;
                    path = "," + categoryId.ToString();
                    while (level != 1)
                    {
                        var tempObj = GetAllListFromCache().FirstOrDefault(m => m.C_ID == cId);
                        if (tempObj != null)
                        {
                            level = tempObj.C_LEVEL;
                            cId = tempObj.C_PARENTID;
                            path = "," + tempObj.C_PARENTID.ToString() + path;
                        }
                        else
                            break;
                    }
                    path = path.TrimStart(',');
                }
                listTemp = categories;

                //重新装载实体模型
                if (listTemp.Count > 0)
                {
                    foreach (var model in listTemp)
                    {
                        CategoryDto obj = new CategoryDto();
                        obj.c_id = model.C_ID;
                        obj.c_parentid = model.C_PARENTID;
                        obj.c_name = $"{model.C_CNAME}{model.C_NAME}({model.C_ID})";
                        obj.path = path;
                        list.Add(obj);
                    }
                }

                return list;
            }
            catch (Exception ex)
            {
                return new List<CategoryDto>();
            }
        }

        /// <summary>
        /// 从缓存获取所有分类
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_new> GetAllListFromCache(int level = 0)
        {
            var _list = RedisCacheService.GetList(CacheKey.NewProductCategories, "C_ID", GetAllList).OrderBy(m => m.C_NAME).ToList();
            if(level > 0)
                _list = _list.Where(m => m.C_LEVEL <= level).ToList();
            return _list;
        }

        /// <summary>
        /// 从缓存获取所有分类
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_new> GetAllList()
        {
            var _list = repo.Fetch<yt_category_new>("").OrderBy(m => m.C_NAME).ToList();
            return _list;
        }

        /// <summary>
        /// 获取分类全名称
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static string GetFullNameByID(int categoryId, string type = "en")
        {
            string cateName = "";
            if (categoryId == 0) return "";
            var result = new List<yt_category_new>();
            var categories = yt_category_new.GetAllListFromCache();
            var category = categories.FirstOrDefault(m => m.C_ID == categoryId);
            if (category == null || category.C_ID <= 0) return "";
            string pName = "";
            if (category.C_PARENTID >= 1)
            {
                pName = GetFullNameByID(category.C_PARENTID, type);
            }
            if (pName != "")
                pName = pName + " -> ";

            if(type == "cn")
                cateName = pName + category.C_CNAME;
            else
                cateName = pName + category.C_NAME;

            return cateName;
        }

        /// <summary>
        /// 获取分类全名称根据列表
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static string GetFullNameByList(List<yt_category_new> cateList,int level = 1, string type = "en")
        {
            string cateName = "";
            var category = cateList.FirstOrDefault(m => m.C_LEVEL == level);
            if (category == null) return "";
            string pName = "";
            var objChild = cateList.FirstOrDefault(m => m.C_PARENTID == category.C_ID);
            if (objChild != null)
            {
                level++;
                pName = GetFullNameByList(cateList, level);
            }
            if (pName != "")
                pName = " -> " + pName;

            if (type == "cn")
                cateName = category.C_CNAME + pName;
            else
                cateName = category.C_NAME + pName;

            return cateName;
        }

        /// <summary>
        /// 获取所有包含自己的所有父级分类
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static List<yt_category_new> GetMyParentCategories(int categoryId)
        {
            if (categoryId == 0) return null;
            var result = new List<yt_category_new>();
            var categories = GetAllListFromCache();
            var category = categories.FirstOrDefault(m => m.C_ID == categoryId);
            result.Add(category);
            if (category == null) throw new Exception($"不存在分类编号为：{categoryId}的产品分类");
            while (category != null && category.C_PARENTID > 0)
            {
                category = categories.FirstOrDefault(m => m.C_ID == category.C_PARENTID);
                if (category != null)
                    result.Add(category);
            }
            return result;
        }

        /// <summary>
        /// 获取最底层分类
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_new> GetBottomCategoriesUrl()
        {
            var _list = RedisCacheService.GetList(CacheKey.NewBottomCategories, "C_ID", GetBottomUrlList).OrderBy(m => m.C_NAME).ToList();
            return _list;
        }

        /// <summary>
        /// 获取最底层分类获取方法
        /// </summary>
        /// <returns></returns>
        private static List<yt_category_new> GetBottomUrlList()
        {
            var _list = GetBottomList();
            foreach (var objCate in _list)
            {
                objCate.C_NAME = GetFullNameByID(objCate.C_ID);
            }
            return _list;
        }

        /// <summary>
        /// 获取最底层分类
        /// </summary>
        /// <returns></returns>
        private static List<yt_category_new> GetBottomList()
        {
            var allList = GetAllListFromCache();
            var result = allList.Where(m => allList.All(k => k.C_PARENTID != m.C_ID)).ToList();

            return result;
        }
    }
}
