﻿using Bailun.Cache;
using BailunRedis.ProductInfo;
using DbConn;
using Petapoco.Custom.ProductData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DbConn
{
    public partial class yt_category_bailun : DbConnDB.Record<yt_category_bailun>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="queryJson">查询参数</param>
        /// <returns>返回列表</returns>
        public static List<BailunCategoryDto> GetList(int categoryId, string type)
        {
            try
            {
                var path = ",";
                List<yt_category_bailun> listTemp = new List<yt_category_bailun>();
                List<BailunCategoryDto> list = new List<BailunCategoryDto>();
                var categories = GetAllListFromCache();
                if (type == "bottom")
                {
                    categories = categories.Where(m => m.c_parentid == categoryId).ToList();
                }
                else if (type == "top")
                {
                    categories = categories.Where(m => m.c_id == categoryId).ToList();
                    //遍历获取父级路径
                    var level = 99;
                    var cId = categoryId;
                    path = "," + categoryId.ToString();
                    while (level != 1)
                    {
                        var tempObj = GetAllListFromCache().FirstOrDefault(m => m.c_id == cId);
                        if (tempObj != null)
                        {
                            level = tempObj.c_level;
                            cId = tempObj.c_parentid;
                            path = "," + tempObj.c_parentid.ToString() + path;
                        }
                        else
                            break;
                    }
                    path = path.TrimStart(',');
                }
                listTemp = categories;

                //重新装载实体模型
                if (listTemp.Count > 0)
                {
                    foreach (var model in listTemp)
                    {
                        BailunCategoryDto obj = new BailunCategoryDto();
                        obj.c_id = model.c_id;
                        obj.c_parentid = model.c_parentid;
                        obj.c_cname = $"{model.c_cname}{model.c_ename}({model.c_id})";
                        obj.path = path;
                        list.Add(obj);
                    }
                }

                return list;
            }
            catch (Exception ex)
            {
                return new List<BailunCategoryDto>();
            }
        }

        /// <summary>
        /// 从缓存获取所有分类
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_bailun> GetAllListFromCache(int level = 0)
        {
            var _list = RedisCacheService.GetList(CacheKey.BailunProductCategories, "c_id", GetAllList).OrderBy(m => m.c_sort).ToList();
            if (level > 0)
                _list = _list.Where(m => m.c_level <= level).ToList();
            return _list;
        }

        /// <summary>
        /// 从缓存获取所有分类
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_bailun> GetAllList()
        {
            var _list = repo.Fetch<yt_category_bailun>("").OrderBy(m => m.c_sort).ToList();
            return _list;
        }

        /// <summary>
        /// 获取分类全名称
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static string GetFullNameByID(int categoryId, string type = "en")
        {
            string cateName = "";
            if (categoryId == 0) return "";
            var result = new List<yt_category_bailun>();
            var categories = GetAllListFromCache();
            var category = categories.FirstOrDefault(m => m.c_id == categoryId);
            if (category == null || category.c_id <= 0) return "";
            string pName = "";
            if (category.c_parentid >= 1)
            {
                pName = GetFullNameByID(category.c_parentid, type);
            }
            if (pName != "")
                pName = pName + " -> ";

            if (type == "cn")
                cateName = pName + category.c_cname;
            else
                cateName = pName + category.c_ename;

            return cateName;
        }

        /// <summary>
        /// 获取分类全名称根据列表
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static string GetFullNameByList(List<yt_category_bailun> cateList, int level = 1, string type = "en")
        {
            string cateName = "";
            var category = cateList.FirstOrDefault(m => m.c_level == level);
            if (category == null) return "";
            string pName = "";
            var objChild = cateList.FirstOrDefault(m => m.c_parentid == category.c_id);
            if (objChild != null)
            {
                level++;
                pName = GetFullNameByList(cateList, level);
            }
            if (pName != "")
                pName = " -> " + pName;

            if (type == "cn")
                cateName = category.c_cname + pName;
            else
                cateName = category.c_ename + pName;

            return cateName;
        }

        /// <summary>
        /// 获取所有包含自己的所有父级分类
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static List<yt_category_bailun> GetMyParentCategories(int categoryId)
        {
            if (categoryId == 0) return null;
            var result = new List<yt_category_bailun>();
            var categories = GetAllListFromCache();
            var category = categories.FirstOrDefault(m => m.c_id == categoryId);
            result.Add(category);
            if (category == null) throw new Exception($"不存在分类编号为：{categoryId}的产品分类");
            while (category != null && category.c_parentid > 0)
            {
                category = categories.FirstOrDefault(m => m.c_id == category.c_parentid);
                if (category != null)
                    result.Add(category);
            }
            return result;
        }

        /// <summary>
        /// 获取某分类下所有最子级Id或是自己
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public static List<yt_category_bailun> GetCategoriesAllChildList(int categoryId)
        {
            var result = new List<yt_category_bailun>();
            var categories = GetAllListFromCache();
            var objCate = categories.FirstOrDefault(m => m.c_id == categoryId);
            var cateList = categories.Where(m => m.c_parentid == objCate.c_id).ToList();
            if (cateList.Count > 0)
            {
                result = GetCategoriesChildrenList(categories, cateList, result);
            }
            else
                result.Add(objCate);
            return result;
        }

        /// <summary>
        /// 递归遍历底层子级
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_bailun> GetCategoriesChildrenList(List<yt_category_bailun> categories, List<yt_category_bailun> cateList, List<yt_category_bailun> result)
        {
            foreach(var objCate in cateList)
            {
                var childList = categories.Where(m => m.c_parentid == objCate.c_id).ToList();
                if (childList.Count > 0)
                {
                    result = GetCategoriesChildrenList(categories, childList, result);
                }
                else
                    result.Add(objCate);
            }
            return result;
        }

        /// <summary>
        /// 获取最底层分类
        /// </summary>
        /// <returns></returns>
        public static List<yt_category_bailun> GetBottomCategoriesUrl()
        {
            var _list = RedisCacheService.GetList(CacheKey.BailunBottomCategories, "c_id", GetBottomUrlList).OrderBy(m => m.c_cname).ToList();
            return _list;
        }

        /// <summary>
        /// 获取最底层分类获取方法
        /// </summary>
        /// <returns></returns>
        private static List<yt_category_bailun> GetBottomUrlList()
        {
            var _list = GetBottomList();
            foreach (var objCate in _list)
            {
                objCate.c_cname = GetFullNameByID(objCate.c_id);
            }
            return _list;
        }

        /// <summary>
        /// 获取最底层分类
        /// </summary>
        /// <returns></returns>
        private static List<yt_category_bailun> GetBottomList()
        {
            var allList = GetAllListFromCache();
            var result = allList.Where(m => allList.All(k => k.c_parentid != m.c_id)).ToList();

            return result;
        }
    }
}
