﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PetaPoco.Custom.ProductData
{
    public class ResultWareInfo
    {
        /// <summary>
        /// 是否成功
        /// </summary>
        public bool isSuccess { get; set; }

        /// <summary>
        /// 数据列表
        /// </summary>
        public List<WareInfo> data { get; set; }
    }

    public class WareInfo
    {
        /// <summary>
        /// 仓库Id
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 扩展名
        /// </summary>
        public string extendName { get; set; }

        /// <summary>
        /// 新仓库编码
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 环球仓库编码
        /// </summary>
        public string oldCode { get; set; }

        /// <summary>
        /// 区域信息
        /// </summary>
        public AreaWare area { get; set; }

        /// <summary>
        /// 仓库类型 1为采购入库 2为发货 3换标 4调拨入库 5调拨出库
        /// </summary>
        public List<AreaList> functions { get; set; }
    }

    public class AreaWare
    {
        /// <summary>
        /// 区域ID
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 区域名
        /// </summary>
        public string name { get; set; }
    }
}
