﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PetaPoco.Custom.ProductData
{
    public class ConditionInterface
    {
        /// <summary>
        /// 返回数据类型，1正常，2分页，99导出
        /// </summary>
        public int resultType { get; set; }

        /// <summary>
        /// 查询内容
        /// 1-1主要基础,1-2规格,1-3基础其他，2开发，3状态，4供应商，5商品,例：1-1,2,3
        /// </summary>
        public string resultContent { get; set; }

        /// <summary>
        /// sku(多个sku以,间隔，上限1000)
        /// </summary>
        public string skus { get; set; }

        /// <summary>
        /// 页数
        /// </summary>
        public int page { get; set; }

        /// <summary>
        /// 分页大小，最大1000
        /// </summary>
        public int pageSize { get; set; }

        /// <summary>
        /// 排序列
        /// </summary>
        public string sortField { get; set; }

        /// <summary>
        /// 排序方式
        /// </summary>
        public string sort { get; set; }

        /// <summary>
        /// 类型 1模糊查询 其他为精确
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// 查询产品库SKU或其他，默认为产品库
        /// </summary>
        public string state { get; set; }

        /// <summary>
        /// 查询类型 1产品编码，2商品编码，3标题模糊查询，4内部商品编码，5内部产品编码
        /// </summary>
        public int searchType { get; set; }

        /// <summary>
        /// 查询值
        /// </summary>
        public string search { get; set; }

        /// <summary>
        /// 百伦分类查询类型 默认查询自己及子节点，1位精确查询
        /// </summary>
        public int cateType { get; set; }
        /// <summary>
        /// 百伦分类Id
        /// </summary>
        public int cateId { get; set; }

        public string brand { get; set; }

        /// <summary>
        /// 产品系列
        /// </summary>
        public string series { get; set; }

        /// <summary>
        /// 采购员Id
        /// </summary>
        public int buyerId { get; set; }

        /// <summary>
        /// 销售员Id
        /// </summary>
        public int sellerId { get; set; }

        /// <summary>
        /// 供应商Id
        /// </summary>
        public int deliverId { get; set; }

        /// <summary>
        /// 商品状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 是否成品
        /// </summary>
        public int isFinish { get; set; }

        /// <summary>
        /// 是否上传
        /// </summary>
        public string IsUpApi { get; set; }

        /// <summary>
        /// 同步状态
        /// </summary>
        public string lastUpdateState { get; set; }

        /// <summary>
        /// 同步失败原因模糊查询
        /// </summary>
        public string reason { get; set; }

        /// <summary>
        /// 开发来源
        /// </summary>
        public string source { get; set; }

        /// <summary>
        /// 开始创建时间
        /// </summary>
        public DateTime beginCT { get; set; }

        /// <summary>
        /// 结束创建时间
        /// </summary>
        public DateTime endCT { get; set; }

        /// <summary>
        /// 日志修改日期
        /// </summary>
        public string updateDate { get; set; }

        /// <summary>
        /// 是否返回供应商
        /// </summary>
        public int isResultSup { get; set; }

        /// <summary>
        /// 是否返回仓库信息
        /// </summary>
        public int isResultWare { get; set; }
    }

    public class ResultAllProductInfo
    {
        /// <summary>
        /// 产品主键
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商品主键
        /// </summary>
        public int mainId { get; set; }

        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string goodsCode { get; set; }

        /// <summary>
        /// 内部产品编码
        /// </summary>
        public string productCode { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        public string product { get; set; }

        /// <summary>
        /// 产品编码
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 中文名称
        /// </summary>
        public string cTitle { get; set; }

        /// <summary>
        /// 英文名称
        /// </summary>
        public string eTitle { get; set; }

        /// <summary>
        /// 百伦分类Id
        /// </summary>
        public int cateBailunId { get; set; }

        /// <summary>
        /// 百伦分类名称
        /// </summary>
        public string cateBailunName { get; set; }

        /// <summary>
        /// 分类Id
        /// </summary>
        public int categoryId { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string categoryName { get; set; }

        /// <summary>
        /// 产品系列
        /// </summary>
        public string series { get; set; }

        /// <summary>
        /// 主图
        /// </summary>
        public string mainImage { get; set; }

        /// <summary>
        /// 子图
        /// </summary>
        public string childImage { get; set; }

        /// <summary>
        /// 是否成品
        /// </summary>
        public int isFinish { get; set; }
        /// <summary>
        /// 包装性质
        /// </summary>
        public string packageNature { get; set; }

        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; }

        /// <summary>
        /// 颜色名称
        /// </summary>
        public string colorName { get; set; }

        /// <summary>
        /// 规格1名称
        /// </summary>
        public string sizeName { get; set; }

        /// <summary>
        /// 规格2名称
        /// </summary>
        public string sizeName1 { get; set; }

        /// <summary>
        /// 规格3名称
        /// </summary>
        public string sizeName2 { get; set; }

        /// <summary>
        /// 颜色
        /// </summary>
        public string color { get; set; }

        /// <summary>
        /// 规格
        /// </summary>
        public string size { get; set; }

        /// <summary>
        /// 规格1
        /// </summary>
        public string size1 { get; set; }

        /// <summary>
        /// 规格2
        /// </summary>
        public string size2 { get; set; }

        /// <summary>
        /// 采购价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string currency { get; set; }

        /// <summary>
        /// 产品重量
        /// </summary>
        public decimal weight { get; set; }

        /// <summary>
        /// 单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 包装重量
        /// </summary>
        public string packingWeight { get; set; }

        /// <summary>
        /// 产品尺寸
        /// </summary>
        public string productSize { get; set; }

        /// <summary>
        /// 包装尺寸
        /// </summary>
        public string packingSize { get; set; }

        /// <summary>
        /// 包装名称
        /// </summary>
        public string packingName { get; set; }

        /// <summary>
        /// 包装要求
        /// </summary>
        public string packingReq { get; set; }

        /// <summary>
        /// 包装规格
        /// </summary>
        public int packingSkuid { get; set; }

        /// <summary>
        /// 包装价格
        /// </summary>
        public decimal packingPrice { get; set; }

        /// <summary>
        /// 充电器规格
        /// </summary>
        public int chargerSpec { get; set; }

        /// <summary>
        /// 产品性质
        /// </summary>
        public string productCharacter { get; set; }

        /// <summary>
        /// 中文配货名
        /// </summary>
        public string cPeiHuo { get; set; }

        /// <summary>
        /// 英文配货名
        /// </summary>
        public string ePeiHuo { get; set; }

        /// <summary>
        /// 中文申报名
        /// </summary>
        public string cBaoGuan { get; set; }

        /// <summary>
        /// 英文申报名
        /// </summary>
        public string eBaoGuan { get; set; }

        /// <summary>
        /// 海关编码
        /// </summary>
        public string hsCode { get; set; }

        /// <summary>
        /// 业务开发员Id
        /// </summary>
        public int bussinessId { get; set; }

        /// <summary>
        /// 业务开发员名称
        /// </summary>
        public string bussinessName { get; set; }

        /// <summary>
        /// 找货员
        /// </summary>
        public string bargainer { get; set; }

        /// <summary>
        /// 采购员Id
        /// </summary>
        public int buyer { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>
        public string buyerName { get; set; }

        /// <summary>
        /// 询价员Id
        /// </summary>
        public int enquiryId { get; set; }

        /// <summary>
        /// 询价员名称
        /// </summary>
        public string enquiryName { get; set; }

        /// <summary>
        /// 采购仓库
        /// </summary>
        public string wareCode { get; set; }

        /// <summary>
        /// 贴标要求
        /// </summary>
        public string labelReq { get; set; }

        /// <summary>
        /// 质检类型
        /// </summary>
        public int zhijianType { get; set; }

        /// <summary>
        /// 质检要求
        /// </summary>
        public string zhijianReq { get; set; }

        /// <summary>
        /// 质检工时
        /// </summary>
        public decimal testHour { get; set; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public int enable { get; set; }

        /// <summary>
        /// 是否核算
        /// </summary>
        public int isHesuan { get; set; }

        /// <summary>
        /// 数据来源
        /// </summary>
        public int source { get; set; }

        /// <summary>
        /// 开发站点
        /// </summary>
        public string exploitSite { get; set; }

        /// <summary>
        /// 销售价格
        /// </summary>
        public decimal salesPrice { get; set; }

        /// <summary>
        /// 尺码图片
        /// </summary>
        public string codeImage { get; set; }

        /// <summary>
        /// 商品状态 1停售，2在售
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 上传状态 0未上传，1已上传
        /// </summary>
        public int isUpApi { get; set; }

        /// <summary>
        /// 同步状态 0未同步，1已同步，-1同步失败
        /// </summary>
        public int lastUpdateState { get; set; }

        /// <summary>
        /// 同步失败原因
        /// </summary>
        public string reason { get; set; }

        /// <summary>
        /// 推送产品库状态
        /// </summary>
        public int productStatus { get; set; }

        /// <summary>
        /// 虚拟采购价
        /// </summary>
        public decimal virPrice { get; set; }

        /// <summary>
        /// 供应商Id
        /// </summary>
        public int deliverId { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string deliverName { get; set; }

        /// <summary>
        /// 供应商链接
        /// </summary>
        public string link { get; set; }

        /// <summary>
        /// 最小订单量
        /// </summary>
        public int moq { get; set; }

        /// <summary>
        /// 内部最小订单量
        /// </summary>
        public int internalMoq { get; set; }

        /// <summary>
        /// 交期
        /// </summary>
        public int delivery { get; set; }

        /// <summary>
        /// 调拨计划交期
        /// </summary>
        public int allotDelivery { get; set; }

        /// <summary>
        /// 是否有档口
        /// </summary>
        public int haveStall { get; set; }

        /// <summary>
        /// 提货地点
        /// </summary>
        public string takeAddress { get; set; }

        /// <summary>
        /// 支持提货
        /// </summary>
        public int istakeGoods { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 组合关系
        /// </summary>
        public string GroupRelete { get; set; }

        /// <summary>
        /// 开发时间
        /// </summary>
        public DateTime developTime { get; set; }

        /// <summary>
        /// 更新人
        /// </summary>
        public string updateName { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime updateTime { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public string createName { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public DateTime createTime { get; set; }

        /// <summary>
        /// 返回所有供应商列表
        /// </summary>
        public List<GetSupplierInfo> spList = new List<GetSupplierInfo>();

        /// <summary>
        /// 返回sku仓库信息列表
        /// </summary>
        public List<GetWareAreaInfo> wareList = new List<GetWareAreaInfo>();
    }

    public class GetSupplierInfo
    {
        /// <summary>
        /// 标识主键
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 关系表主键
        /// </summary>
        public int relationId { get; set; }

        /// <summary>
        /// 商品主键
        /// </summary>
        public int mainId { get; set; }

        /// <summary>
        /// sku主键
        /// </summary>
        public int sId { get; set; }

        /// <summary>
        /// sku
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 询价员Id
        /// </summary>
        public int enquiryId { get; set; }

        /// <summary>
        /// 询价员
        /// </summary>
        public string enquiryName { get; set; }

        /// <summary>
        /// 供应商Id
        /// </summary>
        public int deliverId { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        public string deliverName { get; set; }

        /// <summary>
        /// 供应商链接
        /// </summary>
        public string link { get; set; }

        /// <summary>
        /// 供应商报价
        /// </summary>
        public decimal price { get; set; }

        /// <summary>
        /// 交期(天)
        /// </summary>
        public int delivery { get; set; }

        /// <summary>
        /// 调拨计划交期(天)
        /// </summary>
        public int allotDelivery { get; set; }

        /// <summary>
        /// 最小订单量
        /// </summary>
        public int moq { get; set; }

        /// <summary>
        /// 内部moq
        /// </summary>
        public int internalMoq { get; set; }

        /// <summary>
        /// 是否有档口
        /// </summary>
        public int haveStall { get; set; }

        /// <summary>
        /// 提货地点
        /// </summary>
        public string takeAddress { get; set; }

        /// <summary>
        /// 支持提货
        /// </summary>
        public int istakeGoods { get; set; }

        /// <summary>
        /// 是否默认供应商1是，0否
        /// </summary>
        public int isDefault { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }
    }

    public class GetWareAreaInfo
    {
        /// <summary>
        /// 标识主键
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// sku主键
        /// </summary>
        public int sId { get; set; }

        /// <summary>
        /// sku
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 区域Id
        /// </summary>
        public int areaId { get; set; }

        /// <summary>
        /// 仓库Code
        /// </summary>
        public string wareCode { get; set; }

        /// <summary>
        /// 默认仓库
        /// </summary>
        public int isDefault { get; set; }
    }
}
