﻿using API.Services.ProductManageServices;
using ApiControl;
using DbConn;
using Newtonsoft.Json;
using Petapoco.Custom.SkuMap;
using PetaPoco;
using PetaPoco.Custom;
using PetaPoco.Custom.SkuMap;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace API.Services.SkuMapManageServices
{
    public class SkuMapServices
    {
        public static string SystemOA = ConfigurationManager.AppSettings["SystemOA"];
        public static string SystemPAMS = ConfigurationManager.AppSettings["SystemPAMS"];
        public static string SaasPlatSku = ConfigurationManager.AppSettings["SaasPlatSku"];

        /// <summary>
        /// 添加SKU映射接口
        /// </summary>
        /// <returns></returns>
        public static ApiResult AddSkuMapInfo(BltAddSkuMap AddMapList)
        {
            ApiResult result = new ApiResult();
            if(string.IsNullOrWhiteSpace(AddMapList.Plat) || string.IsNullOrWhiteSpace(AddMapList.Site))
            {
                result = ApiDataManage.CreateApiResult(400);
                result.result_msg += "平台，站点不能为空！";
                return result;
            }
            if(AddMapList.AccountList.Count == 0)
            {
                result = ApiDataManage.CreateApiResult(400);
                result.result_msg += "帐号列表不能为空！";
                return result;
            }
            if (AddMapList.SkuList.Count == 0)
            {
                result = ApiDataManage.CreateApiResult(400);
                result.result_msg += "sku列表不能为空！";
                return result;
            }

            using (Database DB = DbConnDB.GetInstance())
            {
                using (var tx = DB.GetTransaction())
                {
                    try
                    {
                        List<ResultRelate> resultList = new List<ResultRelate>();
                        var accountList = GetPlatAccountList();
                        //根据不同帐号生成多个listting
                        foreach (var account in AddMapList.AccountList)
                        {                            
                            List<yt_sku_mapping> mapList = new List<yt_sku_mapping>();
                            foreach (var myMap in AddMapList.SkuList)
                            {
                                //验证是否已存在相同listting，多条则为多属性, 后面要传入刊登编码判断是否为补充
                                int attrType = 1;
                                //没有itemId,统一默认为1
                                if (AddMapList.SkuList.Count > 1)
                                    attrType = 2;

                                var objBase = yt_product_base.Func_GetById(myMap.SkuId);
                                if (objBase != null)
                                {
                                    if(objBase.s_isfinish == 1 || objBase.s_isfinish == 5)
                                    {
                                        var objAccount = accountList.FirstOrDefault(m => m.Account == account);
                                        if (objAccount == null)
                                        {
                                            result = ApiDataManage.CreateApiResult(400);
                                            result.result_msg += $"skuId:{myMap.SkuId}找不到登录帐号{account}，请到OA平台帐号中核查。";
                                            return result;
                                        }

                                        yt_sku_mapping objMap = new yt_sku_mapping();
                                        objMap.yt_platformid = objAccount.PlatformId;
                                        objMap.yt_platform = AddMapList.Plat;
                                        objMap.yt_siteid = objAccount.SiteId;
                                        objMap.yt_site = AddMapList.Site;
                                        objMap.yt_accountid = objAccount.Id;
                                        objMap.yt_loginAccount = account;
                                        objMap.yt_account = objAccount.OmsAccount;
                                        objMap.yt_sellername = AddMapList.Seller;
                                        objMap.yt_itemid = "";
                                        objMap.yt_isupapi = 0;
                                        objMap.yt_errormsg = "";
                                        objMap.yt_source = 3;
                                        objMap.yt_issync = 0;
                                        objMap.yt_createuser = AddMapList.CreateUser;
                                        objMap.yt_createtime = DateTime.Now;
                                        objMap.yt_updateuser = AddMapList.CreateUser;
                                        objMap.yt_updatetime = DateTime.Now;
                                        objMap.yt_operatetype = "Add";
                                        objMap.yt_old_productCode = objBase.s_goods_code ?? "";
                                        objMap.yt_old_sku = objBase.s_product_code ?? "";
                                        objMap.yt_productid = objBase.s_main_id;
                                        objMap.yt_s_id = objBase.s_id;
                                        objMap.yt_spu = objBase.s_product;
                                        objMap.yt_setno = objBase.s_sku;
                                        objMap.yt_title = objBase.s_ctitle;
                                        objMap.yt_count = myMap.Count;
                                        //objMap.yt_new_productCode = "0";
                                        //对应分类Id未对接
                                        objMap.yt_fir_category = 0;
                                        objMap.yt_sec_categoryy = 0;
                                        objMap.yt_base_cayegory = 0;
                                        objMap.yt_fullname_category = "";
                                        objMap.yt_attribute_type = attrType;
                                        objMap.yt_isgroup = objBase.s_isfinish == 5 ? 1 : 0;
                                        objMap.yt_isany = 0;
                                        objMap.yt_ismap = string.IsNullOrWhiteSpace(AddMapList.Seller) ? 0 : 1;   //找到对应产品库SKU
                                        mapList.Add(objMap);
                                    }
                                    else
                                    {
                                        result = ApiDataManage.CreateApiResult(400);
                                        result.result_msg += $"skuId:{myMap.SkuId}为非成品或非组合SKU，不能添加映射。";
                                        return result;
                                    }
                                }
                                else
                                {
                                    result = ApiDataManage.CreateApiResult(400);
                                    result.result_msg += $"skuId:{myMap.SkuId}找到对应数据";
                                    return result;
                                }
                            }

                            //最后才去获取产品编码
                            string goodsCode = ProductDataServices.GenerateCode();  //获取刊登产品编码
                            int index = 1;
                            foreach (var model in mapList)
                            {
                                model.yt_new_productCode = goodsCode;
                                model.yt_new_sku = ProductDataServices.CreateProductCode(goodsCode, index);
                                model.Insert();
                                index++;

                                ResultRelate resultMap = new ResultRelate()
                                {
                                    Account = account,
                                    PlatSku = model.yt_new_sku,
                                    SkuId = model.yt_s_id,
                                    Sku = model.yt_setno
                                };
                                resultList.Add(resultMap);
                            }

                            //最后才去获取产品编码
                            //var platSkuList = new List<PostCreatePlatSku>();
                            //foreach (var model in mapList)
                            //{
                            //    var objCreate = new PostCreatePlatSku();
                            //    objCreate.acc_id = model.yt_accountid;
                            //    objCreate.uid = 1;
                            //    objCreate.amount = model.yt_count;
                            //    objCreate.product_sku = model.yt_setno;
                            //    platSkuList.Add(objCreate);
                            //}
                            //var platAllList = new List<List<PostCreatePlatSku>>();
                            //platAllList.Add(platSkuList);
                            //var postJson = CommonBaseLib.GetJsonToString(platAllList);
                            //var platSkuResult = CommonBaseLib.GetJsonToObject<ResponsePLatSku>(HttpGetOrPost.HttpPostJson(SaasPlatSku + "/api/getplatformsku", postJson));
                            //if(platSkuResult.code == 0)
                            //{
                            //    int index = 0;
                            //    var myPlatSku = platSkuResult.data;
                            //    foreach (var model in mapList)
                            //    {
                            //        model.yt_new_sku = myPlatSku[index];
                            //        model.Insert();
                            //        index++;
                            //        ResultRelate resultMap = new ResultRelate()
                            //        {
                            //            Account = account,
                            //            PlatSku = model.yt_new_sku,
                            //            SkuId = model.yt_s_id,
                            //            Sku = model.yt_setno
                            //        };
                            //        resultList.Add(resultMap);
                            //    }
                            //}
                            //else
                            //{
                            //    tx.Dispose();
                            //    result = ApiDataManage.CreateApiResult(500);
                            //    result.result_msg += "获取平台SKU接口异常,原因:" + platSkuResult.msg;
                            //    return result;
                            //}
                        }
                        tx.Complete();
                        result = ApiDataManage.CreateApiResult(1);
                        result.data = CommonBaseLib.EncodeAndJson(resultList);
                    }
                    catch(Exception ex)
                    {
                        tx.Dispose();
                        result = ApiDataManage.CreateApiResult(500);
                        result.result_msg += ex.Message;
                    }
                    return result;
                }
            }
        }

        /// <summary>
        /// 增加未认领映射数据
        /// </summary>
        /// <returns></returns>
        public static ApiResult AddSkuMapClaimInfo(ApiEntrance api)
        {
            string dataJson = api.data;
            ApiResult result = new ApiResult();
            var accountList = GetPlatAccountList();
            using (var dbContext = DbConnDB.GetInstance())
            {
                using (var tx = dbContext.GetTransaction())
                {
                    try
                    {
                        var successState = true;
                        var mapList = CommonBaseLib.GetJsonToObject<List<SaasAddSkuMap>>(dataJson);
                        foreach (var item in mapList)
                        {
                            //判断帐号是否存在
                            var objAccount = accountList.FirstOrDefault(m => m.Id == item.accountId);
                            if (objAccount == null)
                            {
                                //没有帐号返回错误
                                successState = false;
                                result = ApiDataManage.CreateApiResult(400);
                                result.result_msg += $"Id:{objAccount.Id}帐号不存在";
                                break;
                            }

                            //判断平台SKU是否为空
                            if(string.IsNullOrWhiteSpace(item.platSku))
                            {
                                //没有帐号返回错误
                                successState = false;
                                result = ApiDataManage.CreateApiResult(400);
                                result.result_msg += $"平台SKU不能为空";
                                break;
                            }

                            //判断该映射是否存在
                            var isExist = yt_sku_mapping.FirstOrDefault(" where yt_new_sku = @0 and yt_accountid = @1 and yt_operatetype != 'Delete'", item.platSku, item.accountId);
                            if (isExist != null)
                            {
                                continue;
                            }

                            yt_sku_mapping objMap = new yt_sku_mapping();                            
                            objMap.yt_platformid = objAccount.PlatformId;
                            objMap.yt_platform = objAccount.PlatformEn;
                            objMap.yt_siteid = objAccount.SiteId;
                            objMap.yt_site = objAccount.SiteEn;
                            objMap.yt_accountid = objAccount.Id;
                            objMap.yt_loginAccount = objAccount.Account;
                            objMap.yt_account = objAccount.OmsAccount;
                            objMap.yt_new_sku = item.platSku;
                            objMap.yt_sellername = "";
                            objMap.yt_itemid = "";
                            objMap.yt_isupapi = 0;
                            objMap.yt_errormsg = "";
                            objMap.yt_source = 5;
                            objMap.yt_issync = 0;
                            objMap.yt_createuser = "Saas_Api";
                            objMap.yt_createtime = DateTime.Now;
                            objMap.yt_updateuser = "Saas_Api";
                            objMap.yt_updatetime = DateTime.Now;
                            objMap.yt_operatetype = "Add";
                            objMap.yt_old_productCode = "";
                            objMap.yt_old_sku = "";
                            objMap.yt_productid = 0;
                            objMap.yt_s_id = 0;
                            objMap.yt_spu = "";
                            objMap.yt_setno = "";
                            objMap.yt_title = "";
                            objMap.yt_count = 1;
                            objMap.yt_new_productCode = "0";
                            objMap.yt_fir_category = 0;
                            objMap.yt_sec_categoryy = 0;
                            objMap.yt_base_cayegory = 0;
                            objMap.yt_fullname_category = "";
                            objMap.yt_attribute_type = 1;
                            objMap.yt_isgroup = 0;
                            objMap.yt_isany = 0;
                            objMap.yt_ismap = 0;   //找到对应产品库SKU

                            var objPlatSku = yt_sku_mapping.FirstOrDefault(" where yt_platform = @0 and yt_new_sku = @1 and yt_ismap = 1 and yt_sellername != '' and yt_operatetype != 'Delete' order by yt_createtime desc", objAccount.PlatformEn, item.platSku);
                            if (objPlatSku != null)
                            {
                                objMap.yt_sellername = objPlatSku.yt_sellername;
                                objMap.yt_old_productCode = objPlatSku.yt_old_productCode;
                                objMap.yt_old_sku = objPlatSku.yt_old_sku;
                                objMap.yt_productid = objPlatSku.yt_productid;
                                objMap.yt_s_id = objPlatSku.yt_s_id;
                                objMap.yt_spu = objPlatSku.yt_spu;
                                objMap.yt_setno = objPlatSku.yt_setno;
                                objMap.yt_title = objPlatSku.yt_title;
                                objMap.yt_ismap = 1;

                                //验证2018年8月1日后一条平台SKU只能对应一个产品库SKU
                                var ruleList = yt_sku_mapping.Fetch(" where yt_platform = 'Ebay' and yt_new_sku = @0 and yt_ismap = 1 and yt_createtime > '2018-08-01 00:00:00' and yt_operatetype != 'Delete' group by yt_s_id", objMap.yt_new_sku).ToList();
                                if(ruleList.Count == 1)
                                {
                                    var objRule = ruleList.FirstOrDefault();
                                    if(objRule.yt_s_id != objMap.yt_s_id)
                                    {
                                        objMap.yt_sellername = objRule.yt_sellername;
                                        objMap.yt_old_productCode = objRule.yt_old_productCode;
                                        objMap.yt_old_sku = objRule.yt_old_sku;
                                        objMap.yt_productid = objRule.yt_productid;
                                        objMap.yt_s_id = objRule.yt_s_id;
                                        objMap.yt_spu = objRule.yt_spu;
                                        objMap.yt_setno = objRule.yt_setno;
                                        objMap.yt_title = objRule.yt_title;
                                    }
                                }
                            }
                            
                            objMap.Insert();
                        }
                        if(successState)
                        {
                            tx.Complete();
                            result = ApiDataManage.CreateApiResult(1);
                        }
                        else
                        {
                            tx.Dispose();
                        }
                        
                    }
                    catch (Exception ex)
                    {
                        tx.Dispose();
                        result = ApiDataManage.CreateApiResult(504);
                        result.result_msg = "系统异常。" + ex.Message;
                    }
                }
            }
            return result;
        }

        /// <summary>
        /// 更新SKU映射接口
        /// </summary>
        /// <returns></returns>
        public static ApiResult UpdateSkuMapInfo()
        {
            return null;
        } 

        /// <summary>
        /// 获取平台帐号
        /// </summary>
        /// <returns></returns>
        public static List<sellerAccount> GetPlatAccountList()
        {
            var accountList = new List<sellerAccount>();
            var result = JsonConvert.DeserializeObject<PlatAccountInfo>(HttpGetOrPost.httpGet(SystemPAMS + "/Api/GetAccounts"));
            if (result.Success)
                accountList = result.Data.ToList();
            return accountList;
        }
    }
}
