﻿using ApiControl;
using PetaPoco;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace API.Services
{
    public class ProductInfoServices
    {
        /// <summary>
        /// sql数据处理
        /// </summary>
        /// <returns></returns>
        public static Sql SelectDataAssembly(QueryTable model)
        {
            Sql sql = new Sql();
            sql.Append(string.Format("select {0} from {1} where 1=1", model.fields, model.table));

            List<ConditionDetail> list = model.key_value;
            foreach(var item in list)
            {
                if (item.cdn == 0)
                    sql.Append(" and @0", item.val);
                else if (item.cdn == 1)
                    sql.Append(" and " + item.key + " = @0", item.val);
                else if (item.cdn == 2)
                    sql.Append(" and " + item.key + " != @0", item.val);
                else if (item.cdn == 3)
                    sql.Append(" and " + item.key + " like @0", "%" + item.val + "%");
                else if (item.cdn == 4)
                    sql.Append(" and " + item.key + " in (" + item.val + ")");
            }
            return sql;
        }

        /// <summary>
        /// 查询条件组装数据
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static Sql UpdateWhereData(UpdateTable model)
        {
            Sql sql = Sql.Builder;
            List<ConditionDetail> list = model.key_value;
            if (list.Count > 0)
            {
                string andWhere = "";
                for (int i = 0; i < list.Count; i++)
                {
                    if (i == 0)
                        andWhere = " where ";
                    else if (i != 0)
                        andWhere = " and ";

                    if (list[i].cdn == 0)
                        sql.Append(andWhere + " @0 ", list[i].val.ToString());
                    else if (list[i].cdn == 1)
                        sql.Append(andWhere + list[i].key + " = @0", list[i].val.ToString());
                    else if (list[i].cdn == 2)
                        sql.Append(andWhere + list[i].key + " != @0", list[i].val.ToString());
                    else if (list[i].cdn == 3)
                        sql.Append(andWhere + list[i].key + " like @0", "%" + list[i].val.ToString() + "%");
                    else if (list[i].cdn == 4)
                        sql.Append(andWhere + list[i].key + " in (" + list[i].val.ToString() + ") ");
                }
            }
            return sql;
        }

        /// <summary>
        /// 修改数据对象处理
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public static object UpdateDataAssembly(UpdateTable model, object obj)
        { 
            List<UpdateColumn> upList = model.col;

            foreach (PropertyInfo item in obj.GetType().GetProperties())
            {
                for (int i = 0; i < upList.Count; i++)
                {
                    if (item.Name.Equals(upList[i].key))
                    {
                        string tName = item.PropertyType.FullName;
                        if (tName.Contains("System.Int32"))
                            item.SetValue(obj, Convert.ToInt32(upList[i].val), null);
                        else if (tName.Contains("System.Int64"))
                            item.SetValue(obj, Convert.ToInt64(upList[i].val), null);
                        else if (tName.Contains("System.Boolean"))
                            item.SetValue(obj, Convert.ToBoolean(upList[i].val), null);
                        else if (tName.Contains("System.Decimal"))
                            item.SetValue(obj, Convert.ToDecimal(upList[i].val), null);
                        else if (tName.Contains("System.SByte"))
                            item.SetValue(obj, Convert.ToSByte(upList[i].val), null);
                        else if (tName.Contains("System.DateTime"))
                            item.SetValue(obj, Convert.ToDateTime(upList[i].val), null);
                        else
                            item.SetValue(obj, upList[i].val, null);
                    }
                }
            }
            
            return obj;
        }
    }
}
