package com.bailuntec.controller;

import com.bailuntec.dto.AlarmMessageDto;
import com.bailuntec.service.SkyWalkingNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.GeneralSecurityException;
import java.util.List;

@RestController
public class SkyWalkingNotice {

    @Autowired
    private SkyWalkingNoticeService skyWalkingNoticeService;

    @RequestMapping(value = "notice")
    public void notice(HttpServletRequest request, HttpServletResponse response, @RequestBody List<AlarmMessageDto> alarmMessageList) throws GeneralSecurityException, MessagingException {
        skyWalkingNoticeService.send(alarmMessageList);
    }
}
