package com.gogirl.infrastructure.mapper.common;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gogirl.domain.common.AgentUser;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/3 9:38 上午
 */
@ActiveProfiles("pre")
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class AgentUserMapperTest {


    @Resource
    AgentUserMapper agentUserMapper;
    @Resource
    CustomerMapper customerMapper;

    @Test
    public void insert() {
        Customer customer = customerMapper.selectByPhone("13272036791");


        AgentUser agentUser = new AgentUser();
        agentUser.setPhone(customer.getPhone());
        agentUser.setName(customer.getNickname());
        agentUser.setNo(IdWorker.getIdStr().substring(8));
        //todo
        agentUser.setLevel(1);
        agentUser.setDiscount(BigDecimal.ONE);
        agentUser.setCurrentStartTime(LocalDateTime.now());
        agentUser.setDueDate(LocalDateTime.now().plusYears(1));
        agentUser.setCreateUser(customer.getNickname());

        agentUserMapper.insert(agentUser);
    }
}
