package com.gogirl.shared.store;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class ApplyTakeLeaveCommand implements Serializable {


    @ApiModelProperty("如果申请调休要写这个字段")
    List<OverTimeLogCommand> overTimeLogCommandList;

    @ApiModelProperty("请假美甲师id")
    private Integer applyTechnicianId;

    @ApiModelProperty("1-加班 2-调休 3-事假 4-病假 5-外出 6-年假 7-生日假 8-婚假 9-产假")
    private Integer type;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("请假时长")
    private BigDecimal timeLength;

    @ApiModelProperty("申请理由")
    private String applyReason;

    @ApiModelProperty("处理中的美甲师id")
    private Integer dealingTechnicianId;

    @ApiModelProperty("附件地址")
    private String annexUrl;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

}
