package com.gogirl.interfaces.product.mall;

import com.gogirl.application.product.mall.MallCategoryService;
import com.gogirl.domain.product.mall.MallCategory;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@Api(tags = "商城商品分类接口")
@RestController
@AllArgsConstructor
public class MallCategoryController {

    private final MallCategoryService mallCategoryService;

    @LoginIgnore
    @AuthIgnore
    @ApiOperation("获取分类")
    @GetMapping("/customer/mallCategory/getCategoryTree")
    public JsonResult<List<MallCategory>> getCategoryTree(@RequestHeader("brandId") Integer brandId) {
        List<MallCategory> tree = mallCategoryService.getCategoryTreeList(brandId);
        return JsonResult.success(tree);
    }

    @LoginIgnore
    @AuthIgnore
    @ApiOperation("根据父节点分类id获取子分类列表")
    @GetMapping("/customer/mallCategory/getCategoryList/{categoryId}")
    public JsonResult<List<MallCategory>> getCategoryList(@PathVariable Long categoryId, @RequestHeader("brandId") Integer brandId) {

        List<MallCategory> mallCategoryList = mallCategoryService.getCategoryList(categoryId, brandId);
        return JsonResult.success(mallCategoryList);
    }


}
