package com.gogirl.infrastructure.service.sms.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.gogirl.application.common.ISmsConfigService;
import com.gogirl.domain.common.SmsConfig;
import com.gogirl.infrastructure.service.sms.SmsService;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.xml.ws.http.HTTPException;
import java.io.IOException;

/**
 * 短信服务 腾讯云短信实现
 */
@Service
@Slf4j
public class QCloudSmsServiceImpl implements SmsService {
    @Resource
    StringRedisTemplate stringRedisTemplate;

    @Resource
    ISmsConfigService smsConfigService;

    @Override
    public SmsSingleSenderResult sendBindSmsCode(String phoneNumber, String code, Integer brandId) {
        //
        SmsConfig smsConfig = smsConfigService.getOne(new LambdaQueryWrapper<SmsConfig>().eq(SmsConfig::getBrandId, brandId));
        String smsSign = smsConfig.getSmsSign();
        int templateId = smsConfig.getBindTemplateId();
        String[] params = {code, smsConfig.getActiveTime()};

        SmsSingleSenderResult result = new SmsSingleSenderResult();

        try {
            SmsSingleSender sender = new SmsSingleSender(smsConfig.getAppId(), smsConfig.getAppKey());
            result = sender.sendWithParam("86", phoneNumber, templateId, params, smsSign, "", "");
            stringRedisTemplate.opsForValue().set(phoneNumber, code);

        }
        // HTTP响应码错误 json解析错误 网络IO错误
        catch (HTTPException | JSONException | IOException | com.github.qcloudsms.httpclient.HTTPException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public Boolean checkSmsCode(String phoneNumber, String code) {
        return code.equals(stringRedisTemplate.opsForValue().get(phoneNumber));
    }

}
