package com.gogirl.application.store.training.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.training.ITrainingQuestionService;
import com.gogirl.domain.store.training.TrainingQuestion;
import com.gogirl.domain.store.training.TrainingQuestionOption;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.training.TrainingQuestionMapper;
import com.gogirl.infrastructure.mapper.store.training.TrainingQuestionOptionMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Service
public class TrainingQuestionServiceImpl extends ServiceImpl<TrainingQuestionMapper, TrainingQuestion> implements ITrainingQuestionService {

    @Resource
    private TrainingQuestionOptionMapper trainingQuestionOptionMapper;

    @Override
    public List<TrainingQuestion> trainingFeedbackQuestions(Integer brandId) {

        List<TrainingQuestion> trainingQuestionList = baseMapper.selectList(
                new LambdaQueryWrapper<TrainingQuestion>()
                        .eq(TrainingQuestion::getEnable, 1)
                        .eq(TrainingQuestion::getBrandId, brandId)
        );
        List<Integer> trainingQuestionIds = trainingQuestionList.stream().map(TrainingQuestion::getId).collect(Collectors.toList());

        if (ListUtil.isNotEmpty(trainingQuestionIds)) {
            Map<Integer, List<TrainingQuestionOption>> optionsMap = trainingQuestionOptionMapper.selectList(new LambdaQueryWrapper<TrainingQuestionOption>()
                    .in(TrainingQuestionOption::getTrainingQuestionId, trainingQuestionIds))
                    .stream()
                    .collect(Collectors.groupingBy(TrainingQuestionOption::getTrainingQuestionId));
            trainingQuestionList.forEach(trainingQuestion -> trainingQuestion.setTrainingQuestionOptionList(optionsMap.get(trainingQuestion.getId())));

        }
        return trainingQuestionList;
    }
}
