package com.gogirl.domain.user;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.store.store.StoreManage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

@ApiModel("美甲小程序用户")
@Data
@TableName("customer")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Customer implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("唯一id")
    private String unionid;

    @ApiModelProperty("公众号id")
    private String openid;

    @ApiModelProperty("微信小程序openid")
    private String openid1;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("微信昵称")
    private String nickname;

    @ApiModelProperty("性别 男-女")
    private String sex;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("地区")
    private String area;

    @ApiModelProperty("街道")
    private String street;

    @ApiModelProperty("头像")
    private String headimgurl;

    @ApiModelProperty("状态 1-正常")
    private String state;

    @ApiModelProperty("注册时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registerTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("真名")
    private String realName;

    @ApiModelProperty("生日")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    @ApiModelProperty("注册店铺id")
    private Integer registerDepartment;

    @ApiModelProperty("店员记录真实姓名")
    private String storeRecordRealName;

    private String remark;

    private String remark2;
    private String remark3;
    private String remark4;

    @ApiModelProperty("负责人")
    private String responsiblePerson;

    @ApiModelProperty("数据完整度")
    private Double dataIntegrity;

    @ApiModelProperty("1, 大众 2,朋友介绍3, 自来 4,微信 5:街客 6：线上活动'")
    private Integer customerSource;

    @ApiModelProperty("1,新建预约2,新建订单3,微信端授权'")
    private Integer source;

    @ApiModelProperty("预约次数")
    private Integer scheduledTimes;

    @ApiModelProperty("产生的订单次数")
    private Integer orderTimes;

    @ApiModelProperty("用户二维码")
    private String myQrcode;

    private String password;

    private String privilege;

    @TableField(exist = false)
    private StoreManage storeManage;

    @TableField(exist = false)
    private CustomerBalance customerBalance;

    @TableField(exist = false)
    private CustomerDetail customerDetail;

    @TableField(exist = false)
    private CustomerWeibo customerWeibo;


}
