package com.gogirl.interfaces.product.serve;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.dto.QueryProduceDetailRespDTO;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;


@Api(tags = {"预约服务款式接口"}, value = "预约服务款式接口")
@RestController
@AllArgsConstructor
public class ProduceController {

    private final BaseProduceService baseProduceService;

    @Deprecated
    @GetMapping("/customer/serve/no_queryNewServePage")
    @ApiOperation(value = "款式列表")
    public JsonResult<PageInfo<BaseServe>> no_queryNewServePage(@RequestParam String token,
                                                                @RequestParam(required = false) Integer labelId,
                                                                @RequestParam(required = false) Integer serveLabelId,
                                                                @RequestParam(required = false) Integer pageNum,
                                                                @RequestParam(required = false) Integer pageSize) {

        GogirlToken gogirlToken = SessionUtils.getCustomerToken();

        if (labelId != null && labelId == -1) {
            labelId = null;
        }
        //分页
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }
        //是否登陆
        Integer customerId = (gogirlToken != null && gogirlToken.getCustomerId() != null) ? gogirlToken.getCustomerId() : null;

        long time = System.currentTimeMillis();
        List<BaseProduce> listsBaseProduce = baseProduceService.queryNewServePage(customerId, labelId);
        System.out.println("queryNewServePage db io time " + (+System.currentTimeMillis() - time));
        List<BaseServe> lists = listsBaseProduce.stream()
                .map(baseProduce -> {
                    BaseServe item = baseProduce.getServe();
                    baseProduce.setServe(null);
                    item.setProduce(baseProduce);
                    return item;
                })
                .collect(Collectors.toList());

        return JsonResult.success(new PageInfo<>(lists));
    }


    @GetMapping("/customer/serve/no_queryProducePage")
    @ApiOperation(value = "款式列表")
    public JsonResult<IPage<BaseProduce>> queryProducePage(@RequestParam String token,
                                                           @RequestParam(required = false) Integer labelId,
                                                           @RequestParam(required = false) Integer serveTypeId,
                                                           @RequestParam(required = false) Integer colorSystemId,
                                                           @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(required = false, defaultValue = "10") Integer pageSize) {
        IPage<BaseProduce> page = baseProduceService.queryProducePage(labelId, serveTypeId, colorSystemId, pageNum, pageSize);
        return JsonResult.success(page);
    }


    @ApiOperation(value = "查询款式详情", notes = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail")
    public JsonResult<BaseProduce> queryProduceDetail(Integer id) {
        BaseProduce baseProduce = baseProduceService.getProduceForDetail(id);
        return JsonResult.success(baseProduce);
    }

    @ApiOperation(value = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail2")
    public JsonResult<QueryProduceDetailRespDTO> queryProduceDetail2(@RequestParam Integer id) {


        BaseProduce produce = baseProduceService.getProduceForDetail(id);
        QueryProduceDetailRespDTO data = new QueryProduceDetailRespDTO();

        //款式
        data.setProduce(produce);
        //服务
        data.setServe(produce.getServe());
        return JsonResult.success(data);
    }


    @PostMapping("/customer/serve/praiseProduce")
    @ApiOperation(value = "款式点赞和取消点赞", notes = "款式点赞")
    public JsonResult<Void> praiseProduce(@RequestHeader String token,
                                          @RequestParam Integer produceId) {
        baseProduceService.praiseProduce(produceId);
        return JsonResult.success();
    }


}
