package com.gogirl.interfaces.product.mall;

import com.gogirl.application.order.mall.MallShoppingCartService;
import com.gogirl.application.product.mall.MallShoppingCartCmdService;
import com.gogirl.application.product.mall.MallShoppingCartQryService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.product.DecreaseCartCommand;
import com.gogirl.shared.product.MallShoppingCartCommand;
import com.gogirl.shared.product.RemoveAllCartCommand;
import com.gogirl.shared.product.RemoveCartCommand;
import com.gogirl.shared.product.MyMallShoppingCartDTO;
import com.gogirl.shared.product.MyShoppingCartQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.security.InvalidParameterException;

@Api(tags = "version3.0:购物车接口", value = "version3.0:购物车接口")
@RestController
@AllArgsConstructor
public class MallShoppingCartController {

    private final MallShoppingCartService mallShoppingCartService;

    private final GogirlTokenService gogirlTokenService;
    private final MallShoppingCartQryService mallShoppingCartQryService;
    private final MallShoppingCartCmdService mallShoppingCartCmdService;

    @ApiOperation("添加购物车")
    @PostMapping("/customer/mallCart/addMallShoppingCart")
    public JsonResult<Void> addMallShoppingCart(@RequestHeader String token,
                                                @RequestBody MallShoppingCartCommand cmd) {
        Integer currentCustomerId = SessionUtils.getCustomerId();

        cmd.setCustomerId(currentCustomerId);
        if (cmd.getProductId() == null ||
                cmd.getNum() == null) {
            throw new InvalidParameterException();
        }

        mallShoppingCartCmdService.addMallShoppingCart(cmd);
        return JsonResult.success();
    }

    @ApiOperation("查看我的购物车")
    @PostMapping("/customer/mallCart/listMallShoppingCart")
    public JsonResult<MyMallShoppingCartDTO> listMallShoppingCart(@RequestHeader String token) {
        Integer currentCustomerId = SessionUtils.getCustomerId();

        MyShoppingCartQuery qry = new MyShoppingCartQuery(currentCustomerId);
        MyMallShoppingCartDTO myMallShoppingCartDTO = mallShoppingCartQryService.queryMyShoppingCart(qry);
        return JsonResult.success(myMallShoppingCartDTO);
    }

    @ApiOperation("清空购物车")
    @GetMapping("/customer/mallCart/removeAllMallShoppingCart")
    public JsonResult<Void> removeAllMallShoppingCart(@RequestHeader String token) {
        Integer currentCustomerId = SessionUtils.getCustomerId();

        RemoveAllCartCommand cmd = new RemoveAllCartCommand(currentCustomerId);
        mallShoppingCartCmdService.removeAllMallShoppingCart(cmd);
        return JsonResult.success();
    }

    @ApiOperation("删除购物车项")
    @GetMapping("/customer/mallCart/removeMallShoppingCart/{id}")
    public JsonResult<Integer> removeMallShoppingCart(@RequestHeader String token,
                                                      @ApiParam("购物车id")
                                                      @PathVariable Long id) {
        Integer currentCustomerId = SessionUtils.getCustomerId();

        RemoveCartCommand cmd = new RemoveCartCommand(id);
        mallShoppingCartCmdService.removeMallShoppingCart(cmd);
        return JsonResult.success();
    }

    @ApiOperation("减少购物车项")
    @GetMapping("/customer/mallCart/decreaseMallShoppingCart/{id}")
    public JsonResult<Integer> decreaseMallShoppingCart(@RequestHeader String token,
                                                        @ApiParam("产品id")
                                                        @PathVariable Long id) {
        Integer currentCustomerId = SessionUtils.getCustomerId();

        DecreaseCartCommand cmd = new DecreaseCartCommand(currentCustomerId, id);
        mallShoppingCartCmdService.decreaseMallShoppingCart(cmd);
        return JsonResult.success();
    }


}
