package com.gogirl.infrastructure.config.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import com.gogirl.infrastructure.config.property.WxMaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

@Configuration
public class WxMaConfiguration {
    private static WxMaService wxMaService = null;
    // 此处获取配置的方式可以改成你自己的方式，也可以注解等方式获取配置等。
//	private static final String appId = "wx058b46db3cd0e979";
//	private static final String secret = "7f4d1707caf9abaaf0b37aa03e6674f3";
    @Resource
    WxMaProperties properties;

    public static WxMaService getWxMaService() {
        return wxMaService;
    }

    @Bean
    public Object services() {
        WxMaInMemoryConfig config = new WxMaInMemoryConfig();
        config.setAppid(properties.getAppId());
        config.setSecret(properties.getSecret());

        wxMaService = new WxMaServiceImpl();
        wxMaService.setWxMaConfig(config);

        return Boolean.TRUE;
    }
}
