package com.gogirl.application.user.customer;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.gogirl.domain.user.customer.CustomerBalance;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import com.gogirl.shared.user.command.ConsumerCommand;

public interface CustomerBalanceService extends IService<CustomerBalance> {

    /**
     * 查询用户余额
     *
     * @param customerId 用户id
     * @return 用户会员卡
     */
    CustomerBalance getCustomerBalance(int customerId);


    /**
     * 余额消费
     *
     * @param consumerCmd
     */
    void consumer(ConsumerCommand consumerCmd);

    /**
     * 查看消费记录
     *
     * @param customerId 用户id
     * @param pageNum    页码
     * @param pageSize   分页长度
     * @return 用户消费记录分页查询结果
     */
    PageInfo<CustomerBalanceRecord> getBalanceRecordCard(Integer customerId, int pageNum, int pageSize);
}
